/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.SystemTime;

public class Average {
    private final int refreshRate;
    private final int period;
    private final int nbElements;
    private long lastUpdate;
    private long[] values;

    private Average(int _refreshRate, int _period) {
        this.refreshRate = _refreshRate;
        this.period = _period;
        this.nbElements = _period * 1000 / _refreshRate + 2;
        this.lastUpdate = this.getEffectiveTime() / (long)_refreshRate;
    }

    public static Average getInstance(int refreshRate, int period) {
        if (refreshRate < 100) {
            return null;
        }
        if (period * 1000 < refreshRate) {
            return null;
        }
        return new Average(refreshRate, period);
    }

    private void update(long timeFactor) {
        if (this.lastUpdate < timeFactor - (long)this.nbElements) {
            this.lastUpdate = timeFactor - (long)this.nbElements - 1L;
        }
        if (this.values != null) {
            for (long i2 = this.lastUpdate + 1L; i2 <= timeFactor; ++i2) {
                this.values[(int)(i2 % (long)this.nbElements)] = 0L;
            }
            this.values[(int)((timeFactor + 1L) % (long)this.nbElements)] = 0L;
        }
        this.lastUpdate = timeFactor;
    }

    synchronized void addValue(long value) {
        if (this.values == null && value != 0L) {
            this.values = new long[this.nbElements];
        }
        if (this.values != null) {
            long timeFactor = this.getEffectiveTime() / (long)this.refreshRate;
            this.update(timeFactor);
            int n = (int)(timeFactor % (long)this.nbElements);
            this.values[n] = this.values[n] + value;
        }
    }

    long getAverage() {
        return this.getSum() / (long)this.period;
    }

    private synchronized long getSum() {
        long sum = 0L;
        if (this.values != null) {
            long timeFactor = this.getEffectiveTime() / (long)this.refreshRate;
            this.update(timeFactor);
            for (long i2 = timeFactor + 2L; i2 < timeFactor + (long)this.nbElements; ++i2) {
                sum += this.values[(int)(i2 % (long)this.nbElements)];
            }
        }
        return sum;
    }

    private long getEffectiveTime() {
        return SystemTime.getSteppedMonotonousTime();
    }
}

