/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.LinkedList;
import org.gudy.azureus2.core3.util.AESemaphore2;
import org.gudy.azureus2.core3.util.SystemTime;

abstract class AEThread2 {
    private static final int MIN_RETAINED = Math.max(Runtime.getRuntime().availableProcessors(), 2);
    private static final int MAX_RETAINED = Math.max(MIN_RETAINED * 4, 16);
    private static final int THREAD_TIMEOUT_CHECK_PERIOD = 10000;
    private static final int THREAD_TIMEOUT = 60000;
    private static final LinkedList<threadWrapper> daemon_threads = new LinkedList();
    private static long last_timeout_check;
    private final boolean daemon;
    private threadWrapper wrapper;
    private String name;
    private int priority = 5;
    private volatile JoinLock lock = new JoinLock();

    AEThread2(String _name, boolean _daemon) {
        this.name = _name;
        this.daemon = _daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.lock.released) {
                this.lock = new JoinLock();
            }
        }
        if (this.daemon) {
            object = daemon_threads;
            synchronized (object) {
                if (daemon_threads.isEmpty()) {
                    this.wrapper = new threadWrapper(this.name, true);
                } else {
                    this.wrapper = daemon_threads.removeLast();
                    this.wrapper.setName(this.name);
                }
            }
        } else {
            this.wrapper = new threadWrapper(this.name, false);
        }
        if (this.priority != this.wrapper.getPriority()) {
            this.wrapper.setPriority(this.priority);
        }
        this.wrapper.currentLock = this.lock;
        this.wrapper.start(this, this.name);
    }

    void setPriority(int _priority) {
        this.priority = _priority;
        if (this.wrapper != null) {
            this.wrapper.setPriority(this.priority);
        }
    }

    String getName() {
        return this.name;
    }

    void setName(String s) {
        this.name = s;
        if (this.wrapper != null) {
            this.wrapper.setName(this.name);
        }
    }

    public String toString() {
        if (this.wrapper == null) {
            return this.name + " [daemon=" + this.daemon + ",priority=" + this.priority + "]";
        }
        return this.wrapper.toString();
    }

    protected abstract void run();

    private static final class JoinLock {
        volatile boolean released = false;

        private JoinLock() {
        }
    }

    static class threadWrapper
    extends Thread {
        private AESemaphore2 sem;
        private AEThread2 target;
        private JoinLock currentLock;
        private long last_active_time;

        threadWrapper(String name, boolean daemon) {
            super(name);
            this.setDaemon(daemon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            do {
                Object object = this.currentLock;
                synchronized (object) {
                    try {
                        this.target.run();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    finally {
                        this.target = null;
                        this.currentLock.released = true;
                        this.currentLock.notifyAll();
                    }
                }
                if (this.isInterrupted() || !Thread.currentThread().isDaemon()) break;
                object = daemon_threads;
                synchronized (object) {
                    this.last_active_time = SystemTime.getCurrentTime();
                    if (this.last_active_time < last_timeout_check || this.last_active_time - last_timeout_check > 10000L) {
                        last_timeout_check = this.last_active_time;
                        while (daemon_threads.size() > 0 && daemon_threads.size() > MIN_RETAINED) {
                            threadWrapper thread2 = daemon_threads.getFirst();
                            long thread_time = thread2.last_active_time;
                            if (this.last_active_time >= thread_time && this.last_active_time - thread_time <= 60000L) break;
                            daemon_threads.removeFirst();
                            thread2.retire();
                        }
                    }
                    if (daemon_threads.size() >= MAX_RETAINED) {
                        return;
                    }
                    daemon_threads.addLast(this);
                    this.setName("AEThread2:parked[" + daemon_threads.size() + "]");
                }
                this.sem.reserve();
            } while (this.target != null);
        }

        void start(AEThread2 _target, String _name) {
            this.target = _target;
            this.setName(_name);
            if (this.sem == null) {
                this.sem = new AESemaphore2();
                super.start();
            } else {
                this.sem.release();
            }
        }

        void retire() {
            this.sem.release();
        }
    }
}

