/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.WeakHashMap;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.LayoutCallback;
import net.miginfocom.layout.LayoutUtil;
import net.miginfocom.layout.LinkHandler;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.layout.ResizeConstraint;
import net.miginfocom.layout.UnitValue;

public final class Grid {
    static final boolean TEST_GAPS = true;
    private static final Float[] GROW_100 = new Float[]{ResizeConstraint.WEIGHT_100};
    private static final DimConstraint DOCK_DIM_CONSTRAINT = new DimConstraint();
    private static final int MAX_GRID = 30000;
    private static final int MAX_DOCK_GRID = Short.MAX_VALUE;
    private static final ResizeConstraint GAP_RC_CONST = new ResizeConstraint(200, ResizeConstraint.WEIGHT_100, 50, null);
    private static final ResizeConstraint GAP_RC_CONST_PUSH = new ResizeConstraint(200, ResizeConstraint.WEIGHT_100, 50, ResizeConstraint.WEIGHT_100);
    private static WeakHashMap[] PARENT_ROWCOL_SIZES_MAP = null;
    private static WeakHashMap<Object, LinkedHashMap<Integer, Cell>> PARENT_GRIDPOS_MAP = null;
    private final LC lc;
    private final ContainerWrapper container;
    private final LinkedHashMap<Integer, Cell> grid = new LinkedHashMap();
    private final TreeSet<Integer> rowIndexes = new TreeSet();
    private final TreeSet<Integer> colIndexes = new TreeSet();
    private final AC rowConstr;
    private final AC colConstr;
    private final ArrayList<LinkedDimGroup>[] colGroupLists;
    private final ArrayList<LinkedDimGroup>[] rowGroupLists;
    private final int dockOffY;
    private final int dockOffX;
    private final Float[] pushXs;
    private final Float[] pushYs;
    private final ArrayList<LayoutCallback> callbackList;
    private HashMap<Integer, BoundSize> wrapGapMap = null;
    private FlowSizeSpec colFlowSpecs = null;
    private FlowSizeSpec rowFlowSpecs = null;
    private int[] width = null;
    private int[] height = null;
    private ArrayList<int[]> debugRects = null;
    private HashMap<String, Boolean> linkTargetIDs = null;

    public Grid(ContainerWrapper container, LC lc, AC rowConstr, AC colConstr, Map<ComponentWrapper, CC> ccMap, ArrayList<LayoutCallback> callbackList) {
        int i2;
        String sgx;
        ArrayList<CompWrap> sizeGroupCWs;
        Object sizeGroupMapY;
        CompWrap cw;
        this.lc = lc;
        this.rowConstr = rowConstr;
        this.colConstr = colConstr;
        this.container = container;
        this.callbackList = callbackList;
        int wrap = lc.getWrapAfter() != 0 ? lc.getWrapAfter() : (lc.isFlowX() ? colConstr : rowConstr).getConstaints().length;
        ComponentWrapper[] comps = container.getComponents();
        boolean hasTagged = false;
        boolean hasPushX = false;
        boolean hasPushY = false;
        boolean hitEndOfRow = false;
        int[] cellXY = new int[2];
        ArrayList<int[]> spannedRects = new ArrayList<int[]>(2);
        Object[] specs = (lc.isFlowX() ? rowConstr : colConstr).getConstaints();
        int sizeGroupsX = 0;
        int sizeGroupsY = 0;
        int[] dockInsets = null;
        LinkHandler.clearTemporaryBounds(container.getLayout());
        int i3 = 0;
        while (i3 < comps.length) {
            boolean spanRestOfRow;
            Cell cell;
            int hideMode;
            ComponentWrapper comp = comps[i3];
            CC rootCc = Grid.getCC(comp, ccMap);
            this.addLinkIDs(rootCc);
            int n = comp.isVisible() ? -1 : (hideMode = rootCc.getHideMode() != -1 ? rootCc.getHideMode() : lc.getHideMode());
            if (hideMode == 3) {
                this.setLinkedBounds(comp, rootCc, comp.getX(), comp.getY(), comp.getWidth(), comp.getHeight(), rootCc.isExternal());
                ++i3;
                continue;
            }
            if (rootCc.getHorizontal().getSizeGroup() != null) {
                ++sizeGroupsX;
            }
            if (rootCc.getVertical().getSizeGroup() != null) {
                ++sizeGroupsY;
            }
            UnitValue[] pos = this.getPos(comp, rootCc);
            BoundSize[] cbSz = this.getCallbackSize(comp);
            if (pos != null || rootCc.isExternal()) {
                cw = new CompWrap(comp, rootCc, hideMode, pos, cbSz);
                cell = this.grid.get(null);
                if (cell == null) {
                    this.grid.put(null, new Cell(cw));
                } else {
                    cell.compWraps.add(cw);
                }
                if (!rootCc.isBoundsInGrid() || rootCc.isExternal()) {
                    this.setLinkedBounds(comp, rootCc, comp.getX(), comp.getY(), comp.getWidth(), comp.getHeight(), rootCc.isExternal());
                    ++i3;
                    continue;
                }
            }
            if (rootCc.getDockSide() != -1) {
                if (dockInsets == null) {
                    dockInsets = new int[]{-32767, -32767, Short.MAX_VALUE, Short.MAX_VALUE};
                }
                this.addDockingCell(dockInsets, rootCc.getDockSide(), new CompWrap(comp, rootCc, hideMode, pos, cbSz));
                ++i3;
                continue;
            }
            Boolean cellFlowX = rootCc.getFlowX();
            cell = null;
            if (rootCc.isNewline()) {
                this.wrap(cellXY, rootCc.getNewlineGapSize());
            } else if (hitEndOfRow) {
                this.wrap(cellXY, null);
            }
            hitEndOfRow = false;
            boolean rowNoGrid = lc.isNoGrid() || ((DimConstraint)LayoutUtil.getIndexSafe(specs, lc.isFlowX() ? cellXY[1] : cellXY[0])).isNoGrid();
            int cx = rootCc.getCellX();
            int cy = rootCc.getCellY();
            if (!(cx >= 0 && cy >= 0 || rowNoGrid || rootCc.getSkip() != 0)) {
                while (!this.isCellFree(cellXY[1], cellXY[0], spannedRects)) {
                    if (Math.abs(this.increase(cellXY, 1)) < wrap) continue;
                    this.wrap(cellXY, null);
                }
            } else {
                if (cx >= 0 && cy >= 0) {
                    if (cy >= 0) {
                        cellXY[0] = cx;
                        cellXY[1] = cy;
                    } else if (lc.isFlowX()) {
                        cellXY[0] = cx;
                    } else {
                        cellXY[1] = cx;
                    }
                }
                cell = this.getCell(cellXY[1], cellXY[0]);
            }
            int skipCount = rootCc.getSkip();
            for (int s = 0; s < skipCount; ++s) {
                do {
                    if (Math.abs(this.increase(cellXY, 1)) < wrap) continue;
                    this.wrap(cellXY, null);
                } while (!this.isCellFree(cellXY[1], cellXY[0], spannedRects));
            }
            if (cell == null) {
                int spanx = Math.min(rowNoGrid && lc.isFlowX() ? 2097051 : rootCc.getSpanX(), 30000 - cellXY[0]);
                int spany = Math.min(rowNoGrid && !lc.isFlowX() ? 2097051 : rootCc.getSpanY(), 30000 - cellXY[1]);
                cell = new Cell(spanx, spany, cellFlowX != null ? cellFlowX.booleanValue() : lc.isFlowX());
                this.setCell(cellXY[1], cellXY[0], cell);
                if (spanx > 1 || spany > 1) {
                    spannedRects.add(new int[]{cellXY[0], cellXY[1], spanx, spany});
                }
            }
            boolean wrapHandled = false;
            boolean splitExit = false;
            boolean bl = spanRestOfRow = (lc.isFlowX() ? rootCc.getSpanX() : rootCc.getSpanY()) == 2097051;
            for (int splitLeft = rowNoGrid ? 2097051 : rootCc.getSplit() - 1; splitLeft >= 0 && i3 < comps.length; --splitLeft) {
                ComponentWrapper compAdd = comps[i3];
                CC cc = Grid.getCC(compAdd, ccMap);
                this.addLinkIDs(cc);
                boolean visible = compAdd.isVisible();
                int n2 = visible ? -1 : (hideMode = cc.getHideMode() != -1 ? cc.getHideMode() : lc.getHideMode());
                if (cc.isExternal() || hideMode == 3) {
                    ++i3;
                    ++splitLeft;
                    continue;
                }
                hasPushX |= (visible || hideMode > 1) && cc.getPushX() != null;
                hasPushY |= (visible || hideMode > 1) && cc.getPushY() != null;
                if (cc != rootCc) {
                    if (cc.isNewline() || !cc.isBoundsInGrid() || cc.getDockSide() != -1) break;
                    if (splitLeft > 0 && cc.getSkip() > 0) {
                        splitExit = true;
                        break;
                    }
                    pos = this.getPos(compAdd, cc);
                    cbSz = this.getCallbackSize(compAdd);
                }
                CompWrap cw2 = new CompWrap(compAdd, cc, hideMode, pos, cbSz);
                cell.compWraps.add(cw2);
                cell.hasTagged = cell.hasTagged | cc.getTag() != null;
                hasTagged |= cell.hasTagged;
                if (cc != rootCc) {
                    if (cc.getHorizontal().getSizeGroup() != null) {
                        ++sizeGroupsX;
                    }
                    if (cc.getVertical().getSizeGroup() != null) {
                        ++sizeGroupsY;
                    }
                }
                ++i3;
                if (!cc.isWrap() && (!spanRestOfRow || splitLeft != 0)) continue;
                if (cc.isWrap()) {
                    this.wrap(cellXY, cc.getWrapGapSize());
                } else {
                    hitEndOfRow = true;
                }
                wrapHandled = true;
                break;
            }
            if (wrapHandled || rowNoGrid) continue;
            int span = lc.isFlowX() ? cell.spanx : cell.spany;
            if (Math.abs(lc.isFlowX() ? cellXY[0] : cellXY[1]) + span >= wrap) {
                hitEndOfRow = true;
                continue;
            }
            this.increase(cellXY, splitExit ? span - 1 : span);
        }
        if (sizeGroupsX > 0 || sizeGroupsY > 0) {
            HashMap<String, int[]> sizeGroupMapX = sizeGroupsX > 0 ? new HashMap<String, int[]>(sizeGroupsX) : null;
            sizeGroupMapY = sizeGroupsY > 0 ? new HashMap(sizeGroupsY) : null;
            sizeGroupCWs = new ArrayList<CompWrap>(Math.max(sizeGroupsX, sizeGroupsY));
            for (Cell cell : this.grid.values()) {
                for (int i4 = 0; i4 < cell.compWraps.size(); ++i4) {
                    cw = cell.compWraps.get(i4);
                    sgx = cw.cc.getHorizontal().getSizeGroup();
                    String sgy = cw.cc.getVertical().getSizeGroup();
                    if (sgx == null && sgy == null) continue;
                    if (sgx != null && sizeGroupMapX != null) {
                        Grid.addToSizeGroup(sizeGroupMapX, sgx, cw.horSizes);
                    }
                    if (sgy != null && sizeGroupMapY != null) {
                        Grid.addToSizeGroup((HashMap<String, int[]>)sizeGroupMapY, sgy, cw.verSizes);
                    }
                    sizeGroupCWs.add(cw);
                }
            }
            for (CompWrap cw3 : sizeGroupCWs) {
                if (sizeGroupMapX != null) {
                    cw3.setSizes((int[])sizeGroupMapX.get(cw3.cc.getHorizontal().getSizeGroup()), true);
                }
                if (sizeGroupMapY == null) continue;
                cw3.setSizes((int[])((HashMap)sizeGroupMapY).get(cw3.cc.getVertical().getSizeGroup()), false);
            }
        }
        if (sizeGroupsX > 0 || sizeGroupsY > 0) {
            HashMap<String, int[]> sizeGroupMapX = sizeGroupsX > 0 ? new HashMap<String, int[]>(sizeGroupsX) : null;
            sizeGroupMapY = sizeGroupsY > 0 ? new HashMap(sizeGroupsY) : null;
            sizeGroupCWs = new ArrayList(Math.max(sizeGroupsX, sizeGroupsY));
            for (Cell cell : this.grid.values()) {
                for (int i5 = 0; i5 < cell.compWraps.size(); ++i5) {
                    cw = cell.compWraps.get(i5);
                    sgx = cw.cc.getHorizontal().getSizeGroup();
                    String sgy = cw.cc.getVertical().getSizeGroup();
                    if (sgx == null && sgy == null) continue;
                    if (sgx != null && sizeGroupMapX != null) {
                        Grid.addToSizeGroup(sizeGroupMapX, sgx, cw.horSizes);
                    }
                    if (sgy != null && sizeGroupMapY != null) {
                        Grid.addToSizeGroup((HashMap<String, int[]>)sizeGroupMapY, sgy, cw.verSizes);
                    }
                    sizeGroupCWs.add(cw);
                }
            }
            for (CompWrap cw3 : sizeGroupCWs) {
                if (sizeGroupMapX != null) {
                    cw3.setSizes((int[])sizeGroupMapX.get(cw3.cc.getHorizontal().getSizeGroup()), true);
                }
                if (sizeGroupMapY == null) continue;
                cw3.setSizes((int[])((HashMap)sizeGroupMapY).get(cw3.cc.getVertical().getSizeGroup()), false);
            }
        }
        if (hasTagged) {
            Grid.sortCellsByPlatform(this.grid.values(), container);
        }
        boolean ltr = LayoutUtil.isLeftToRight(lc, container);
        for (Cell cell : this.grid.values()) {
            ArrayList<CompWrap> cws = cell.compWraps;
            int lastI = cws.size() - 1;
            for (int i6 = 0; i6 <= lastI; ++i6) {
                cw = cws.get(i6);
                ComponentWrapper cwBef = i6 > 0 ? cws.get((int)(i6 - 1)).comp : null;
                ComponentWrapper cwAft = i6 < lastI ? cws.get((int)(i6 + 1)).comp : null;
                String tag = Grid.getCC(cw.comp, ccMap).getTag();
                CC ccBef = cwBef != null ? Grid.getCC(cwBef, ccMap) : null;
                CC ccAft = cwAft != null ? Grid.getCC(cwAft, ccMap) : null;
                cw.calcGaps(cwBef, ccBef, cwAft, ccAft, tag, cell.flowx, ltr);
            }
        }
        this.dockOffX = Grid.getDockInsets(this.colIndexes);
        this.dockOffY = Grid.getDockInsets(this.rowIndexes);
        int iSz = rowConstr.getCount();
        for (i2 = 0; i2 < iSz; ++i2) {
            this.rowIndexes.add(i2);
        }
        iSz = colConstr.getCount();
        for (i2 = 0; i2 < iSz; ++i2) {
            this.colIndexes.add(i2);
        }
        this.colGroupLists = this.divideIntoLinkedGroups(false);
        this.rowGroupLists = this.divideIntoLinkedGroups(true);
        this.pushXs = hasPushX || lc.isFillX() ? this.getDefaultPushWeights(false) : null;
        Object object = this.pushYs = hasPushY || lc.isFillY() ? this.getDefaultPushWeights(true) : null;
        if (LayoutUtil.isDesignTime(container)) {
            Grid.saveGrid(container, this.grid);
        }
    }

    private static CC getCC(ComponentWrapper comp, Map<ComponentWrapper, CC> ccMap) {
        CC cc = ccMap.get(comp);
        return cc != null ? cc : new CC();
    }

    private static int getDockInsets(TreeSet<Integer> set) {
        int c = 0;
        for (Integer i2 : set) {
            if (i2 >= -30000) break;
            ++c;
        }
        return c;
    }

    private static void sortCellsByPlatform(Collection<Cell> cells, ContainerWrapper parent) {
        String order = PlatformDefaults.getButtonOrder();
        String orderLo = order.toLowerCase();
        int unrelSize = PlatformDefaults.convertToPixels(1.0f, "u", true, 0.0f, parent, null);
        if (unrelSize == -87654312) {
            throw new IllegalArgumentException("'unrelated' not recognized by PlatformDefaults!");
        }
        int[] gapUnrel = new int[]{unrelSize, unrelSize, -2147471302};
        int[] flGap = new int[]{0, 0, -2147471302};
        for (Cell cell : cells) {
            if (!cell.hasTagged) continue;
            CompWrap prevCW = null;
            boolean nextUnrel = false;
            boolean nextPush = false;
            ArrayList<CompWrap> sortedList = new ArrayList<CompWrap>(cell.compWraps.size());
            int iSz = orderLo.length();
            for (int i2 = 0; i2 < iSz; ++i2) {
                char c = orderLo.charAt(i2);
                if (c == '+' || c == '_') {
                    nextUnrel = true;
                    if (c != '+') continue;
                    nextPush = true;
                    continue;
                }
                String tag = PlatformDefaults.getTagForChar(c);
                if (tag == null) continue;
                int jSz = cell.compWraps.size();
                for (int j = 0; j < jSz; ++j) {
                    CompWrap cw = cell.compWraps.get(j);
                    if (!tag.equals(cw.cc.getTag())) continue;
                    if (Character.isUpperCase(order.charAt(i2))) {
                        int min = PlatformDefaults.getMinimumButtonWidth().getPixels(0.0f, parent, cw.comp);
                        if (min > cw.horSizes[0]) {
                            cw.horSizes[0] = min;
                        }
                        Grid.correctMinMax(cw.horSizes);
                    }
                    sortedList.add(cw);
                    if (nextUnrel) {
                        (prevCW != null ? prevCW : cw).mergeGapSizes(gapUnrel, cell.flowx, prevCW == null);
                        if (nextPush) {
                            cw.forcedPushGaps = 1;
                            nextUnrel = false;
                            nextPush = false;
                        }
                    }
                    if (c == 'u') {
                        nextUnrel = true;
                    }
                    prevCW = cw;
                }
            }
            if (sortedList.size() > 0) {
                CompWrap cw = (CompWrap)sortedList.get(sortedList.size() - 1);
                if (nextUnrel) {
                    cw.mergeGapSizes(gapUnrel, cell.flowx, false);
                    if (nextPush) {
                        cw.forcedPushGaps |= 2;
                    }
                }
                if (cw.cc.getHorizontal().getGapAfter() == null) {
                    cw.setGaps(flGap, 3);
                }
                cw = (CompWrap)sortedList.get(0);
                if (cw.cc.getHorizontal().getGapBefore() == null) {
                    cw.setGaps(flGap, 1);
                }
            }
            if (cell.compWraps.size() == sortedList.size()) {
                cell.compWraps.clear();
            } else {
                cell.compWraps.removeAll(sortedList);
            }
            cell.compWraps.addAll(sortedList);
        }
    }

    private static LinkedDimGroup getGroupContaining(ArrayList<LinkedDimGroup>[] groupLists, CompWrap cw) {
        for (ArrayList<LinkedDimGroup> groups2 : groupLists) {
            for (LinkedDimGroup group : groups2) {
                ArrayList<CompWrap> cwList = group._compWraps;
                for (CompWrap compWrap : cwList) {
                    if (compWrap != cw) continue;
                    return group;
                }
            }
        }
        return null;
    }

    private static void addToSizeGroup(HashMap<String, int[]> sizeGroups, String sizeGroup, int[] size) {
        int[] sgSize = sizeGroups.get(sizeGroup);
        if (sgSize == null) {
            sizeGroups.put(sizeGroup, new int[]{size[0], size[1], size[2]});
        } else {
            sgSize[0] = Math.max(size[0], sgSize[0]);
            sgSize[1] = Math.max(size[1], sgSize[1]);
            sgSize[2] = Math.min(size[2], sgSize[2]);
        }
    }

    private static HashMap<String, Integer> addToEndGroup(HashMap<String, Integer> endGroups, String endGroup, int end) {
        if (endGroup != null) {
            Integer oldEnd;
            if (endGroups == null) {
                endGroups = new HashMap(2);
            }
            if ((oldEnd = endGroups.get(endGroup)) == null || end > oldEnd) {
                endGroups.put(endGroup, end);
            }
        }
        return endGroups;
    }

    private static int getParentSize(ComponentWrapper cw, boolean isHor) {
        ContainerWrapper p = cw.getParent();
        return p != null ? (isHor ? cw.getWidth() : cw.getHeight()) : 0;
    }

    private static ResizeConstraint[] getRowResizeConstraints(DimConstraint[] specs) {
        ResizeConstraint[] resConsts = new ResizeConstraint[specs.length];
        for (int i2 = 0; i2 < resConsts.length; ++i2) {
            resConsts[i2] = specs[i2].resize;
        }
        return resConsts;
    }

    private static ResizeConstraint[] getComponentResizeConstraints(ArrayList<CompWrap> compWraps, boolean isHor) {
        ResizeConstraint[] resConsts = new ResizeConstraint[compWraps.size()];
        for (int i2 = 0; i2 < resConsts.length; ++i2) {
            CC fc = compWraps.get((int)i2).cc;
            resConsts[i2] = fc.getDimConstraint((boolean)isHor).resize;
            int dock = fc.getDockSide();
            if (!(isHor ? dock == 0 || dock == 2 : dock == 1 || dock == 3)) continue;
            ResizeConstraint dc = resConsts[i2];
            resConsts[i2] = new ResizeConstraint(dc.shrinkPrio, dc.shrink, dc.growPrio, ResizeConstraint.WEIGHT_100);
        }
        return resConsts;
    }

    private static boolean[] getComponentGapPush(ArrayList<CompWrap> compWraps, boolean isHor) {
        boolean[] barr = new boolean[compWraps.size() + 1];
        for (int i2 = 0; i2 < barr.length; ++i2) {
            boolean push;
            boolean bl = push = i2 > 0 && compWraps.get(i2 - 1).isPushGap(isHor, false);
            if (!push && i2 < barr.length - 1) {
                push = compWraps.get(i2).isPushGap(isHor, true);
            }
            barr[i2] = push;
        }
        return barr;
    }

    private static int[][] getGaps(ArrayList<CompWrap> compWraps, boolean isHor) {
        int compCount = compWraps.size();
        int[][] retValues = new int[compCount + 1][];
        retValues[0] = compWraps.get(0).getGaps(isHor, true);
        for (int i2 = 0; i2 < compCount; ++i2) {
            int[] gap1 = compWraps.get(i2).getGaps(isHor, false);
            int[] gap2 = i2 < compCount - 1 ? compWraps.get(i2 + 1).getGaps(isHor, true) : null;
            retValues[i2 + 1] = Grid.mergeSizes(gap1, gap2);
        }
        return retValues;
    }

    private static int convertSpanToSparseGrid(int curIx, int span, TreeSet<Integer> indexes) {
        int lastIx = curIx + span;
        int retSpan = 1;
        for (Integer ix : indexes) {
            if (ix <= curIx) continue;
            if (ix >= lastIx) break;
            ++retSpan;
        }
        return retSpan;
    }

    private static void layoutBaseline(ContainerWrapper parent, ArrayList<CompWrap> compWraps, DimConstraint dc, int start, int size, int spanCount) {
        int[] aboveBelow = Grid.getBaselineAboveBelow(compWraps, 1, true);
        int blRowSize = aboveBelow[0] + aboveBelow[1];
        CC cc = compWraps.get((int)0).cc;
        UnitValue align = cc.getVertical().getAlign();
        if (spanCount == 1 && align == null) {
            align = dc.getAlignOrDefault(false);
        }
        if (align == UnitValue.BASELINE_IDENTITY) {
            align = UnitValue.CENTER;
        }
        int offset = start + aboveBelow[0] + (align != null ? Math.max(0, align.getPixels(size - blRowSize, parent, null)) : 0);
        for (CompWrap cw : compWraps) {
            cw.y += offset;
            if (cw.y + cw.h <= start + size) continue;
            cw.h = start + size - cw.y;
        }
    }

    private static void layoutSerial(ContainerWrapper parent, ArrayList<CompWrap> compWraps, DimConstraint dc, int start, int size, boolean isHor, boolean fromEnd) {
        FlowSizeSpec fss = Grid.mergeSizesGapsAndResConstrs(Grid.getComponentResizeConstraints(compWraps, isHor), Grid.getComponentGapPush(compWraps, isHor), Grid.getComponentSizes(compWraps, isHor), Grid.getGaps(compWraps, isHor));
        Float[] pushW = dc.isFill() ? GROW_100 : null;
        int[] sizes = LayoutUtil.calculateSerial(fss.sizes, fss.resConstsInclGaps, pushW, 1, size);
        Grid.setCompWrapBounds(parent, sizes, compWraps, dc.getAlignOrDefault(isHor), start, size, isHor, fromEnd);
    }

    private static void setCompWrapBounds(ContainerWrapper parent, int[] allSizes, ArrayList<CompWrap> compWraps, UnitValue rowAlign, int start, int size, boolean isHor, boolean fromEnd) {
        int totSize = LayoutUtil.sum(allSizes);
        CC cc = compWraps.get((int)0).cc;
        UnitValue align = Grid.correctAlign(cc, rowAlign, isHor, fromEnd);
        int cSt = start;
        int slack = size - totSize;
        if (slack > 0 && align != null) {
            int al = Math.min(slack, Math.max(0, align.getPixels(slack, parent, null)));
            cSt += fromEnd ? -al : al;
        }
        int bIx = 0;
        int iSz = compWraps.size();
        for (int i2 = 0; i2 < iSz; ++i2) {
            CompWrap cw = compWraps.get(i2);
            if (fromEnd) {
                cw.setDimBounds((cSt -= allSizes[bIx++]) - allSizes[bIx], allSizes[bIx], isHor);
                cSt -= allSizes[bIx++];
                continue;
            }
            cw.setDimBounds(cSt += allSizes[bIx++], allSizes[bIx], isHor);
            cSt += allSizes[bIx++];
        }
    }

    private static void layoutParallel(ContainerWrapper parent, ArrayList<CompWrap> compWraps, DimConstraint dc, int start, int size, boolean isHor, boolean fromEnd) {
        int[][] sizes = new int[compWraps.size()][];
        for (int i2 = 0; i2 < sizes.length; ++i2) {
            CompWrap cw = compWraps.get(i2);
            DimConstraint cDc = cw.cc.getDimConstraint(isHor);
            ResizeConstraint[] resConstr = new ResizeConstraint[]{cw.isPushGap(isHor, true) ? GAP_RC_CONST_PUSH : GAP_RC_CONST, cDc.resize, cw.isPushGap(isHor, false) ? GAP_RC_CONST_PUSH : GAP_RC_CONST};
            int[][] sz = new int[][]{cw.getGaps(isHor, true), isHor ? cw.horSizes : cw.verSizes, cw.getGaps(isHor, false)};
            Float[] pushW = dc.isFill() ? GROW_100 : null;
            sizes[i2] = LayoutUtil.calculateSerial(sz, resConstr, pushW, 1, size);
        }
        UnitValue rowAlign = dc.getAlignOrDefault(isHor);
        Grid.setCompWrapBounds(parent, sizes, compWraps, rowAlign, start, size, isHor, fromEnd);
    }

    private static void setCompWrapBounds(ContainerWrapper parent, int[][] sizes, ArrayList<CompWrap> compWraps, UnitValue rowAlign, int start, int size, boolean isHor, boolean fromEnd) {
        for (int i2 = 0; i2 < sizes.length; ++i2) {
            CompWrap cw = compWraps.get(i2);
            UnitValue align = Grid.correctAlign(cw.cc, rowAlign, isHor, fromEnd);
            int[] cSizes = sizes[i2];
            int gapBef = cSizes[0];
            int cSize = cSizes[1];
            int gapAft = cSizes[2];
            int cSt = fromEnd ? start - gapBef : start + gapBef;
            int slack = size - cSize - gapBef - gapAft;
            if (slack > 0 && align != null) {
                int al = Math.min(slack, Math.max(0, align.getPixels(slack, parent, null)));
                cSt += fromEnd ? -al : al;
            }
            cw.setDimBounds(fromEnd ? cSt - cSize : cSt, cSize, isHor);
        }
    }

    private static UnitValue correctAlign(CC cc, UnitValue rowAlign, boolean isHor, boolean fromEnd) {
        UnitValue align = (isHor ? cc.getHorizontal() : cc.getVertical()).getAlign();
        if (align == null) {
            align = rowAlign;
        }
        if (align == UnitValue.BASELINE_IDENTITY) {
            align = UnitValue.CENTER;
        }
        if (fromEnd) {
            if (align == UnitValue.LEFT) {
                align = UnitValue.RIGHT;
            } else if (align == UnitValue.RIGHT) {
                align = UnitValue.LEFT;
            }
        }
        return align;
    }

    private static int[] getBaselineAboveBelow(ArrayList<CompWrap> compWraps, int sType, boolean centerBaseline) {
        int maxAbove = Short.MIN_VALUE;
        int maxBelow = Short.MIN_VALUE;
        for (CompWrap cw : compWraps) {
            int height = cw.getSize(sType, false);
            if (height >= 2097051) {
                return new int[]{1048525, 1048525};
            }
            int baseline = cw.getBaseline(sType);
            int above = baseline + cw.getGapBefore(sType, false);
            maxAbove = Math.max(above, maxAbove);
            maxBelow = Math.max(height - baseline + cw.getGapAfter(sType, false), maxBelow);
            if (!centerBaseline) continue;
            cw.setDimBounds(-baseline, height, false);
        }
        return new int[]{maxAbove, maxBelow};
    }

    private static int getTotalSizeParallel(ArrayList<CompWrap> compWraps, int sType, boolean isHor) {
        int size = sType == 2 ? 2097051 : 0;
        for (CompWrap cw : compWraps) {
            int cwSize = cw.getSizeInclGaps(sType, isHor);
            if (cwSize >= 2097051) {
                return 2097051;
            }
            if (!(sType == 2 ? cwSize < size : cwSize > size)) continue;
            size = cwSize;
        }
        return Grid.constrainSize(size);
    }

    private static int getTotalSizeSerial(ArrayList<CompWrap> compWraps, int sType, boolean isHor) {
        int totSize = 0;
        int iSz = compWraps.size();
        int lastGapAfter = 0;
        for (int i2 = 0; i2 < iSz; ++i2) {
            CompWrap wrap = compWraps.get(i2);
            int gapBef = wrap.getGapBefore(sType, isHor);
            if (gapBef > lastGapAfter) {
                totSize += gapBef - lastGapAfter;
            }
            totSize += wrap.getSize(sType, isHor);
            lastGapAfter = wrap.getGapAfter(sType, isHor);
            if ((totSize += lastGapAfter) < 2097051) continue;
            return 2097051;
        }
        return Grid.constrainSize(totSize);
    }

    private static int getTotalGroupsSizeParallel(ArrayList<LinkedDimGroup> groups2, int sType) {
        int size = sType == 2 ? 2097051 : 0;
        for (LinkedDimGroup group : groups2) {
            if (1 != group.span) continue;
            int grpSize = group.getMinPrefMax()[sType];
            if (grpSize >= 2097051) {
                return 2097051;
            }
            if (!(sType == 2 ? grpSize < size : grpSize > size)) continue;
            size = grpSize;
        }
        return Grid.constrainSize(size);
    }

    private static int[][] getComponentSizes(ArrayList<CompWrap> compWraps, boolean isHor) {
        int[][] compSizes = new int[compWraps.size()][];
        for (int i2 = 0; i2 < compSizes.length; ++i2) {
            CompWrap cw = compWraps.get(i2);
            compSizes[i2] = isHor ? cw.horSizes : cw.verSizes;
        }
        return compSizes;
    }

    private static FlowSizeSpec mergeSizesGapsAndResConstrs(ResizeConstraint[] resConstr, boolean[] gapPush, int[][] minPrefMaxSizes, int[][] gapSizes) {
        int[][] sizes = new int[(minPrefMaxSizes.length << 1) + 1][];
        ResizeConstraint[] resConstsInclGaps = new ResizeConstraint[sizes.length];
        sizes[0] = gapSizes[0];
        int i2 = 0;
        int crIx = 1;
        while (i2 < minPrefMaxSizes.length) {
            resConstsInclGaps[crIx] = resConstr[i2];
            sizes[crIx] = minPrefMaxSizes[i2];
            sizes[crIx + 1] = gapSizes[i2 + 1];
            if (sizes[crIx - 1] != null) {
                ResizeConstraint resizeConstraint = resConstsInclGaps[crIx - 1] = gapPush[i2 < gapPush.length ? i2 : gapPush.length - 1] ? GAP_RC_CONST_PUSH : GAP_RC_CONST;
            }
            if (i2 == minPrefMaxSizes.length - 1 && sizes[crIx + 1] != null) {
                resConstsInclGaps[crIx + 1] = gapPush[i2 + 1 < gapPush.length ? i2 + 1 : gapPush.length - 1] ? GAP_RC_CONST_PUSH : GAP_RC_CONST;
            }
            ++i2;
            crIx += 2;
        }
        for (i2 = 0; i2 < sizes.length; ++i2) {
            if (sizes[i2] != null) continue;
            sizes[i2] = new int[3];
        }
        return new FlowSizeSpec(sizes, resConstsInclGaps);
    }

    private static int[] mergeSizes(int[] oldValues, int[] newValues) {
        if (oldValues == null) {
            return newValues;
        }
        if (newValues == null) {
            return oldValues;
        }
        int[] ret = new int[oldValues.length];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = Grid.mergeSizes(oldValues[i2], newValues[i2]);
        }
        return ret;
    }

    private static int mergeSizes(int oldValue, int newValue) {
        if (oldValue == -2147471302 || oldValue == newValue) {
            return newValue;
        }
        if (newValue == -2147471302) {
            return oldValue;
        }
        return Math.max(oldValue, newValue);
    }

    private static int constrainSize(int s) {
        return s > 0 ? Math.min(s, 2097051) : 0;
    }

    private static void correctMinMax(int[] s) {
        if (s[0] > s[2]) {
            s[0] = s[2];
        }
        if (s[1] < s[0]) {
            s[1] = s[0];
        }
        if (s[1] > s[2]) {
            s[1] = s[2];
        }
    }

    private static Float[] extractSubArray(DimConstraint[] specs, Float[] arr, int ix, int len) {
        if (arr == null || arr.length < ix + len) {
            Float[] growLastArr = new Float[len];
            for (int i2 = ix + len - 1; i2 >= 0; i2 -= 2) {
                int specIx = i2 >> 1;
                if (specs[specIx] == DOCK_DIM_CONSTRAINT) continue;
                growLastArr[i2 - ix] = ResizeConstraint.WEIGHT_100;
                return growLastArr;
            }
            return growLastArr;
        }
        Float[] newArr = new Float[len];
        System.arraycopy(arr, ix, newArr, 0, len);
        return newArr;
    }

    private static synchronized void putSizesAndIndexes(Object parComp, int[] sizes, int[] ixArr, boolean isRows) {
        if (PARENT_ROWCOL_SIZES_MAP == null) {
            PARENT_ROWCOL_SIZES_MAP = new WeakHashMap[]{new WeakHashMap(4), new WeakHashMap(4)};
        }
        PARENT_ROWCOL_SIZES_MAP[isRows ? 0 : 1].put(parComp, new int[][]{ixArr, sizes});
    }

    private static synchronized void saveGrid(ComponentWrapper parComp, LinkedHashMap<Integer, Cell> grid) {
        if (PARENT_GRIDPOS_MAP == null) {
            PARENT_GRIDPOS_MAP = new WeakHashMap();
        }
        PARENT_GRIDPOS_MAP.put(parComp.getComponent(), grid);
    }

    static synchronized HashMap<Object, int[]> getGridPositions(Object parComp) {
        if (PARENT_GRIDPOS_MAP == null) {
            return null;
        }
        LinkedHashMap<Integer, Cell> grid = PARENT_GRIDPOS_MAP.get(parComp);
        if (grid == null) {
            return null;
        }
        HashMap<Object, int[]> retMap = new HashMap<Object, int[]>();
        for (Map.Entry<Integer, Cell> e : grid.entrySet()) {
            Cell cell = e.getValue();
            Integer xyInt = e.getKey();
            if (xyInt == null) continue;
            int x = xyInt & 0xFFFF;
            int y = xyInt >> 16;
            for (CompWrap cw : cell.compWraps) {
                retMap.put(cw.comp.getComponent(), new int[]{x, y, cell.spanx, cell.spany});
            }
        }
        return retMap;
    }

    private void addLinkIDs(CC cc) {
        String[] linkIDs;
        for (String linkID : linkIDs = cc.getLinkTargets()) {
            if (this.linkTargetIDs == null) {
                this.linkTargetIDs = new HashMap();
            }
            this.linkTargetIDs.put(linkID, null);
        }
    }

    public void invalidateContainerSize() {
        this.colFlowSpecs = null;
    }

    public boolean layout(int[] bounds, UnitValue alignX, UnitValue alignY, boolean debug, boolean checkPrefChange) {
        if (debug) {
            this.debugRects = new ArrayList();
        }
        this.checkSizeCalcs();
        this.resetLinkValues(true, true);
        this.layoutInOneDim(bounds[2], alignX, false, this.pushXs);
        this.layoutInOneDim(bounds[3], alignY, true, this.pushYs);
        HashMap<String, Integer> endGrpXMap = null;
        HashMap<String, Integer> endGrpYMap = null;
        int compCount = this.container.getComponentCount();
        boolean layoutAgain = false;
        if (compCount > 0) {
            block0: for (int j = 0; j < (this.linkTargetIDs != null ? 2 : 1); ++j) {
                boolean doAgain;
                int count = 0;
                do {
                    doAgain = false;
                    for (Cell cell : this.grid.values()) {
                        ArrayList<CompWrap> compWraps = cell.compWraps;
                        for (CompWrap cw : compWraps) {
                            if (j == 0) {
                                if (!(doAgain |= this.doAbsoluteCorrections(cw, bounds))) {
                                    if (cw.cc.getHorizontal().getEndGroup() != null) {
                                        endGrpXMap = Grid.addToEndGroup(endGrpXMap, cw.cc.getHorizontal().getEndGroup(), cw.x + cw.w);
                                    }
                                    if (cw.cc.getVertical().getEndGroup() != null) {
                                        endGrpYMap = Grid.addToEndGroup(endGrpYMap, cw.cc.getVertical().getEndGroup(), cw.y + cw.h);
                                    }
                                }
                                if (this.linkTargetIDs != null && (this.linkTargetIDs.containsKey("visual") || this.linkTargetIDs.containsKey("container"))) {
                                    layoutAgain = true;
                                }
                            }
                            if (this.linkTargetIDs != null && j != 1) continue;
                            if (cw.cc.getHorizontal().getEndGroup() != null) {
                                cw.w = (Integer)endGrpXMap.get(cw.cc.getHorizontal().getEndGroup()) - cw.x;
                            }
                            if (cw.cc.getVertical().getEndGroup() != null) {
                                cw.h = (Integer)endGrpYMap.get(cw.cc.getVertical().getEndGroup()) - cw.y;
                            }
                            cw.x += bounds[0];
                            cw.y += bounds[1];
                            layoutAgain |= cw.transferBounds(checkPrefChange && !layoutAgain);
                            if (this.callbackList == null) continue;
                            for (LayoutCallback callback : this.callbackList) {
                                callback.correctBounds(cw.comp);
                            }
                        }
                    }
                    this.clearGroupLinkBounds();
                    if (++count <= (compCount << 3) + 10) continue;
                    System.err.println("Unstable cyclic dependency in absolute linked values!");
                    continue block0;
                } while (doAgain);
            }
        }
        if (debug) {
            for (Cell cell : this.grid.values()) {
                ArrayList<CompWrap> compWraps = cell.compWraps;
                for (CompWrap cw : compWraps) {
                    LinkedDimGroup hGrp = Grid.getGroupContaining(this.colGroupLists, cw);
                    LinkedDimGroup vGrp = Grid.getGroupContaining(this.rowGroupLists, cw);
                    if (hGrp == null || vGrp == null) continue;
                    this.debugRects.add(new int[]{hGrp.lStart + bounds[0] - (hGrp.fromEnd ? hGrp.lSize : 0), vGrp.lStart + bounds[1] - (vGrp.fromEnd ? vGrp.lSize : 0), hGrp.lSize, vGrp.lSize});
                }
            }
        }
        return layoutAgain;
    }

    public void paintDebug() {
        if (this.debugRects != null) {
            this.container.paintDebugOutline();
            ArrayList<int[]> painted = new ArrayList<int[]>();
            for (int[] r : this.debugRects) {
                if (painted.contains(r)) continue;
                this.container.paintDebugCell(r[0], r[1], r[2], r[3]);
                painted.add(r);
            }
            for (Cell cell : this.grid.values()) {
                ArrayList<CompWrap> compWraps = cell.compWraps;
                for (CompWrap compWrap : compWraps) {
                    compWrap.comp.paintDebugOutline();
                }
            }
        }
    }

    public ContainerWrapper getContainer() {
        return this.container;
    }

    public final int[] getWidth() {
        this.checkSizeCalcs();
        return (int[])this.width.clone();
    }

    public final int[] getHeight() {
        this.checkSizeCalcs();
        return (int[])this.height.clone();
    }

    private void checkSizeCalcs() {
        if (this.colFlowSpecs == null) {
            this.colFlowSpecs = this.calcRowsOrColsSizes(true);
            this.rowFlowSpecs = this.calcRowsOrColsSizes(false);
            this.width = this.getMinPrefMaxSumSize(true);
            this.height = this.getMinPrefMaxSumSize(false);
            if (this.linkTargetIDs == null) {
                this.resetLinkValues(false, true);
            } else {
                this.layout(new int[4], null, null, false, false);
                this.resetLinkValues(false, false);
            }
            this.adjustSizeForAbsolute(true);
            this.adjustSizeForAbsolute(false);
        }
    }

    private UnitValue[] getPos(ComponentWrapper cw, CC cc) {
        UnitValue[] cbPos = null;
        if (this.callbackList != null) {
            for (int i2 = 0; i2 < this.callbackList.size() && cbPos == null; ++i2) {
                cbPos = this.callbackList.get(i2).getPosition(cw);
            }
        }
        UnitValue[] ccPos = cc.getPos();
        if (cbPos == null || ccPos == null) {
            return cbPos != null ? cbPos : ccPos;
        }
        for (int i3 = 0; i3 < 4; ++i3) {
            UnitValue cbUv = cbPos[i3];
            if (cbUv == null) continue;
            ccPos[i3] = cbUv;
        }
        return ccPos;
    }

    private BoundSize[] getCallbackSize(ComponentWrapper cw) {
        if (this.callbackList != null) {
            for (LayoutCallback callback : this.callbackList) {
                BoundSize[] bs = callback.getSize(cw);
                if (bs == null) continue;
                return bs;
            }
        }
        return null;
    }

    private boolean setLinkedBounds(ComponentWrapper cw, CC cc, int x, int y, int w, int h, boolean external) {
        String id;
        String string = id = cc.getId() != null ? cc.getId() : cw.getLinkId();
        if (id == null) {
            return false;
        }
        String gid = null;
        int grIx = id.indexOf(46);
        if (grIx != -1) {
            gid = id.substring(0, grIx);
            id = id.substring(grIx + 1);
        }
        Object lay = this.container.getLayout();
        boolean changed = false;
        if (external || this.linkTargetIDs != null && this.linkTargetIDs.containsKey(id)) {
            changed = LinkHandler.setBounds(lay, id, x, y, w, h, !external, false);
        }
        if (gid != null && (external || this.linkTargetIDs != null && this.linkTargetIDs.containsKey(gid))) {
            if (this.linkTargetIDs == null) {
                this.linkTargetIDs = new HashMap(4);
            }
            this.linkTargetIDs.put(gid, Boolean.TRUE);
            changed |= LinkHandler.setBounds(lay, gid, x, y, w, h, !external, true);
        }
        return changed;
    }

    private int increase(int[] p, int cnt) {
        return this.lc.isFlowX() ? p[0] + cnt : p[1] + cnt;
    }

    private void wrap(int[] cellXY, BoundSize gapSize) {
        boolean flowx = this.lc.isFlowX();
        cellXY[0] = flowx ? 0 : cellXY[0] + 1;
        int n = cellXY[1] = flowx ? cellXY[1] + 1 : 0;
        if (gapSize != null) {
            if (this.wrapGapMap == null) {
                this.wrapGapMap = new HashMap(8);
            }
            this.wrapGapMap.put(cellXY[flowx ? 1 : 0], gapSize);
        }
        if (flowx) {
            this.rowIndexes.add(cellXY[1]);
        } else {
            this.colIndexes.add(cellXY[0]);
        }
    }

    private Float[] getDefaultPushWeights(boolean isRows) {
        ArrayList<LinkedDimGroup>[] groupLists = isRows ? this.rowGroupLists : this.colGroupLists;
        Float[] pushWeightArr = GROW_100;
        int i2 = 0;
        int ix = 1;
        while (i2 < groupLists.length) {
            ArrayList<LinkedDimGroup> grps = groupLists[i2];
            Float rowPushWeight = null;
            for (LinkedDimGroup grp : grps) {
                for (int c = 0; c < grp._compWraps.size(); ++c) {
                    Float pushWeight;
                    int hideMode;
                    CompWrap cw = grp._compWraps.get(c);
                    int n = cw.comp.isVisible() ? -1 : (hideMode = cw.cc.getHideMode() != -1 ? cw.cc.getHideMode() : this.lc.getHideMode());
                    Float f = hideMode < 2 ? (isRows ? cw.cc.getPushY() : cw.cc.getPushX()) : (pushWeight = null);
                    if (rowPushWeight != null && (pushWeight == null || !(pushWeight.floatValue() > rowPushWeight.floatValue()))) continue;
                    rowPushWeight = pushWeight;
                }
            }
            if (rowPushWeight != null) {
                if (pushWeightArr == GROW_100) {
                    pushWeightArr = new Float[(groupLists.length << 1) + 1];
                }
                pushWeightArr[ix] = rowPushWeight;
            }
            ++i2;
            ix += 2;
        }
        return pushWeightArr;
    }

    private void clearGroupLinkBounds() {
        if (this.linkTargetIDs == null) {
            return;
        }
        for (Map.Entry<String, Boolean> o : this.linkTargetIDs.entrySet()) {
            if (o.getValue() != Boolean.TRUE) continue;
            LinkHandler.clearBounds(this.container.getLayout(), o.getKey());
        }
    }

    private void resetLinkValues(boolean parentSize, boolean compLinks) {
        Object lay = this.container.getLayout();
        if (compLinks) {
            LinkHandler.clearTemporaryBounds(lay);
        }
        boolean defIns = !this.hasDocks();
        int parW = parentSize ? this.lc.getWidth().constrain(this.container.getWidth(), Grid.getParentSize(this.container, true), this.container) : 0;
        int parH = parentSize ? this.lc.getHeight().constrain(this.container.getHeight(), Grid.getParentSize(this.container, false), this.container) : 0;
        int insX = LayoutUtil.getInsets(this.lc, 0, defIns).getPixels(0.0f, this.container, null);
        int insY = LayoutUtil.getInsets(this.lc, 1, defIns).getPixels(0.0f, this.container, null);
        int visW = parW - insX - LayoutUtil.getInsets(this.lc, 2, defIns).getPixels(0.0f, this.container, null);
        int visH = parH - insY - LayoutUtil.getInsets(this.lc, 3, defIns).getPixels(0.0f, this.container, null);
        LinkHandler.setBounds(lay, "visual", insX, insY, visW, visH, true, false);
        LinkHandler.setBounds(lay, "container", 0, 0, parW, parH, true, false);
    }

    private boolean doAbsoluteCorrections(CompWrap cw, int[] bounds) {
        boolean changed = false;
        int[] stSz = this.getAbsoluteDimBounds(cw, bounds[2], true);
        if (stSz != null) {
            cw.setDimBounds(stSz[0], stSz[1], true);
        }
        if ((stSz = this.getAbsoluteDimBounds(cw, bounds[3], false)) != null) {
            cw.setDimBounds(stSz[0], stSz[1], false);
        }
        if (this.linkTargetIDs != null) {
            changed = this.setLinkedBounds(cw.comp, cw.cc, cw.x, cw.y, cw.w, cw.h, false);
        }
        return changed;
    }

    private void adjustSizeForAbsolute(boolean isHor) {
        int[] curSizes = isHor ? this.width : this.height;
        Cell absCell = this.grid.get(null);
        if (absCell == null || absCell.compWraps.size() == 0) {
            return;
        }
        ArrayList<CompWrap> cws = absCell.compWraps;
        int maxEnd = 0;
        int cwSz = absCell.compWraps.size();
        for (int j = 0; j < cwSz + 3; ++j) {
            boolean doAgain = false;
            for (int i2 = 0; i2 < cwSz; ++i2) {
                CompWrap cw = cws.get(i2);
                int[] stSz = this.getAbsoluteDimBounds(cw, 0, isHor);
                int end = stSz[0] + stSz[1];
                if (maxEnd < end) {
                    maxEnd = end;
                }
                if (this.linkTargetIDs == null) continue;
                doAgain |= this.setLinkedBounds(cw.comp, cw.cc, stSz[0], stSz[0], stSz[1], stSz[1], false);
            }
            if (!doAgain) break;
            maxEnd = 0;
            this.clearGroupLinkBounds();
        }
        if (curSizes[0] < (maxEnd += LayoutUtil.getInsets(this.lc, isHor ? 3 : 2, !this.hasDocks()).getPixels(0.0f, this.container, null))) {
            curSizes[0] = maxEnd;
        }
        if (curSizes[1] < maxEnd) {
            curSizes[1] = maxEnd;
        }
    }

    private int[] getAbsoluteDimBounds(CompWrap cw, int refSize, boolean isHor) {
        int sz;
        if (cw.cc.isExternal()) {
            if (isHor) {
                return new int[]{cw.comp.getX(), cw.comp.getWidth()};
            }
            return new int[]{cw.comp.getY(), cw.comp.getHeight()};
        }
        int[] plafPad = this.lc.isVisualPadding() ? cw.comp.getVisualPadding() : null;
        UnitValue[] pad = cw.cc.getPadding();
        if (cw.pos == null && plafPad == null && pad == null) {
            return null;
        }
        int st = isHor ? cw.x : cw.y;
        int n = sz = isHor ? cw.w : cw.h;
        if (cw.pos != null) {
            UnitValue stUV = cw.pos[isHor ? 0 : 1];
            UnitValue endUV = cw.pos[isHor ? 2 : 3];
            int minSz = cw.getSize(0, isHor);
            int maxSz = cw.getSize(2, isHor);
            sz = Math.min(Math.max(cw.getSize(1, isHor), minSz), maxSz);
            if (stUV != null) {
                st = stUV.getPixels(stUV.getUnit() == 12 ? (float)sz : (float)refSize, this.container, cw.comp);
                if (endUV != null) {
                    sz = Math.min(Math.max((isHor ? cw.x + cw.w : cw.y + cw.h) - st, minSz), maxSz);
                }
            }
            if (endUV != null) {
                if (stUV != null) {
                    sz = Math.min(Math.max(endUV.getPixels(refSize, this.container, cw.comp) - st, minSz), maxSz);
                } else {
                    st = endUV.getPixels(refSize, this.container, cw.comp) - sz;
                }
            }
        }
        if (pad != null) {
            UnitValue uv = pad[isHor ? 1 : 0];
            int p = uv != null ? uv.getPixels(refSize, this.container, cw.comp) : 0;
            st += p;
            uv = pad[isHor ? 3 : 2];
            sz += -p + (uv != null ? uv.getPixels(refSize, this.container, cw.comp) : 0);
        }
        if (plafPad != null) {
            int p = plafPad[isHor ? 1 : 0];
            st += p;
            sz += -p + plafPad[isHor ? 3 : 2];
        }
        return new int[]{st, sz};
    }

    private void layoutInOneDim(int refSize, UnitValue align, boolean isRows, Float[] defaultPushWeights) {
        int curPos;
        boolean fromEnd = !(!isRows ? LayoutUtil.isLeftToRight(this.lc, this.container) : this.lc.isTopToBottom());
        DimConstraint[] primDCs = (isRows ? this.rowConstr : this.colConstr).getConstaints();
        FlowSizeSpec fss = isRows ? this.rowFlowSpecs : this.colFlowSpecs;
        ArrayList<LinkedDimGroup>[] rowCols = isRows ? this.rowGroupLists : this.colGroupLists;
        int[] rowColSizes = LayoutUtil.calculateSerial(fss.sizes, fss.resConstsInclGaps, defaultPushWeights, 1, refSize);
        if (LayoutUtil.isDesignTime(this.container)) {
            TreeSet<Integer> indexes = isRows ? this.rowIndexes : this.colIndexes;
            int[] ixArr = new int[indexes.size()];
            int ix = 0;
            for (Integer i2 : indexes) {
                ixArr[ix++] = i2;
            }
            Grid.putSizesAndIndexes(this.container.getComponent(), rowColSizes, ixArr, isRows);
        }
        int n = curPos = align != null ? align.getPixels(refSize - LayoutUtil.sum(rowColSizes), this.container, null) : 0;
        if (fromEnd) {
            curPos = refSize - curPos;
        }
        for (int i3 = 0; i3 < rowCols.length; ++i3) {
            ArrayList<LinkedDimGroup> linkedGroups = rowCols[i3];
            int scIx = i3 - (isRows ? this.dockOffY : this.dockOffX);
            int bIx = i3 << 1;
            int bIx2 = bIx + 1;
            curPos += fromEnd ? -rowColSizes[bIx] : rowColSizes[bIx];
            DimConstraint primDC = scIx >= 0 ? primDCs[scIx >= primDCs.length ? primDCs.length - 1 : scIx] : DOCK_DIM_CONSTRAINT;
            int rowSize = rowColSizes[bIx2];
            for (LinkedDimGroup group : linkedGroups) {
                int groupSize = rowSize;
                if (group.span > 1) {
                    groupSize = LayoutUtil.sum(rowColSizes, bIx2, Math.min((group.span << 1) - 1, rowColSizes.length - bIx2 - 1));
                }
                group.layout(primDC, curPos, groupSize, group.span);
            }
            curPos += fromEnd ? -rowSize : rowSize;
        }
    }

    private FlowSizeSpec calcRowsOrColsSizes(boolean isHor) {
        int r;
        BoundSize cSz;
        ArrayList<LinkedDimGroup>[] groupsLists = isHor ? this.colGroupLists : this.rowGroupLists;
        Float[] defPush = isHor ? this.pushXs : this.pushYs;
        int refSize = isHor ? this.container.getWidth() : this.container.getHeight();
        BoundSize boundSize = cSz = isHor ? this.lc.getWidth() : this.lc.getHeight();
        if (!cSz.isUnset()) {
            refSize = cSz.constrain(refSize, Grid.getParentSize(this.container, isHor), this.container);
        }
        DimConstraint[] primDCs = (isHor ? this.colConstr : this.rowConstr).getConstaints();
        TreeSet<Integer> primIndexes = isHor ? this.colIndexes : this.rowIndexes;
        int[][] rowColBoundSizes = new int[primIndexes.size()][];
        HashMap<String, int[]> sizeGroupMap = new HashMap<String, int[]>(2);
        DimConstraint[] allDCs = new DimConstraint[primIndexes.size()];
        Iterator<Integer> primIt = primIndexes.iterator();
        for (r = 0; r < rowColBoundSizes.length; ++r) {
            int cellIx = primIt.next();
            int[] rowColSizes = new int[3];
            allDCs[r] = cellIx >= -30000 && cellIx <= 30000 ? primDCs[cellIx >= primDCs.length ? primDCs.length - 1 : cellIx] : DOCK_DIM_CONSTRAINT;
            ArrayList<LinkedDimGroup> groups2 = groupsLists[r];
            int[] groupSizes = new int[]{Grid.getTotalGroupsSizeParallel(groups2, 0), Grid.getTotalGroupsSizeParallel(groups2, 1), 2097051};
            Grid.correctMinMax(groupSizes);
            BoundSize dimSize = allDCs[r].getSize();
            for (int sType = 0; sType <= 2; ++sType) {
                int rowColSize = groupSizes[sType];
                UnitValue uv = dimSize.getSize(sType);
                if (uv != null) {
                    int unit = uv.getUnit();
                    rowColSize = unit == 14 ? groupSizes[1] : (unit == 13 ? groupSizes[0] : (unit == 15 ? groupSizes[2] : uv.getPixels(refSize, this.container, null)));
                } else if (cellIx >= -30000 && cellIx <= 30000 && rowColSize == 0) {
                    rowColSize = LayoutUtil.isDesignTime(this.container) ? LayoutUtil.getDesignTimeEmptySize() : 0;
                }
                rowColSizes[sType] = rowColSize;
            }
            Grid.correctMinMax(rowColSizes);
            Grid.addToSizeGroup(sizeGroupMap, allDCs[r].getSizeGroup(), rowColSizes);
            rowColBoundSizes[r] = rowColSizes;
        }
        if (sizeGroupMap.size() > 0) {
            for (r = 0; r < rowColBoundSizes.length; ++r) {
                if (allDCs[r].getSizeGroup() == null) continue;
                rowColBoundSizes[r] = (int[])sizeGroupMap.get(allDCs[r].getSizeGroup());
            }
        }
        ResizeConstraint[] resConstrs = Grid.getRowResizeConstraints(allDCs);
        boolean[] fillInPushGaps = new boolean[allDCs.length + 1];
        int[][] gapSizes = this.getRowGaps(allDCs, refSize, isHor, fillInPushGaps);
        FlowSizeSpec fss = Grid.mergeSizesGapsAndResConstrs(resConstrs, fillInPushGaps, rowColBoundSizes, gapSizes);
        this.adjustMinPrefForSpanningComps(allDCs, defPush, fss, groupsLists);
        return fss;
    }

    private int[] getMinPrefMaxSumSize(boolean isHor) {
        int[][] sizes = isHor ? this.colFlowSpecs.sizes : this.rowFlowSpecs.sizes;
        int[] retSizes = new int[3];
        BoundSize sz = isHor ? this.lc.getWidth() : this.lc.getHeight();
        for (int i2 = 0; i2 < sizes.length; ++i2) {
            if (sizes[i2] == null) continue;
            int[] size = sizes[i2];
            for (int sType = 0; sType <= 2; ++sType) {
                if (sz.getSize(sType) != null) {
                    if (i2 != 0) continue;
                    retSizes[sType] = sz.getSize(sType).getPixels(Grid.getParentSize(this.container, isHor), this.container, null);
                    continue;
                }
                int s = size[sType];
                if (s != -2147471302) {
                    if (sType == 1) {
                        int bnd = size[2];
                        if (bnd != -2147471302 && bnd < s) {
                            s = bnd;
                        }
                        if ((bnd = size[0]) > s) {
                            s = bnd;
                        }
                    }
                    int n = sType;
                    retSizes[n] = retSizes[n] + s;
                }
                if (size[2] != -2147471302 && retSizes[2] <= 2097051) continue;
                retSizes[2] = 2097051;
            }
        }
        Grid.correctMinMax(retSizes);
        return retSizes;
    }

    private int[][] getRowGaps(DimConstraint[] specs, int refSize, boolean isHor, boolean[] fillInPushGaps) {
        BoundSize defGap;
        BoundSize boundSize = defGap = isHor ? this.lc.getGridGapX() : this.lc.getGridGapY();
        if (defGap == null) {
            defGap = isHor ? PlatformDefaults.getGridGapX() : PlatformDefaults.getGridGapY();
        }
        int[] defGapArr = defGap.getPixelSizes(refSize, this.container, null);
        boolean defIns = !this.hasDocks();
        UnitValue firstGap = LayoutUtil.getInsets(this.lc, isHor ? 1 : 0, defIns);
        UnitValue lastGap = LayoutUtil.getInsets(this.lc, isHor ? 3 : 2, defIns);
        int[][] retValues = new int[specs.length + 1][];
        int wgIx = 0;
        for (int i2 = 0; i2 < retValues.length; ++i2) {
            BoundSize wrapGapSize;
            boolean edgeAfter;
            DimConstraint specBefore = i2 > 0 ? specs[i2 - 1] : null;
            DimConstraint specAfter = i2 < specs.length ? specs[i2] : null;
            boolean edgeBefore = specBefore == DOCK_DIM_CONSTRAINT || specBefore == null;
            boolean bl = edgeAfter = specAfter == DOCK_DIM_CONSTRAINT || specAfter == null;
            if (edgeBefore && edgeAfter) continue;
            BoundSize boundSize2 = wrapGapSize = this.wrapGapMap == null || isHor == this.lc.isFlowX() ? null : this.wrapGapMap.get(wgIx++);
            if (wrapGapSize == null) {
                int[] gapAfter;
                int[] gapBefore = specBefore != null ? specBefore.getRowGaps(this.container, null, refSize, false) : null;
                int[] nArray = gapAfter = specAfter != null ? specAfter.getRowGaps(this.container, null, refSize, true) : null;
                if (edgeBefore && gapAfter == null && firstGap != null) {
                    int bef = firstGap.getPixels(refSize, this.container, null);
                    retValues[i2] = new int[]{bef, bef, bef};
                } else if (edgeAfter && gapBefore == null && firstGap != null) {
                    int aft = lastGap.getPixels(refSize, this.container, null);
                    retValues[i2] = new int[]{aft, aft, aft};
                } else {
                    int[] nArray2;
                    if (gapAfter != gapBefore) {
                        nArray2 = Grid.mergeSizes(gapAfter, gapBefore);
                    } else {
                        int[] nArray3 = new int[3];
                        nArray3[0] = defGapArr[0];
                        nArray3[1] = defGapArr[1];
                        nArray2 = nArray3;
                        nArray3[2] = defGapArr[2];
                    }
                    retValues[i2] = nArray2;
                }
                if ((specBefore == null || !specBefore.isGapAfterPush()) && (specAfter == null || !specAfter.isGapBeforePush())) continue;
                fillInPushGaps[i2] = true;
                continue;
            }
            retValues[i2] = wrapGapSize.isUnset() ? new int[]{defGapArr[0], defGapArr[1], defGapArr[2]} : wrapGapSize.getPixelSizes(refSize, this.container, null);
            fillInPushGaps[i2] = wrapGapSize.getGapPush();
        }
        return retValues;
    }

    private boolean hasDocks() {
        return this.dockOffX > 0 || this.dockOffY > 0 || this.rowIndexes.last() > 30000 || this.colIndexes.last() > 30000;
    }

    private void adjustMinPrefForSpanningComps(DimConstraint[] specs, Float[] defPush, FlowSizeSpec fss, ArrayList<LinkedDimGroup>[] groupsLists) {
        for (int r = groupsLists.length - 1; r >= 0; --r) {
            ArrayList<LinkedDimGroup> groups2 = groupsLists[r];
            for (LinkedDimGroup group : groups2) {
                if (group.span == 1) continue;
                int[] sizes = group.getMinPrefMax();
                for (int s = 0; s <= 1; ++s) {
                    int cSize = sizes[s];
                    if (cSize == -2147471302) continue;
                    int rowSize = 0;
                    int sIx = (r << 1) + 1;
                    int len = Math.min(group.span << 1, fss.sizes.length - sIx) - 1;
                    for (int j = sIx; j < sIx + len; ++j) {
                        int sz = fss.sizes[j][s];
                        if (sz == -2147471302) continue;
                        rowSize += sz;
                    }
                    if (rowSize >= cSize || len <= 0) continue;
                    int newRowSize = 0;
                    for (int eagerness = 0; eagerness < 4 && newRowSize < cSize; ++eagerness) {
                        newRowSize = fss.expandSizes(specs, defPush, cSize, sIx, len, s, eagerness);
                    }
                }
            }
        }
    }

    private ArrayList<LinkedDimGroup>[] divideIntoLinkedGroups(boolean isRows) {
        boolean fromEnd = !(!isRows ? LayoutUtil.isLeftToRight(this.lc, this.container) : this.lc.isTopToBottom());
        TreeSet<Integer> primIndexes = isRows ? this.rowIndexes : this.colIndexes;
        TreeSet<Integer> secIndexes = isRows ? this.colIndexes : this.rowIndexes;
        DimConstraint[] primDCs = (isRows ? this.rowConstr : this.colConstr).getConstaints();
        ArrayList[] groupLists = new ArrayList[primIndexes.size()];
        int gIx = 0;
        for (int i2 : primIndexes) {
            DimConstraint dc = i2 >= -30000 && i2 <= 30000 ? primDCs[i2 >= primDCs.length ? primDCs.length - 1 : i2] : DOCK_DIM_CONSTRAINT;
            ArrayList<LinkedDimGroup> groupList = new ArrayList<LinkedDimGroup>(2);
            groupLists[gIx++] = groupList;
            for (Integer ix : secIndexes) {
                boolean isPar;
                int span;
                Cell cell = isRows ? this.getCell(i2, ix) : this.getCell(ix, i2);
                if (cell == null || cell.compWraps.size() == 0) continue;
                int n = span = isRows ? cell.spany : cell.spanx;
                if (span > 1) {
                    span = Grid.convertSpanToSparseGrid(i2, span, primIndexes);
                }
                boolean bl = isPar = cell.flowx == isRows;
                if (!isPar && cell.compWraps.size() > 1 || span > 1) {
                    int linkType = isPar ? 1 : 0;
                    LinkedDimGroup lg = new LinkedDimGroup("p," + ix, span, linkType, !isRows, fromEnd);
                    lg.setCompWraps(cell.compWraps);
                    groupList.add(lg);
                    continue;
                }
                for (int cwIx = 0; cwIx < cell.compWraps.size(); ++cwIx) {
                    CompWrap cw = cell.compWraps.get(cwIx);
                    boolean rowBaselineAlign = isRows && this.lc.isTopToBottom() && dc.getAlignOrDefault(!isRows) == UnitValue.BASELINE_IDENTITY;
                    boolean isBaseline = isRows && cw.isBaselineAlign(rowBaselineAlign);
                    String linkCtx = isBaseline ? "baseline" : null;
                    boolean foundList = false;
                    int lastGl = groupList.size() - 1;
                    for (int glIx = 0; glIx <= lastGl; ++glIx) {
                        LinkedDimGroup group = (LinkedDimGroup)groupList.get(glIx);
                        if (!Objects.equals(linkCtx, group.linkCtx)) continue;
                        group.addCompWrap(cw);
                        foundList = true;
                        break;
                    }
                    if (foundList) continue;
                    int linkType = isBaseline ? 2 : 1;
                    LinkedDimGroup lg = new LinkedDimGroup(linkCtx, 1, linkType, !isRows, fromEnd);
                    lg.addCompWrap(cw);
                    groupList.add(lg);
                }
            }
        }
        return groupLists;
    }

    private boolean isCellFree(int r, int c, ArrayList<int[]> occupiedRects) {
        if (this.getCell(r, c) != null) {
            return false;
        }
        for (int[] rect : occupiedRects) {
            if (rect[0] > c || rect[1] > r || rect[0] + rect[2] <= c || rect[1] + rect[3] <= r) continue;
            return false;
        }
        return true;
    }

    private Cell getCell(int r, int c) {
        return this.grid.get((r << 16) + c);
    }

    private void setCell(int r, int c, Cell cell) {
        if (c < 0 || r < 0) {
            throw new IllegalArgumentException("Cell position cannot be negative. row: " + r + ", col: " + c);
        }
        if (c > 30000 || r > 30000) {
            throw new IllegalArgumentException("Cell position out of bounds. Out of cells. row: " + r + ", col: " + c);
        }
        this.rowIndexes.add(r);
        this.colIndexes.add(c);
        this.grid.put((r << 16) + c, cell);
    }

    private void addDockingCell(int[] dockInsets, int side, CompWrap cw) {
        int c;
        int r;
        int spanx = 1;
        int spany = 1;
        switch (side) {
            case 0: 
            case 2: {
                int n;
                if (side == 0) {
                    int n2 = dockInsets[0];
                    n = n2;
                    dockInsets[0] = n2 + 1;
                } else {
                    int n3 = dockInsets[2];
                    n = n3;
                    dockInsets[2] = n3 - 1;
                }
                r = n;
                c = dockInsets[1];
                spanx = dockInsets[3] - dockInsets[1] + 1;
                this.colIndexes.add(dockInsets[3]);
                break;
            }
            case 1: 
            case 3: {
                int n;
                if (side == 1) {
                    int n4 = dockInsets[1];
                    n = n4;
                    dockInsets[1] = n4 + 1;
                } else {
                    int n5 = dockInsets[3];
                    n = n5;
                    dockInsets[3] = n5 - 1;
                }
                c = n;
                r = dockInsets[0];
                spany = dockInsets[2] - dockInsets[0] + 1;
                this.rowIndexes.add(dockInsets[2]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Internal error 123.");
            }
        }
        this.rowIndexes.add(r);
        this.colIndexes.add(c);
        this.grid.put((r << 16) + c, new Cell(cw, spanx, spany, spanx > 1));
    }

    static {
        DOCK_DIM_CONSTRAINT.setGrowPriority(0);
    }

    private static final class FlowSizeSpec {
        private final int[][] sizes;
        private final ResizeConstraint[] resConstsInclGaps;

        private FlowSizeSpec(int[][] sizes, ResizeConstraint[] resConstsInclGaps) {
            this.sizes = sizes;
            this.resConstsInclGaps = resConstsInclGaps;
        }

        private int expandSizes(DimConstraint[] specs, Float[] defGrow, int targetSize, int fromIx, int len, int sizeType, int eagerness) {
            ResizeConstraint[] resConstr = new ResizeConstraint[len];
            int[][] sizesToExpand = new int[len][];
            for (int i2 = 0; i2 < len; ++i2) {
                int[] minPrefMax = this.sizes[i2 + fromIx];
                sizesToExpand[i2] = new int[]{minPrefMax[sizeType], minPrefMax[1], minPrefMax[2]};
                if (eagerness <= 1 && i2 % 2 == 0) {
                    int cIx = i2 + fromIx - 1 >> 1;
                    DimConstraint spec = (DimConstraint)LayoutUtil.getIndexSafe(specs, cIx);
                    BoundSize sz = spec.getSize();
                    if (sizeType == 0 && sz.getMin() != null && sz.getMin().getUnit() != 13 || sizeType == 1 && sz.getPreferred() != null && sz.getPreferred().getUnit() != 14) continue;
                }
                resConstr[i2] = (ResizeConstraint)LayoutUtil.getIndexSafe(this.resConstsInclGaps, i2 + fromIx);
            }
            Float[] growW = eagerness == 1 || eagerness == 3 ? Grid.extractSubArray(specs, defGrow, fromIx, len) : null;
            int[] newSizes = LayoutUtil.calculateSerial(sizesToExpand, resConstr, growW, 1, targetSize);
            int newSize = 0;
            for (int i3 = 0; i3 < len; ++i3) {
                int s;
                this.sizes[i3 + fromIx][sizeType] = s = newSizes[i3];
                newSize += s;
            }
            return newSize;
        }
    }

    private static final class CompWrap {
        private final ComponentWrapper comp;
        private final CC cc;
        private final UnitValue[] pos;
        private final int[] horSizes = new int[3];
        private final int[] verSizes = new int[3];
        private int[][] gaps;
        private int x = -2147471302;
        private int y = -2147471302;
        private int w = -2147471302;
        private int h = -2147471302;
        private int forcedPushGaps = 0;

        private CompWrap(ComponentWrapper c, CC cc, int eHideMode, UnitValue[] pos, BoundSize[] callbackSz) {
            this.comp = c;
            this.cc = cc;
            this.pos = pos;
            if (eHideMode <= 0) {
                BoundSize hBS = callbackSz != null && callbackSz[0] != null ? callbackSz[0] : cc.getHorizontal().getSize();
                BoundSize vBS = callbackSz != null && callbackSz[1] != null ? callbackSz[1] : cc.getVertical().getSize();
                int wHint = -1;
                int hHint = -1;
                if (this.comp.getWidth() > 0 && this.comp.getHeight() > 0) {
                    hHint = this.comp.getHeight();
                    wHint = this.comp.getWidth();
                }
                for (int i2 = 0; i2 <= 2; ++i2) {
                    this.horSizes[i2] = this.getSize(hBS, i2, true, hHint);
                    this.verSizes[i2] = this.getSize(vBS, i2, false, wHint > 0 ? wHint : this.horSizes[i2]);
                }
                Grid.correctMinMax(this.horSizes);
                Grid.correctMinMax(this.verSizes);
            }
            if (eHideMode > 1) {
                this.gaps = new int[4][];
                Arrays.fill((Object[])this.gaps, new int[3]);
            }
        }

        private int getSize(BoundSize uvs, int sizeType, boolean isHor, int sizeHint) {
            if (uvs == null || uvs.getSize(sizeType) == null) {
                switch (sizeType) {
                    case 0: {
                        return isHor ? this.comp.getMinimumWidth(sizeHint) : this.comp.getMinimumHeight(sizeHint);
                    }
                    case 1: {
                        return isHor ? this.comp.getPreferredWidth(sizeHint) : this.comp.getPreferredHeight(sizeHint);
                    }
                }
                return isHor ? this.comp.getMaximumWidth(sizeHint) : this.comp.getMaximumHeight(sizeHint);
            }
            ContainerWrapper par = this.comp.getParent();
            return uvs.getSize(sizeType).getPixels(isHor ? (float)par.getWidth() : (float)par.getHeight(), par, this.comp);
        }

        private void calcGaps(ComponentWrapper before, CC befCC, ComponentWrapper after, CC aftCC, String tag, boolean flowX, boolean isLTR) {
            BoundSize befGap;
            ContainerWrapper par = this.comp.getParent();
            int parW = par.getWidth();
            int parH = par.getHeight();
            BoundSize boundSize = before != null ? (flowX ? befCC.getHorizontal() : befCC.getVertical()).getGapAfter() : (befGap = null);
            BoundSize aftGap = after != null ? (flowX ? aftCC.getHorizontal() : aftCC.getVertical()).getGapBefore() : null;
            this.mergeGapSizes(this.cc.getVertical().getComponentGaps(par, this.comp, befGap, flowX ? null : before, tag, parH, 0, isLTR), false, true);
            this.mergeGapSizes(this.cc.getHorizontal().getComponentGaps(par, this.comp, befGap, flowX ? before : null, tag, parW, 1, isLTR), true, true);
            this.mergeGapSizes(this.cc.getVertical().getComponentGaps(par, this.comp, aftGap, flowX ? null : after, tag, parH, 2, isLTR), false, false);
            this.mergeGapSizes(this.cc.getHorizontal().getComponentGaps(par, this.comp, aftGap, flowX ? after : null, tag, parW, 3, isLTR), true, false);
        }

        private void setDimBounds(int start, int size, boolean isHor) {
            if (isHor) {
                this.x = start;
                this.w = size;
            } else {
                this.y = start;
                this.h = size;
            }
        }

        private boolean isPushGap(boolean isHor, boolean isBefore) {
            if (isHor && ((isBefore ? 1 : 2) & this.forcedPushGaps) != 0) {
                return true;
            }
            DimConstraint dc = this.cc.getDimConstraint(isHor);
            BoundSize s = isBefore ? dc.getGapBefore() : dc.getGapAfter();
            return s != null && s.getGapPush();
        }

        private boolean transferBounds(boolean checkPrefChange) {
            BoundSize vSz;
            this.comp.setBounds(this.x, this.y, this.w, this.h);
            if (checkPrefChange && this.w != this.horSizes[1] && (vSz = this.cc.getVertical().getSize()).getPreferred() == null) {
                return this.comp.getPreferredHeight(-1) != this.verSizes[1];
            }
            return false;
        }

        private void setSizes(int[] sizes, boolean isHor) {
            if (sizes == null) {
                return;
            }
            int[] s = isHor ? this.horSizes : this.verSizes;
            s[0] = sizes[0];
            s[1] = sizes[1];
            s[2] = sizes[2];
        }

        private void setGaps(int[] minPrefMax, int ix) {
            if (this.gaps == null) {
                this.gaps = new int[][]{null, null, null, null};
            }
            this.gaps[ix] = minPrefMax;
        }

        private void mergeGapSizes(int[] sizes, boolean isHor, boolean isTL) {
            if (this.gaps == null) {
                this.gaps = new int[][]{null, null, null, null};
            }
            if (sizes == null) {
                return;
            }
            int gapIX = this.getGapIx(isHor, isTL);
            int[] oldGaps = this.gaps[gapIX];
            if (oldGaps == null) {
                oldGaps = new int[]{0, 0, 2097051};
                this.gaps[gapIX] = oldGaps;
            }
            oldGaps[0] = Math.max(sizes[0], oldGaps[0]);
            oldGaps[1] = Math.max(sizes[1], oldGaps[1]);
            oldGaps[2] = Math.min(sizes[2], oldGaps[2]);
        }

        private int getGapIx(boolean isHor, boolean isTL) {
            return isHor ? (isTL ? 1 : 3) : (isTL ? 0 : 2);
        }

        private int getSizeInclGaps(int sizeType, boolean isHor) {
            return this.filter(sizeType, this.getGapBefore(sizeType, isHor) + this.getSize(sizeType, isHor) + this.getGapAfter(sizeType, isHor));
        }

        private int getSize(int sizeType, boolean isHor) {
            return this.filter(sizeType, isHor ? this.horSizes[sizeType] : this.verSizes[sizeType]);
        }

        private int getGapBefore(int sizeType, boolean isHor) {
            int[] gaps = this.getGaps(isHor, true);
            return gaps != null ? this.filter(sizeType, gaps[sizeType]) : 0;
        }

        private int getGapAfter(int sizeType, boolean isHor) {
            int[] gaps = this.getGaps(isHor, false);
            return gaps != null ? this.filter(sizeType, gaps[sizeType]) : 0;
        }

        private int[] getGaps(boolean isHor, boolean isTL) {
            return this.gaps[this.getGapIx(isHor, isTL)];
        }

        private int filter(int sizeType, int size) {
            if (size == -2147471302) {
                return sizeType != 2 ? 0 : 2097051;
            }
            return Grid.constrainSize(size);
        }

        private boolean isBaselineAlign(boolean defValue) {
            Float g = this.cc.getVertical().getGrow();
            if (g != null && g.intValue() != 0) {
                return false;
            }
            UnitValue al = this.cc.getVertical().getAlign();
            return (al != null ? al == UnitValue.BASELINE_IDENTITY : defValue) && this.comp.hasBaseline();
        }

        private int getBaseline(int sizeType) {
            return this.comp.getBaseline(this.getSize(sizeType, true), this.getSize(sizeType, false));
        }
    }

    private static class Cell {
        private final int spanx;
        private final int spany;
        private final boolean flowx;
        private final ArrayList<CompWrap> compWraps = new ArrayList(1);
        private boolean hasTagged = false;

        private Cell(CompWrap cw) {
            this(cw, 1, 1, true);
        }

        private Cell(int spanx, int spany, boolean flowx) {
            this(null, spanx, spany, flowx);
        }

        private Cell(CompWrap cw, int spanx, int spany, boolean flowx) {
            if (cw != null) {
                this.compWraps.add(cw);
            }
            this.spanx = spanx;
            this.spany = spany;
            this.flowx = flowx;
        }
    }

    private static class LinkedDimGroup {
        private static final int TYPE_SERIAL = 0;
        private static final int TYPE_PARALLEL = 1;
        private static final int TYPE_BASELINE = 2;
        private final String linkCtx;
        private final int span;
        private final int linkType;
        private final boolean isHor;
        private final boolean fromEnd;
        private ArrayList<CompWrap> _compWraps = new ArrayList(4);
        private int[] sizes = null;
        private int lStart = 0;
        private int lSize = 0;

        private LinkedDimGroup(String linkCtx, int span, int linkType, boolean isHor, boolean fromEnd) {
            this.linkCtx = linkCtx;
            this.span = span;
            this.linkType = linkType;
            this.isHor = isHor;
            this.fromEnd = fromEnd;
        }

        private void addCompWrap(CompWrap cw) {
            this._compWraps.add(cw);
            this.sizes = null;
        }

        private void setCompWraps(ArrayList<CompWrap> cws) {
            if (this._compWraps != cws) {
                this._compWraps = cws;
                this.sizes = null;
            }
        }

        private void layout(DimConstraint dc, int start, int size, int spanCount) {
            this.lStart = start;
            this.lSize = size;
            if (this._compWraps.size() == 0) {
                return;
            }
            ContainerWrapper parent = this._compWraps.get((int)0).comp.getParent();
            if (this.linkType == 1) {
                Grid.layoutParallel(parent, this._compWraps, dc, start, size, this.isHor, this.fromEnd);
            } else if (this.linkType == 2) {
                Grid.layoutBaseline(parent, this._compWraps, dc, start, size, spanCount);
            } else {
                Grid.layoutSerial(parent, this._compWraps, dc, start, size, this.isHor, this.fromEnd);
            }
        }

        private int[] getMinPrefMax() {
            if (this.sizes == null && this._compWraps.size() > 0) {
                this.sizes = new int[3];
                for (int sType = 0; sType <= 1; ++sType) {
                    if (this.linkType == 1) {
                        this.sizes[sType] = Grid.getTotalSizeParallel(this._compWraps, sType, this.isHor);
                        continue;
                    }
                    if (this.linkType == 2) {
                        int[] aboveBelow = Grid.getBaselineAboveBelow(this._compWraps, sType, false);
                        this.sizes[sType] = aboveBelow[0] + aboveBelow[1];
                        continue;
                    }
                    this.sizes[sType] = Grid.getTotalSizeSerial(this._compWraps, sType, this.isHor);
                }
                this.sizes[2] = 2097051;
            }
            return this.sizes;
        }
    }
}

