/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.frostwire.service.ErrorService;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public class URIUtils {
    private static final String RESERVED = ";/?:@&=+$,";

    public static URI toURI(String uriString) throws URISyntaxException {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            String encodedURIString = URIUtils.encodeURI(uriString);
            try {
                uri = new URI(encodedURIString);
            }
            catch (URISyntaxException e1) {
                if (e.getCause() == null) {
                    e.initCause(e1);
                }
                throw e;
            }
        }
        return uri;
    }

    private static String encodeURI(String url) {
        StringBuilder encodedURL = new StringBuilder();
        StringTokenizer st = new StringTokenizer(url, RESERVED, true);
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if (URIUtils.isDelimiter(s)) {
                encodedURL.append(s);
                continue;
            }
            try {
                String ASCII_ENCODING = "ISO-8859-1";
                encodedURL.append(URLEncoder.encode(s, ASCII_ENCODING));
            }
            catch (UnsupportedEncodingException e1) {
                ErrorService.error(e1);
            }
        }
        return encodedURL.toString();
    }

    private static boolean isDelimiter(String s) {
        return RESERVED.contains(s);
    }
}

