/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.util.NoSuchElementException;

public class QuotedStringTokenizer {
    private static final char QUOTE_CHAR = '\"';
    private final boolean returnSeparators;
    private final String text;
    private final int maxIndex;
    private String separators;
    private int index;

    private QuotedStringTokenizer(String text, String separators, boolean returnSeparators) {
        this.text = text;
        this.maxIndex = text.length() - 1;
        this.separators = separators;
        this.returnSeparators = returnSeparators;
    }

    QuotedStringTokenizer(String text) {
        this(text, " ", false);
    }

    int countTokens() {
        Token token;
        int count = 0;
        int i2 = this.index;
        while ((token = this.nextToken(i2)) != null) {
            ++count;
            i2 = token.nextIndex;
        }
        return count;
    }

    public String nextToken(String separators) {
        this.separators = separators;
        return this.nextToken();
    }

    public String nextToken() {
        Token token = this.nextToken(this.index);
        if (token != null) {
            this.index = token.nextIndex;
            return token.text;
        }
        throw new NoSuchElementException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Token nextToken(int index) {
        int i2;
        if (index > this.maxIndex) {
            return null;
        }
        if (this.returnSeparators && this.separators.indexOf(this.text.charAt(index)) != -1) {
            return new Token(this, this.text.substring(index, index + 1), index + 1);
        }
        boolean inQuotes = false;
        StringBuilder token = new StringBuilder();
        for (i2 = index; i2 <= this.maxIndex && this.separators.indexOf(this.text.charAt(i2)) != -1; ++i2) {
        }
        if (i2 > this.maxIndex) {
            return null;
        }
        while (i2 <= this.maxIndex) {
            char c = this.text.charAt(i2);
            if (this.separators.indexOf(c) != -1) {
                if (!inQuotes) return new Token(this, token.toString(), i2);
                token.append(c);
            } else if (c == '\"') {
                inQuotes = !inQuotes;
            } else {
                token.append(c);
            }
            ++i2;
        }
        return new Token(this, token.toString(), i2);
    }

    private class Token {
        final String text;
        final int nextIndex;

        Token(QuotedStringTokenizer quotedStringTokenizer, String text, int nextIndex) {
            this.text = text;
            this.nextIndex = nextIndex;
        }
    }
}

