/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.frostwire.util.Logger;
import org.limewire.util.CommonUtils;

public class MacOSXUtils {
    private static final String APP_NAME = "FrostWire.app";
    private static boolean initialized = false;
    private static final Logger LOG = Logger.getLogger(MacOSXUtils.class);

    private MacOSXUtils() {
    }

    public static void setLoginStatus(boolean allow) {
        if (initialized) {
            String rawDir = CommonUtils.getExecutableDirectory();
            if (!rawDir.contains(APP_NAME)) {
                LOG.info("MacOSXUtils::setLoginStatus(allow=" + allow + ") could not find \"FrostWire.app\" folder in this executable directory (perhaps running from source), not attempting to add/remove from macOS startup list");
                return;
            }
            String path = rawDir.substring(0, rawDir.indexOf(APP_NAME) + APP_NAME.length());
            LOG.info(":SetLoginStatusNative(allow=" + allow + ",path=" + path + ")");
            MacOSXUtils.SetLoginStatusNative(allow, path);
        }
    }

    private static native void SetLoginStatusNative(boolean var0, String var1);

    static {
        try {
            System.loadLibrary("MacOSXUtils");
            initialized = true;
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
    }
}

