/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.settings.URLHandlerSettings;
import com.limegroup.gnutella.util.FWProcess;
import com.limegroup.gnutella.util.LaunchException;
import com.limegroup.gnutella.util.QuotedStringTokenizer;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.SystemUtils;

public final class Launcher {
    private Launcher() {
    }

    public static int openURL(String url) throws IOException {
        if (url == null) {
            return -1;
        }
        if (OSUtils.isWindows()) {
            return Launcher.openURLWindows(url);
        }
        if (OSUtils.isMacOSX()) {
            Launcher.openURLMac(url);
        } else {
            Launcher.launchFileOther(url);
        }
        return -1;
    }

    private static int openURLWindows(String url) throws IOException {
        url = url.replace("&", "^&");
        String[] command = new String[]{"cmd.exe", "/c", "start", url};
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.start();
        return 0;
    }

    private static void openURLMac(String url) throws IOException {
        Runtime.getRuntime().exec(new String[]{"open", url});
    }

    public static FWProcess launchFile(File file) throws IOException, SecurityException {
        List<String> forbiddenExtensions = Arrays.asList("exe", "vbs", "lnk", "bat", "sys", "com", "js", "scpt");
        if (file.isFile() && forbiddenExtensions.contains(FilenameUtils.getExtension(file.getName()))) {
            throw new SecurityException();
        }
        String path = file.getCanonicalPath();
        if (OSUtils.isWindows()) {
            Launcher.launchFileWindows(path);
            return null;
        }
        if (OSUtils.isMacOSX()) {
            return Launcher.launchFileMacOSX(path);
        }
        return Launcher.launchFileOther(path);
    }

    public static void launchExplorer(File file) throws IOException, SecurityException {
        if (OSUtils.isWindows()) {
            String explorePath = file.getPath();
            try {
                explorePath = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (file.isDirectory()) {
                FWProcess.exec(new String[]{"explorer", explorePath});
            } else {
                FWProcess.exec(new String[]{"explorer", "/select,", explorePath});
            }
        } else if (OSUtils.isMacOSX()) {
            FWProcess.exec(Launcher.selectFileCommand(file));
        } else if (OSUtils.isLinux()) {
            if (file.isDirectory()) {
                Desktop.getDesktop().open(file);
            } else if (file.isFile()) {
                Desktop.getDesktop().open(file.getParentFile());
            }
        }
    }

    private static int launchFileWindows(String path) throws IOException {
        try {
            return SystemUtils.openFile(path);
        }
        catch (IOException iox) {
            throw new LaunchException(iox, path);
        }
    }

    private static FWProcess launchFileMacOSX(String file) throws IOException {
        return FWProcess.exec(new String[]{"open", file});
    }

    private static String[] selectFileCommand(File file) {
        String path = null;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException err) {
            path = file.getAbsolutePath();
        }
        return new String[]{"osascript", "-e", "set unixPath to \"" + path + "\"", "-e", "set hfsPath to POSIX file unixPath", "-e", "tell application \"Finder\"", "-e", "activate", "-e", "select hfsPath", "-e", "end tell"};
    }

    private static FWProcess launchFileOther(String path) throws IOException {
        String handler = MediaType.getAudioMediaType().matches(path) ? URLHandlerSettings.AUDIO_PLAYER.getValue() : (MediaType.getVideoMediaType().matches(path) ? URLHandlerSettings.VIDEO_PLAYER.getValue() : (MediaType.getImageMediaType().matches(path) ? URLHandlerSettings.IMAGE_VIEWER.getValue() : URLHandlerSettings.BROWSER.getValue()));
        QuotedStringTokenizer tok = new QuotedStringTokenizer(handler);
        String[] strs = new String[tok.countTokens()];
        for (int i2 = 0; i2 < strs.length; ++i2) {
            strs[i2] = StringUtils.replace(tok.nextToken(), "$URL$", path);
        }
        return FWProcess.exec(strs);
    }
}

