/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.trees;

import com.limegroup.gnutella.gui.trees.AbstractTreeModel;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;

public class FileTreeModel
extends AbstractTreeModel {
    public static final Comparator<File> DEFAULT_COMPARATOR = new FileComparator();
    private final List<File> subRoots;
    private final Hashtable<String, List<File>> subChildren = new Hashtable();
    private File cachedDir;
    private boolean cacheSorted;
    private File[] cache;
    private final Comparator<File> comparator = DEFAULT_COMPARATOR;
    private FileFilter filter = new DefaultFilter(this);
    private final boolean sort = true;

    public FileTreeModel(String root, File ... roots2) {
        super(root);
        if (roots2 != null) {
            this.subRoots = new ArrayList<File>(roots2.length);
            for (File file : roots2) {
                this.addSubRoot(file);
            }
        } else {
            this.subRoots = new ArrayList<File>();
        }
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public int getChildCount(Object node) {
        if (node instanceof File && ((File)node).canRead()) {
            return this.getSubDirs((File)node, false).length;
        }
        if (this.root.getClass().isInstance(node)) {
            if (node.equals(this.root)) {
                return this.subRoots.size();
            }
            return this.subChildren.get(node).size();
        }
        return 0;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof File) {
            File[] children = this.getSubDirs((File)parent, true);
            if (index >= children.length) {
                return null;
            }
            return children[index];
        }
        if (this.root.getClass().isInstance(parent)) {
            if (parent.equals(this.root) && index < this.subRoots.size()) {
                return this.subRoots.get(index);
            }
            List<File> v = this.subChildren.get(parent);
            return index < v.size() ? v.get(index) : null;
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof File) {
            File[] children = this.getSubDirs((File)parent, true);
            if (children == null) {
                return -1;
            }
            for (int i2 = 0; i2 < children.length; ++i2) {
                if (children[i2] != child) continue;
                return i2;
            }
        } else if (this.root.getClass().isInstance(parent)) {
            if (parent.equals(this.root)) {
                return this.subRoots.indexOf(child);
            }
            return this.subChildren.get(parent).indexOf(child);
        }
        return -1;
    }

    private File[] getSubDirs(File f, boolean doSort) {
        if (f == this.cachedDir && this.cacheSorted == doSort) {
            return this.cache;
        }
        File[] children = f.listFiles(this.filter);
        if (children == null) {
            this.cache = new File[0];
        } else {
            this.cache = children;
            if (doSort) {
                Arrays.sort(this.cache, this.comparator);
            }
        }
        this.cachedDir = f;
        this.cacheSorted = doSort;
        return this.cache;
    }

    public void addSubRoot(File f) {
        if (this.subRoots.contains(f)) {
            return;
        }
        this.subRoots.add(f);
        Object[] path = new Object[]{this.root};
        int[] indices = new int[]{this.subRoots.size() - 1};
        Object[] children = new Object[]{f};
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, path, indices, children));
    }

    public boolean isSubRoot(File file) {
        return this.subRoots.contains(file);
    }

    public void removeSubRoot(File f) {
        int index = this.subRoots.indexOf(f);
        if (index != -1) {
            this.subRoots.remove(index);
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, new Object[]{this.root}, new int[]{index}, new Object[]{f}));
        }
    }

    public void removeSubRoots() {
        for (File subRoot : this.subRoots) {
            this.subChildren.remove(subRoot);
        }
        this.subRoots.clear();
        Object[] path = new Object[]{this.root};
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, path));
    }

    @Override
    public void valueForPathChanged(TreePath path, Object value) {
        this.fireTreeNodesChanged(new TreeModelEvent((Object)this, path));
    }

    public void setFileFilter(FileFilter filter) {
        this.filter = filter;
    }

    private class DefaultFilter
    implements FileFilter {
        private DefaultFilter(FileTreeModel fileTreeModel) {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && !file.isHidden();
        }
    }

    static class FileComparator
    implements Comparator<File> {
        FileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.getAbsolutePath().compareToIgnoreCase(o2.getAbsolutePath());
        }
    }
}

