/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.trees;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeModel
implements TreeModel {
    private transient EventListenerList listenerList = new EventListenerList();
    StringBuilder root;

    AbstractTreeModel(String root) {
        this.root = new StringBuilder(root);
    }

    public void changeRootText(String newText) {
        this.root.setLength(0);
        this.root.append(newText);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    void fireTreeNodesInserted(TreeModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i2 + 1]).treeNodesInserted(e);
        }
    }

    void fireTreeNodesRemoved(TreeModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i2 + 1]).treeNodesRemoved(e);
        }
    }

    void fireTreeStructureChanged(TreeModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i2 + 1]).treeStructureChanged(e);
        }
    }

    void fireTreeNodesChanged(TreeModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i2 + 1]).treeNodesChanged(e);
        }
    }

    @Override
    public abstract Object getChild(Object var1, int var2);

    @Override
    public abstract int getChildCount(Object var1);

    @Override
    public abstract int getIndexOfChild(Object var1, Object var2);

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public abstract boolean isLeaf(Object var1);

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object value) {
    }
}

