/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.frostwire.gui.theme.SkinCheckBoxMenuItem;
import com.frostwire.gui.theme.SkinMenu;
import com.frostwire.gui.theme.SkinMenuItem;
import com.frostwire.gui.theme.SkinPopupMenu;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.LastColumnException;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.limewire.setting.BooleanSetting;

class ColumnSelectionMenu {
    private static final String MORE_OPTIONS = I18n.tr("More Options");
    private static final String SORTING = I18n.tr("Sort Automatically");
    private static final String TOOLTIPS = I18n.tr("Extended Tooltips");
    private static final String COLUMN_ID = "columnId";
    private static final String SETTING = "setting";
    private static final ActionListener SETTING_LISTENER = new SettingListener();
    private static final String REVERT_DEFAULT = I18n.tr("Revert To Default");
    private final JPopupMenu _menu = new SkinPopupMenu();
    private final LimeJTable _table;

    ColumnSelectionMenu(LimeJTable table) {
        this._table = table;
        DataLineModel model = (DataLineModel)this._table.getModel();
        ReverterListener reverter = new ReverterListener();
        SkinMenuItem revert = new SkinMenuItem(REVERT_DEFAULT);
        ColumnPreferenceHandler cph = this._table.getColumnPreferenceHandler();
        TableSettings settings2 = this._table.getTableSettings();
        if ((cph == null || cph.isDefault()) && (settings2 == null || settings2.isDefault())) {
            revert.setEnabled(false);
        } else {
            revert.addActionListener(reverter);
        }
        this._menu.add(revert);
        if (settings2 != null) {
            JMenu options = ColumnSelectionMenu.createMoreOptions(settings2);
            this._menu.add(options);
        }
        this._menu.addSeparator();
        this.addTableColumnChoices(new SelectionActionListener(), model, table);
    }

    private static JMenu createMoreOptions(TableSettings settings2) {
        SkinMenu options = new SkinMenu(MORE_OPTIONS);
        ColumnSelectionMenu.addSetting(options, SORTING, settings2.REAL_TIME_SORT);
        ColumnSelectionMenu.addSetting(options, TOOLTIPS, settings2.DISPLAY_TOOLTIPS);
        return options;
    }

    private static void addSetting(JMenu parent, String name, BooleanSetting setting) {
        SkinCheckBoxMenuItem item = new SkinCheckBoxMenuItem(name, setting.getValue());
        item.putClientProperty(SETTING, setting);
        item.addActionListener(SETTING_LISTENER);
        parent.add(item);
    }

    private void addTableColumnChoices(ActionListener listener, DataLineModel<?, ?> model, LimeJTable table) {
        for (int i2 = 0; i2 < model.getColumnCount(); ++i2) {
            JMenuItem item = this.createColumnMenuItem(listener, model, table, i2);
            this._menu.add(item);
        }
    }

    private JMenuItem createColumnMenuItem(ActionListener listener, DataLineModel<?, ?> model, LimeJTable table, int i2) {
        Object id = model.getColumnId(i2);
        String name = model.getColumnName(i2);
        SkinCheckBoxMenuItem item = new SkinCheckBoxMenuItem(name, table.isColumnVisible(id));
        item.putClientProperty(COLUMN_ID, id);
        item.addActionListener(listener);
        return item;
    }

    public JPopupMenu getComponent() {
        return this._menu;
    }

    class ReverterListener
    implements ActionListener {
        ReverterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnSelectionMenu.this._table.getColumnPreferenceHandler().revertToDefault();
            ColumnSelectionMenu.this._table.getTableSettings().revertToDefault();
        }
    }

    class SelectionActionListener
    implements ActionListener {
        SelectionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
            try {
                ColumnSelectionMenu.this._table.setColumnVisible(item.getClientProperty(ColumnSelectionMenu.COLUMN_ID), item.getState());
                ColumnSelectionMenu.this._table.getTableHeader().setDraggedColumn(null);
            }
            catch (LastColumnException ee) {
                GUIMediator.showError(I18n.tr("You cannot turn off all columns."), QuestionsHandler.REMOVE_LAST_COLUMN);
            }
        }
    }

    static class SettingListener
    implements ActionListener {
        SettingListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
            BooleanSetting setting = (BooleanSetting)item.getClientProperty(ColumnSelectionMenu.SETTING);
            setting.setValue(item.getState());
        }
    }
}

