/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.ColoredCell;
import com.limegroup.gnutella.gui.tables.DefaultTableBevelledCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class ColorRenderer
extends DefaultTableBevelledCellRenderer {
    private static final Map<TableCellRenderer, TableCellRenderer> otherRenderers = new HashMap<TableCellRenderer, TableCellRenderer>();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int column) {
        Class clazz;
        Object val;
        Color clr;
        ColoredCell cc = (ColoredCell)value;
        if (cc != null) {
            clr = cc.getColor();
            val = cc.getValue();
            clazz = cc.getCellClass();
        } else {
            clr = null;
            val = "";
            clazz = String.class;
        }
        TableCellRenderer tcr = table.getDefaultRenderer(clazz);
        tcr = this.getCachedOrNewRenderer(tcr);
        Component renderer = tcr.getTableCellRendererComponent(table, val, isSel, hasFocus, row, column);
        if (!isSel && !hasFocus) {
            renderer.setForeground(clr);
        }
        return renderer;
    }

    @Override
    public void updateUI() {
        for (TableCellRenderer o : otherRenderers.values()) {
            if (!(o instanceof JComponent)) continue;
            ((JComponent)((Object)o)).updateUI();
        }
    }

    private TableCellRenderer getCachedOrNewRenderer(TableCellRenderer tcr) {
        TableCellRenderer renderer = otherRenderers.get(tcr);
        if (renderer == null) {
            Class<?> rendererClass = tcr.getClass();
            try {
                renderer = (TableCellRenderer)rendererClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            otherRenderers.put(tcr, renderer);
        }
        return renderer;
    }
}

