/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BasicDataLineModel<T extends DataLine<E>, E>
extends AbstractTableModel
implements DataLineModel<T, E> {
    private static final long serialVersionUID = -974830504558996194L;
    private static final int ASCENDING = 1;
    private static final int DESCENDING = -1;
    private final Class<? extends T> _dataLineClass;
    private final T _internalDataLine;
    protected final List<T> _list = new ArrayList<T>();
    protected int _ascending = 1;
    protected int _activeColumn = -1;
    private boolean _isSorted = false;

    protected BasicDataLineModel(Class<? extends T> dataLineClass) {
        this._dataLineClass = dataLineClass;
        this._internalDataLine = this.createDataLine();
    }

    @Override
    public String[] getToolTipArray(int row, int col) {
        return ((DataLine)this._list.get(row)).getToolTipArray(col);
    }

    @Override
    public boolean isTooltipRequired(int row, int col) {
        return ((DataLine)this._list.get(row)).isTooltipRequired(col);
    }

    @Override
    public boolean isSortAscending() {
        return this._ascending == 1;
    }

    @Override
    public int getSortColumn() {
        return this._activeColumn;
    }

    @Override
    public boolean isSorted() {
        return this._isSorted;
    }

    @Override
    public void sort(int col) {
        if (col == this._activeColumn) {
            if (this._ascending == -1) {
                this.unsort();
                return;
            }
            this._ascending = -1;
        } else {
            this._ascending = 1;
            this._activeColumn = col;
        }
        this._isSorted = true;
        this.resort();
    }

    @Override
    public void resort() {
        if (this._isSorted) {
            this.doResort();
            this.fireTableDataChanged();
        }
    }

    public void unsort() {
        this._isSorted = false;
        this._activeColumn = -1;
    }

    protected void doResort() {
        this._list.sort(this);
    }

    @Override
    public boolean needsResort() {
        return this._isSorted && this._internalDataLine.isDynamic(this._activeColumn);
    }

    @Override
    public void clear() {
        this.cleanup();
        this._list.clear();
        this.fireTableDataChanged();
    }

    protected void cleanup() {
        for (DataLine t : this._list) {
            t.cleanup();
        }
    }

    @Override
    public Object refresh() {
        int end = this._list.size();
        for (DataLine t : this._list) {
            t.update();
        }
        this.fireTableRowsUpdated(0, end);
        return null;
    }

    @Override
    public int update(E o) {
        int row = this.getRow(o);
        ((DataLine)this._list.get(row)).update();
        this.fireTableRowsUpdated(row, row);
        return row;
    }

    protected T createDataLine() {
        try {
            return (T)((DataLine)this._dataLineClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private T getNewDataLine(E o) {
        T dl = this.createDataLine();
        dl.initialize(o);
        return dl;
    }

    private int getSortedPosition(T dl) {
        int row = Collections.binarySearch(this._list, dl, this);
        if (row < 0) {
            row = -(row + 1);
        }
        return row;
    }

    @Override
    public int add(E o) {
        return this.add((T)o, 0);
    }

    @Override
    public int add(E o, int row) {
        T dl = this.getNewDataLine(o);
        return dl == null ? -1 : this.add(dl, row);
    }

    @Override
    public int add(T dl) {
        return this.add(dl, 0);
    }

    @Override
    public int add(T dl, int row) {
        this._list.add(row, dl);
        this.fireTableRowsInserted(row, row);
        return row;
    }

    @Override
    public int addSorted(E o) {
        T dl = this.getNewDataLine(o);
        return dl == null ? -1 : this.add(dl, this.getSortedPosition(dl));
    }

    @Override
    public void addSorted(T dl) {
        this.add(dl, this.getSortedPosition(dl));
    }

    @Override
    public T get(int row) {
        if (row == -1) {
            return null;
        }
        return (T)((DataLine)this._list.get(row));
    }

    @Override
    public T get(E o) {
        int row = this.getRow(o);
        if (row != -1) {
            return (T)((DataLine)this._list.get(row));
        }
        return null;
    }

    @Override
    public T get(Object o, int col) {
        int row = this.getRow(o, col);
        if (row != -1) {
            return (T)((DataLine)this._list.get(row));
        }
        return null;
    }

    @Override
    public void remove(int row) {
        ((DataLine)this._list.get(row)).cleanup();
        this._list.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    @Override
    public void remove(T line) {
        int idx = this._list.indexOf(line);
        if (idx != -1) {
            this.remove(idx);
        }
    }

    @Override
    public void remove(Object o) {
        int end = this._list.size();
        for (int i2 = 0; i2 < end; ++i2) {
            if (!((DataLine)this._list.get(i2)).getInitializeObject().equals(o)) continue;
            this.remove(i2);
            break;
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        return ((DataLine)this._list.get(row)).getValueAt(col);
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
        if (row >= 0 && row < this._list.size()) {
            ((DataLine)this._list.get(row)).setValueAt(o, col);
            this.fireTableRowsUpdated(row, row);
        }
    }

    @Override
    public boolean contains(Object o, int col) {
        for (DataLine t : this._list) {
            if (!t.getValueAt(col).equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        for (DataLine t : this._list) {
            if (!t.getInitializeObject().equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRow(T dl) {
        return this._list.indexOf(dl);
    }

    @Override
    public int getRow(Object o, int col) {
        int end = this._list.size();
        for (int i2 = 0; i2 < end; ++i2) {
            if (!((DataLine)this._list.get(i2)).getValueAt(col).equals(o)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int getRow(E o) {
        int end = this._list.size();
        for (int i2 = 0; i2 < end; ++i2) {
            if (!((DataLine)this._list.get(i2)).getInitializeObject().equals(o)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int compare(T a, T b) {
        Object o1 = a.getValueAt(this._activeColumn);
        Object o2 = b.getValueAt(this._activeColumn);
        return AbstractTableMediator.compare(o1, o2) * this._ascending;
    }

    @Override
    public LimeTableColumn getTableColumn(int col) {
        if (this._internalDataLine == null) {
            return null;
        }
        return this._internalDataLine.getColumn(col);
    }

    @Override
    public int getRowCount() {
        return this._list.size();
    }

    @Override
    public int getColumnCount() {
        if (this._internalDataLine == null) {
            return 0;
        }
        return this._internalDataLine.getColumnCount();
    }

    @Override
    public boolean isClippable(int col) {
        if (this._internalDataLine == null) {
            return false;
        }
        return this._internalDataLine.isClippable(col);
    }

    @Override
    public int getTypeAheadColumn() {
        if (this._internalDataLine == null) {
            return -1;
        }
        return this._internalDataLine.getTypeAheadColumn();
    }

    @Override
    public String getColumnName(int col) {
        return this.getTableColumn(col).getName();
    }

    @Override
    public Object getColumnId(int col) {
        return this.getTableColumn(col).getIdentifier();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return this.getTableColumn(col).getColumnClass();
    }
}

