/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.shell;

import com.limegroup.gnutella.gui.shell.ShellAssociation;
import org.limewire.setting.BooleanSetting;

public class LimeAssociationOption {
    private final ShellAssociation association;
    private final BooleanSetting setting;
    private final String name;
    private final String description;

    LimeAssociationOption(ShellAssociation association, BooleanSetting setting, String name, String description) {
        this.association = association;
        this.setting = setting;
        this.name = name;
        this.description = description;
    }

    public boolean isEnabled() {
        return this.association.isRegistered();
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            if (!this.isAllowed()) {
                throw new IllegalStateException("cannot enable something that isn't allowed");
            }
            this.association.unregister();
            this.association.register();
        } else if (this.association.isRegistered()) {
            this.association.unregister();
        }
    }

    public boolean isAllowed() {
        return this.setting == null || this.setting.getValue();
    }

    public void setAllowed(boolean allow) {
        if (this.setting != null) {
            this.setting.setValue(allow);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAvailable() {
        return this.association.isAvailable();
    }
}

