/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.shell;

import com.frostwire.util.Logger;
import com.frostwire.util.filetypes.Action;
import com.frostwire.util.filetypes.Association;
import com.frostwire.util.filetypes.AssociationAlreadyRegisteredException;
import com.frostwire.util.filetypes.AssociationNotRegisteredException;
import com.frostwire.util.filetypes.AssociationService;
import com.frostwire.util.filetypes.RegisterFailedException;
import com.limegroup.gnutella.gui.shell.ShellAssociation;
import org.limewire.util.SystemUtils;

public class FileTypeAssociation
implements ShellAssociation {
    private static final Logger LOG = Logger.getLogger(FileTypeAssociation.class);
    private static final AssociationService SERVICE = new AssociationService();
    private final String extension;
    private final String mimeType;
    private final String executable;
    private final String verb;
    private final Association association = new Association();

    public FileTypeAssociation(String extension, String mimeType, String executable, String verb, String description, String iconPath) {
        this.extension = extension;
        this.mimeType = mimeType;
        this.executable = executable;
        this.verb = verb;
        Action action = new Action(verb, executable);
        this.association.addAction(action);
        this.association.addFileExtension(extension);
        this.association.setMimeType(mimeType);
        this.association.setName(description);
        this.association.setDescription(description);
        if (iconPath != null) {
            this.association.setIconFileName(iconPath);
        }
    }

    @Override
    public boolean isAvailable() {
        try {
            Association f = SERVICE.getFileExtensionAssociation(this.extension);
            if (f != null && f == SERVICE.getMimeTypeAssociation(this.mimeType)) {
                return true;
            }
        }
        catch (IllegalArgumentException iae) {
            LOG.warn("Can't check availability!", iae);
            return true;
        }
        String extHandler = SystemUtils.getDefaultExtensionHandler(this.extension);
        return "".equals(extHandler) && "".equals(SystemUtils.getDefaultMimeHandler(this.mimeType));
    }

    @Override
    public boolean isRegistered() {
        Association f;
        try {
            f = SERVICE.getFileExtensionAssociation(this.extension);
        }
        catch (IllegalArgumentException iae) {
            LOG.warn("Can't check registration!", iae);
            return false;
        }
        if (f == null) {
            return false;
        }
        Action open = f.getActionByVerb(this.verb);
        if (open == null) {
            return false;
        }
        if (this.executable.equals(open.getCommand())) {
            return true;
        }
        return this.executable.equals(SystemUtils.getDefaultExtensionHandler(this.extension)) && this.executable.equals(SystemUtils.getDefaultMimeHandler(this.mimeType));
    }

    @Override
    public void register() {
        try {
            SERVICE.registerUserAssociation(this.association);
            SystemUtils.flushIconCache();
        }
        catch (AssociationAlreadyRegisteredException | RegisterFailedException ignore) {
            LOG.error("can't addRefreshListener", ignore);
        }
    }

    @Override
    public void unregister() {
        try {
            this.forceUnregister(SERVICE.getFileExtensionAssociation(this.extension));
            this.forceUnregister(SERVICE.getMimeTypeAssociation(this.extension));
        }
        catch (IllegalArgumentException ignored) {
            LOG.warn("Can't unregister!", ignored);
        }
    }

    private void forceUnregister(Association f) {
        if (f == null) {
            return;
        }
        try {
            SERVICE.unregisterUserAssociation(f);
            SystemUtils.flushIconCache();
        }
        catch (AssociationNotRegisteredException | RegisterFailedException ignore) {
            LOG.error("can't unregister", ignore);
        }
    }

    public String toString() {
        return this.extension + ":" + this.mimeType + ":" + this.executable + ":" + this.verb;
    }
}

