/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.tabs.TransfersTab;
import com.frostwire.search.telluride.TellurideSearchResult;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.AbstractUISearchResult;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.util.PopupUtils;
import javax.swing.JPopupMenu;

public class TellurideUISearchResult
extends AbstractUISearchResult {
    private final boolean extractAudio;

    public TellurideUISearchResult(TellurideSearchResult sr, SearchEngine se, String query, boolean extractAudio) {
        super(sr, se, query);
        this.extractAudio = extractAudio;
    }

    @Override
    public void download(boolean partial) {
        TellurideSearchResult sr = (TellurideSearchResult)this.getSearchResult();
        GUIMediator.instance().showTransfers(TransfersTab.FilterMode.ALL);
        GUIMediator.instance().openHttp(sr.getDownloadUrl(), sr.getDisplayName(), sr.getFilename(), sr.getSize(), this.extractAudio);
        this.showSearchResultWebPage(false);
    }

    @Override
    public JPopupMenu createMenu(JPopupMenu popupMenu, SearchResultDataLine[] lines, SearchResultMediator rp) {
        TellurideSearchResult sr = (TellurideSearchResult)this.getSearchResult();
        PopupUtils.addMenuItem(I18n.tr("Copy Download URL"), e -> GUIMediator.setClipboardContent(sr.getDownloadUrl()), popupMenu, true, 0);
        PopupUtils.addMenuItem(SearchMediator.DOWNLOAD_STRING, e -> this.download(false), popupMenu, lines.length > 0, 2);
        PopupUtils.addMenuItem(SearchMediator.TELLURIDE_DETAILS_STRING + " " + sr.getSource(), e -> this.showSearchResultWebPage(true), popupMenu, lines.length == 1, 3);
        return popupMenu;
    }

    @Override
    public String getHash() {
        return null;
    }

    @Override
    public int getSeeds() {
        return 250;
    }
}

