/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.search.telluride.TellurideSearchPerformer;
import com.frostwire.search.telluride.TellurideSearchPerformerListener;
import com.frostwire.search.telluride.TellurideSearchResult;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

final class TellurideSearchPerformerDesktopListener
implements TellurideSearchPerformerListener {
    TellurideSearchPerformerDesktopListener() {
    }

    @Override
    public void onTellurideBinaryNotFound(IllegalArgumentException e) {
        GUIMediator.showError(I18n.tr("telluride component not found.<br><br>Please check your installation or contact support@frostwire.com letting them know about this issue with your") + " FrostWire " + FrostWireUtils.getFrostWireVersion() + " " + I18n.tr("build") + " " + FrostWireUtils.getBuildNumber() + " " + I18n.tr("for") + " " + System.getProperty("os.name"));
    }

    @Override
    public void onTellurideJSONResult(long token, TellurideSearchPerformer.TellurideJSONResult result) {
        SearchMediator.instance().updateSearchPanelTitle(token, result.extractor + ": " + result.title);
    }

    @Override
    public void onError(long token, String errorMessage) {
        SearchMediator.instance().updateSearchPanelTitle(token, errorMessage + " (" + I18n.tr("Right click") + " > " + I18n.tr("Repeat Search") + ")");
    }

    @Override
    public void onSearchResults(long token, List<TellurideSearchResult> results) {
        int audioResults = 0;
        int videoResults = 0;
        for (TellurideSearchResult r : results) {
            NamedMediaType namedMediaType = NamedMediaType.getFromExtension(FilenameUtils.getExtension(r.getFilename()));
            if (namedMediaType == null) continue;
            MediaType mediaType = namedMediaType.getMediaType();
            if (mediaType == MediaType.getAudioMediaType()) {
                ++audioResults;
                continue;
            }
            if (mediaType != MediaType.getVideoMediaType()) continue;
            ++videoResults;
        }
        int audioCount = audioResults;
        int videoCount = videoResults;
        GUIMediator.safeInvokeLater(() -> {
            SearchResultMediator resultPanelForGUID = SearchMediator.getSearchResultDisplayer().getResultPanelForGUID(token);
            if (resultPanelForGUID != null) {
                resultPanelForGUID.showOnlyAudioVideoSchemaBox();
                if (videoCount > 0 && videoCount > audioCount) {
                    resultPanelForGUID.selectMediaType(NamedMediaType.getFromMediaType(MediaType.getVideoMediaType()));
                } else if (audioCount > 0) {
                    resultPanelForGUID.selectMediaType(NamedMediaType.getFromMediaType(MediaType.getAudioMediaType()));
                }
            }
        });
    }
}

