/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.filters.TableLineFilter;
import com.limegroup.gnutella.gui.search.AllowFilter;
import com.limegroup.gnutella.gui.search.ResultPanelModel;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.settings.SearchSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TableRowFilteredModel
extends ResultPanelModel {
    private final List<SearchResultDataLine> HIDDEN;
    private final TableLineFilter<SearchResultDataLine> FILTER;
    private TableLineFilter<SearchResultDataLine> junkFilter = AllowFilter.instance();
    private int _numResults;

    public TableRowFilteredModel(TableLineFilter<SearchResultDataLine> f) {
        if (f == null) {
            throw new NullPointerException("null filter");
        }
        this.FILTER = f;
        this.HIDDEN = new ArrayList<SearchResultDataLine>();
        this._numResults = 0;
    }

    @Override
    public boolean isSorted() {
        return super.isSorted() || SearchSettings.moveJunkToBottom();
    }

    @Override
    public int add(SearchResultDataLine tl, int row) {
        boolean isNotJunk = this.junkFilter.allow(tl);
        boolean allow = this.allow(tl);
        if (isNotJunk || !SearchSettings.hideJunk()) {
            if (allow) {
                return super.add(tl, row);
            }
            this.HIDDEN.add(tl);
            ++this._numResults;
        } else {
            ++this._numResults;
        }
        return -1;
    }

    @Override
    protected void simpleClear() {
        this._numResults = 0;
        this.HIDDEN.clear();
        super.simpleClear();
    }

    @Override
    public void clear() {
        this._numResults = 0;
        this.HIDDEN.clear();
        super.clear();
    }

    void filtersChanged() {
        this.rebuild();
        this.fireTableDataChanged();
    }

    void setJunkFilter(TableLineFilter<SearchResultDataLine> junkFilter) {
        this.junkFilter = junkFilter != null ? junkFilter : AllowFilter.instance();
    }

    private boolean allow(SearchResultDataLine line) {
        return this.FILTER.allow(line);
    }

    private void rebuild() {
        ArrayList existing = new ArrayList(this._list);
        ArrayList<SearchResultDataLine> hidden = new ArrayList<SearchResultDataLine>(this.HIDDEN);
        this.simpleClear();
        if (this.isSorted()) {
            for (SearchResultDataLine searchResultDataLine : existing) {
                this.addSorted(searchResultDataLine);
            }
        } else {
            for (SearchResultDataLine searchResultDataLine : existing) {
                this.add(searchResultDataLine);
            }
        }
        HashMap mergeMap = new HashMap();
        for (SearchResultDataLine tl : hidden) {
            if (this.isSorted()) {
                this.addSorted(tl);
                continue;
            }
            this.add(tl);
        }
        if (this.isSorted()) {
            for (SearchResultDataLine line : mergeMap.values()) {
                this.addSorted(line);
            }
        } else {
            for (SearchResultDataLine line : mergeMap.values()) {
                this.add(line);
            }
        }
    }

    private int getFilteredResults() {
        return super.getTotalResults();
    }

    @Override
    public int getTotalResults() {
        return this.getFilteredResults() + this._numResults;
    }
}

