/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.UISearchResult;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;

public class SourceHolder
implements Comparable<SourceHolder> {
    private final UISearchResult uiSearchResult;
    private final String sourceNameHTML;
    private final String sourceName;
    private final String sourceURL;

    SourceHolder(UISearchResult uiSearchResult) {
        this.uiSearchResult = uiSearchResult;
        this.sourceName = uiSearchResult.getSource();
        this.sourceNameHTML = "<html><div width=\"1000000px\"><nobr><a href=\"#\">" + this.sourceName + "</a></nobr></div></html>";
        this.sourceURL = uiSearchResult.getSearchResult().getDetailsUrl();
    }

    @Override
    public int compareTo(SourceHolder o) {
        return AbstractTableMediator.compare(this.sourceName, o.getSourceName());
    }

    String getSourceName() {
        return this.sourceName;
    }

    String getSourceNameHTML() {
        return this.sourceNameHTML;
    }

    public UISearchResult getUISearchResult() {
        return this.uiSearchResult;
    }

    public String toString() {
        return this.sourceName + " [" + this.sourceURL + "]";
    }
}

