/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.theme.SkinMenuItem;
import com.frostwire.regex.Matcher;
import com.frostwire.regex.Pattern;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.search.SearchMediator;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

final class SeasonalContentSearchSuggestion
extends AbstractAction {
    private static final Pattern SEA_EPI_PATTERN = Pattern.compile("s(\\d+)e(\\d+)");
    private final String query;

    private SeasonalContentSearchSuggestion(String query) {
        this.query = query;
        this.setEnabled(true);
        this.putValue("Name", MessageFormat.format(SearchMediator.SEARCH_FOR_KEYWORDS, query));
    }

    static void attemptToAddSeasonalContentSearchSuggestion(JMenu menu, JPopupMenu popupMenu, List<String> searchTokens) {
        int i2 = 0;
        String nextEpisodeSearchToken = null;
        for (String token : searchTokens) {
            Matcher matcher = SEA_EPI_PATTERN.matcher(token.toLowerCase());
            if (matcher.find()) {
                String season = matcher.group(1);
                String episodeStr = matcher.group(2);
                int nextEpisode = Integer.parseInt(episodeStr) + 1;
                Object nextEpisodeStr = nextEpisode < 10 ? "0" + nextEpisode : String.valueOf(nextEpisode);
                nextEpisodeSearchToken = "s" + season + "e" + (String)nextEpisodeStr;
                break;
            }
            ++i2;
        }
        if (nextEpisodeSearchToken != null) {
            StringBuilder buffer = new StringBuilder();
            for (int j = 0; j < searchTokens.size(); ++j) {
                if (j != i2) {
                    buffer.append(searchTokens.get(j));
                    buffer.append(" ");
                    continue;
                }
                buffer.append(nextEpisodeSearchToken);
                buffer.append(" ");
            }
            String suggestedSearch = buffer.toString().trim();
            if (menu != null) {
                menu.add(new SkinMenuItem(new SeasonalContentSearchSuggestion(suggestedSearch)));
            }
            if (popupMenu != null) {
                popupMenu.add(new SeasonalContentSearchSuggestion(suggestedSearch));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GUIMediator.instance().startSearch(this.query);
    }
}

