/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.AlphaIcon;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.tabs.TransfersTab;
import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.SearchResult;
import com.frostwire.search.StreamableSearchResult;
import com.frostwire.search.archiveorg.ArchiveorgTorrentSearchResult;
import com.frostwire.search.soundcloud.SoundcloudSearchResult;
import com.frostwire.search.telluride.TellurideSearchResult;
import com.frostwire.search.torrent.TorrentSearchResult;
import com.frostwire.search.yt.YTSearchResult;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.FWAbstractJPanelTableCellRenderer;
import com.limegroup.gnutella.gui.search.SearchResultActionsHolder;
import com.limegroup.gnutella.gui.search.TelluridePartialUISearchResult;
import com.limegroup.gnutella.gui.search.UISearchResult;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;

public final class SearchResultActionsRenderer
extends FWAbstractJPanelTableCellRenderer {
    private static final float BUTTONS_TRANSPARENCY = 0.85f;
    private static final ImageIcon play_solid = GUIMediator.getThemeImage("search_result_play_over");
    private static final AlphaIcon play_transparent = new AlphaIcon(play_solid, 0.85f);
    private static final ImageIcon download_solid = GUIMediator.getThemeImage("search_result_download_over");
    private static final AlphaIcon download_transparent = new AlphaIcon(download_solid, 0.85f);
    private static final ImageIcon details_solid = GUIMediator.getThemeImage("search_result_details_over");
    private static final AlphaIcon details_transparent = new AlphaIcon(details_solid, 0.85f);
    private static final ImageIcon speaker_icon = GUIMediator.getThemeImage("speaker");
    private JLabel labelPlay;
    private JLabel labelPartialDownload;
    private JLabel labelDownload;
    private UISearchResult uiSearchResult;
    private boolean showSolid;

    public SearchResultActionsRenderer() {
        this.setupUI();
    }

    private void setupUI() {
        this.setLayout(new GridBagLayout());
        this.labelPlay = new JLabel(play_transparent);
        this.labelPlay.setToolTipText(I18n.tr("Play/Preview"));
        this.labelPlay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SearchResultActionsRenderer.this.labelPlay_mouseReleased(e);
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = -1;
        c.ipadx = 3;
        this.add((Component)this.labelPlay, c);
        this.labelDownload = new JLabel(download_transparent);
        this.labelDownload.setToolTipText(I18n.tr("Download"));
        this.labelDownload.addMouseListener(this.newDownloadAdapter());
        c = new GridBagConstraints();
        c.gridx = -1;
        c.ipadx = 3;
        this.add((Component)this.labelDownload, c);
        this.labelPartialDownload = new JLabel(details_solid);
        this.labelPartialDownload.setToolTipText(I18n.tr("Select content to download from this torrent."));
        this.labelPartialDownload.addMouseListener(this.newDownloadAdapter());
        c = new GridBagConstraints();
        c.gridx = -1;
        c.ipadx = 3;
        this.add((Component)this.labelPartialDownload, c);
        this.setEnabled(true);
    }

    private MouseListener newDownloadAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SearchResultActionsRenderer.this.labelDownloadAction_mouseReleased(e);
            }
        };
    }

    @Override
    protected void updateUIData(Object dataHolder, JTable table, int row, int column) {
        this.updateUIData((SearchResultActionsHolder)dataHolder, table, row);
    }

    private void updateUIData(SearchResultActionsHolder actionsHolder, JTable table, int row) {
        SearchResult sr;
        this.cancelEdit();
        if (actionsHolder == null) {
            return;
        }
        this.uiSearchResult = actionsHolder.getSearchResult();
        if (this.uiSearchResult == null) {
            return;
        }
        this.showSolid = this.mouseIsOverRow(table, row);
        this.labelPlay.setVisible(this.isSearchResultPlayable());
        if (this.labelPlay.isVisible()) {
            this.updatePlayButton();
        }
        boolean isPartialDownload = (sr = this.uiSearchResult.getSearchResult()) instanceof CrawlableSearchResult || sr instanceof ArchiveorgTorrentSearchResult || sr instanceof YTSearchResult;
        this.labelDownload.setIcon(this.showSolid ? download_solid : download_transparent);
        this.labelDownload.setVisible(!isPartialDownload);
        this.labelPartialDownload.setIcon(this.showSolid ? details_solid : details_transparent);
        this.labelPartialDownload.setVisible(isPartialDownload);
    }

    private boolean isSearchResultPlayable() {
        if (this.uiSearchResult instanceof TelluridePartialUISearchResult) {
            return true;
        }
        if (this.uiSearchResult.getSearchResult() instanceof SoundcloudSearchResult) {
            return true;
        }
        if (this.uiSearchResult.getSearchResult() instanceof TellurideSearchResult) {
            return true;
        }
        if (this.uiSearchResult.getSearchResult() instanceof StreamableSearchResult && ((StreamableSearchResult)this.uiSearchResult.getSearchResult()).getStreamUrl() != null && this.uiSearchResult.getExtension() != null) {
            MediaType mediaType = MediaType.getMediaTypeForExtension(this.uiSearchResult.getExtension());
            return mediaType != null && (mediaType.equals(MediaType.getAudioMediaType()) || mediaType.equals(MediaType.getVideoMediaType()));
        }
        return false;
    }

    private void updatePlayButton() {
        this.labelPlay.setIcon(this.isStreamableSourceBeingPlayed(this.uiSearchResult) ? speaker_icon : (this.showSolid ? play_solid : play_transparent));
    }

    private void labelPlay_mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            SearchResult searchResult = this.uiSearchResult.getSearchResult();
            if (searchResult instanceof StreamableSearchResult && !this.isStreamableSourceBeingPlayed(this.uiSearchResult) || searchResult instanceof TellurideSearchResult || searchResult instanceof YTSearchResult) {
                this.uiSearchResult.play();
            }
            this.updatePlayButton();
        }
    }

    private void labelDownloadAction_mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            boolean showTransfers;
            SearchResult sr = this.uiSearchResult.getSearchResult();
            boolean isTorrent = sr instanceof TorrentSearchResult || sr instanceof CrawlableSearchResult;
            this.uiSearchResult.download(isTorrent);
            boolean bl = showTransfers = !(this.uiSearchResult instanceof TelluridePartialUISearchResult);
            if (showTransfers) {
                GUIMediator.instance().showTransfers(TransfersTab.FilterMode.ALL);
            }
        }
    }

    private boolean isStreamableSourceBeingPlayed(UISearchResult sr) {
        SearchResult delegateSearchResult = sr.getSearchResult();
        if (delegateSearchResult instanceof SoundcloudSearchResult && !((SoundcloudSearchResult)delegateSearchResult).fetchedDownloadUrl()) {
            return false;
        }
        return delegateSearchResult instanceof StreamableSearchResult && MediaPlayer.instance().isThisBeingPlayed(((StreamableSearchResult)delegateSearchResult).getStreamUrl());
    }
}

