/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SearchInformation {
    private static final String MAP_TYPE = "type";
    private static final String MAP_QUERY = "query";
    private static final String MAP_XML = "xml";
    private static final String MAP_MEDIA = "media";
    private static final String MAP_TITLE = "title";
    private static final int KEYWORD = 0;
    private final int type;
    private final String query;
    private final String xml;
    private final MediaType media;
    private final String title;

    private SearchInformation(int type, String query, String xml, MediaType media, String title) {
        if (media == null) {
            throw new NullPointerException("null media");
        }
        if (query == null) {
            throw new NullPointerException("null query");
        }
        this.type = type;
        this.query = query.trim();
        this.xml = xml;
        this.media = media;
        this.title = title != null ? title : query;
    }

    private SearchInformation(int type, String query, String xml, MediaType media) {
        this(type, query, xml, media, null);
    }

    public static SearchInformation createKeywordSearch(String query, String xml, MediaType media) {
        return new SearchInformation(0, query, xml, media);
    }

    public static SearchInformation createTitledKeywordSearch(String query, String xml, MediaType media, String title) {
        return new SearchInformation(0, query, xml, media, title);
    }

    public String getQuery() {
        return this.query;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isXMLSearch() {
        return this.xml != null && this.xml.length() > 0;
    }

    public boolean isKeywordSearch() {
        return this.type == 0;
    }

    public String toString() {
        return this.toMap().toString();
    }

    private Map<String, Serializable> toMap() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(5);
        map.put(MAP_TYPE, Integer.valueOf(this.type));
        map.put(MAP_QUERY, (Serializable)((Object)this.query));
        map.put(MAP_XML, (Serializable)((Object)this.xml));
        map.put(MAP_MEDIA, this.media);
        map.put(MAP_TITLE, (Serializable)((Object)this.title));
        return map;
    }
}

