/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.theme.AbstractSkinPainter;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ImageManipulator;
import com.limegroup.gnutella.gui.search.MediaTypeFilter;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.search.UISearchResult;
import com.limegroup.gnutella.settings.SearchSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthRadioButtonUI;
import net.miginfocom.swing.MigLayout;

final class SchemaBox
extends JPanel {
    private final SearchResultMediator resultPanel;
    private final ButtonGroup buttonGroup;
    private final Map<NamedMediaType, JToggleButton> buttonsMap;
    private final Map<NamedMediaType, String> tooltipPlaceHolders;

    SchemaBox(SearchResultMediator resultPanel) {
        this.resultPanel = resultPanel;
        this.buttonGroup = new ButtonGroup();
        this.buttonsMap = new HashMap<NamedMediaType, JToggleButton>();
        this.tooltipPlaceHolders = new HashMap<NamedMediaType, String>();
        this.setLayout(new BorderLayout());
        this.addSchemas();
        this.setBorder(BorderFactory.createEmptyBorder(3, 4, 0, 0));
        Dimension dim = new Dimension(10, 30);
        this.setPreferredSize(dim);
        this.setMinimumSize(dim);
        this.setMaximumSize(new Dimension(100000, 30));
    }

    private static String safeTooltipFormat(String str, String val) {
        try {
            return String.format(str, val);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return str;
        }
    }

    void applyFilters() {
        AbstractButton button = this.getSelectedButton();
        if (button != null) {
            button.doClick();
        }
    }

    void updateCounters(UISearchResult sr) {
        NamedMediaType nmt = NamedMediaType.getFromExtension(sr.getExtension());
        if (nmt != null && this.buttonsMap.containsKey(nmt)) {
            JToggleButton button = this.buttonsMap.get(nmt);
            this.incrementText(button, nmt);
        }
    }

    void resetCounters() {
        Collection<JToggleButton> values2 = this.buttonsMap.values();
        for (JToggleButton button : values2) {
            button.setText("0");
            button.setToolTipText(I18n.tr("No results so far..."));
        }
    }

    private void incrementText(JToggleButton button, NamedMediaType nmt) {
        String text = button.getText();
        int n = 0;
        try {
            n = Integer.parseInt(text);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String incrementedCounterValue = String.valueOf(n + 1);
        button.setText(incrementedCounterValue);
        button.setToolTipText(SchemaBox.safeTooltipFormat(this.tooltipPlaceHolders.get(nmt), incrementedCounterValue));
    }

    private void addSchemas() {
        JPanel panel = new JPanel(new MigLayout("insets 0, fillx"));
        Dimension dim = new Dimension(400, 30);
        panel.setPreferredSize(dim);
        panel.setMinimumSize(dim);
        panel.setMaximumSize(new Dimension(100000, 30));
        NamedMediaType nmt = NamedMediaType.getFromDescription("audio");
        this.tooltipPlaceHolders.put(nmt, I18n.tr("%s Audio files found (including .mp3, .wav, .ogg, and more)"));
        this.addMediaType(panel, nmt, SchemaBox.safeTooltipFormat(this.tooltipPlaceHolders.get(nmt), "0"));
        nmt = NamedMediaType.getFromDescription("video");
        this.tooltipPlaceHolders.put(nmt, I18n.tr("%s Video files found (including .avi, .mpg, .wmv, and more)"));
        this.addMediaType(panel, nmt, SchemaBox.safeTooltipFormat(this.tooltipPlaceHolders.get(nmt), "0"));
        nmt = NamedMediaType.getFromDescription("image");
        this.tooltipPlaceHolders.put(nmt, I18n.tr("%s Image files found (including .jpg, .gif, .png and more)"));
        this.addMediaType(panel, nmt, SchemaBox.safeTooltipFormat(this.tooltipPlaceHolders.get(nmt), "0"));
        nmt = NamedMediaType.getFromDescription("document");
        this.tooltipPlaceHolders.put(nmt, I18n.tr("%s Document files found (including .html, .txt, .pdf, and more)"));
        this.addMediaType(panel, nmt, SchemaBox.safeTooltipFormat(this.tooltipPlaceHolders.get(nmt), "0"));
        nmt = NamedMediaType.getFromDescription("application");
        this.tooltipPlaceHolders.put(nmt, I18n.tr("%s Program files found (including .exe, .zip, .gz, and more)"));
        this.addMediaType(panel, nmt, SchemaBox.safeTooltipFormat(this.tooltipPlaceHolders.get(nmt), "0"));
        nmt = NamedMediaType.getFromDescription("torrent");
        this.tooltipPlaceHolders.put(nmt, I18n.tr("%s Torrent files found (includes only .torrent files. Torrent files point to collections of files shared on the BitTorrent network.)"));
        this.addMediaType(panel, nmt, SchemaBox.safeTooltipFormat(this.tooltipPlaceHolders.get(nmt), "0"));
        this.add((Component)panel, "Before");
    }

    private void addMediaType(JPanel panel, NamedMediaType type, String toolTip) {
        Icon icon = type.getIcon();
        Icon disabledIcon = null;
        Icon rolloverIcon = null;
        JRadioButton button = new JRadioButton("0");
        if (icon != null) {
            disabledIcon = ImageManipulator.darken(icon);
            rolloverIcon = ImageManipulator.brighten(icon);
        }
        button.setIcon(disabledIcon);
        button.setRolloverIcon(rolloverIcon);
        button.setRolloverSelectedIcon(rolloverIcon);
        button.setPressedIcon(rolloverIcon);
        button.setSelectedIcon(rolloverIcon);
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setContentAreaFilled(false);
        button.setMargin(new Insets(4, 6, 4, 6));
        button.setOpaque(false);
        if (toolTip != null) {
            button.setToolTipText(toolTip);
        }
        this.buttonGroup.add(button);
        button.setUI(new SchemaButtonUI(button));
        panel.add(button);
        button.addActionListener(new SchemaButtonActionListener(type));
        button.setSelected(this.isMediaTypeSelected(type));
        this.buttonsMap.put(type, button);
    }

    void selectMediaType(NamedMediaType type) {
        JToggleButton mediaTypeButton = this.buttonsMap.get(type);
        if (mediaTypeButton != null) {
            mediaTypeButton.doClick();
        }
    }

    private boolean isMediaTypeSelected(NamedMediaType type) {
        boolean result = false;
        if (SearchSettings.LAST_MEDIA_TYPE_USED.getValue().contains(type.getMediaType().getMimeType())) {
            result = true;
        }
        if (SearchSettings.LAST_MEDIA_TYPE_USED.getValue().isEmpty() && type.getMediaType().equals(MediaType.getAudioMediaType())) {
            result = true;
        }
        return result;
    }

    private AbstractButton getSelectedButton() {
        AbstractButton selectedButton = null;
        Enumeration<AbstractButton> buttons = this.buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (!button.isSelected()) continue;
            selectedButton = button;
        }
        return selectedButton;
    }

    public void showOnlyAudioVideoSchemaBox() {
        this.buttonsMap.get(NamedMediaType.getFromMediaType(MediaType.getImageMediaType())).setVisible(false);
        this.buttonsMap.get(NamedMediaType.getFromMediaType(MediaType.getDocumentMediaType())).setVisible(false);
        this.buttonsMap.get(NamedMediaType.getFromMediaType(MediaType.getTorrentMediaType())).setVisible(false);
        this.buttonsMap.get(NamedMediaType.getFromMediaType(MediaType.getProgramMediaType())).setVisible(false);
        this.buttonsMap.get(NamedMediaType.getFromMediaType(MediaType.getAudioMediaType())).setVisible(true);
        this.buttonsMap.get(NamedMediaType.getFromMediaType(MediaType.getVideoMediaType())).setVisible(true);
    }

    private static final class SchemaButtonUI
    extends SynthRadioButtonUI {
        final SchemaButtonBackgroundPainter backgroundPainter;
        private final JToggleButton button;

        SchemaButtonUI(JToggleButton button) {
            this.button = button;
            this.backgroundPainter = new SchemaButtonBackgroundPainter();
        }

        @Override
        protected void paint(SynthContext context, Graphics g) {
            if (this.button.isSelected()) {
                this.backgroundPainter.doPaint((Graphics2D)g, this.button, this.button.getWidth(), this.button.getHeight(), null);
            }
            super.paint(context, g);
        }
    }

    private final class SchemaButtonActionListener
    implements ActionListener {
        private final NamedMediaType nmt;
        private final MediaTypeFilter filter;

        SchemaButtonActionListener(NamedMediaType nmt) {
            this.nmt = nmt;
            this.filter = new MediaTypeFilter(nmt);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String mimeType = this.nmt.getMediaType().getMimeType();
            SearchSettings.LAST_MEDIA_TYPE_USED.setValue(mimeType);
            if (SchemaBox.this.resultPanel != null) {
                SchemaBox.this.resultPanel.filterChanged(this.filter, 2);
            }
        }
    }

    private static final class SchemaButtonBackgroundPainter
    extends AbstractSkinPainter {
        private static final Color STROKE = new Color(161, 195, 214);
        private static final Color LIGHT = new Color(203, 224, 236);
        private static final Color DARK = new Color(182, 206, 220);
        private static final Color[] BACKGROUND = new Color[]{LIGHT, DARK};

        private SchemaButtonBackgroundPainter() {
        }

        @Override
        protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
            int w = width - 2;
            int h = height - 1;
            if (this.testValid(0, 0, w, h)) {
                Shape s = this.shapeGenerator.createRectangle(0, 0, w, h);
                Paint background = this.createVerticalGradient(s, BACKGROUND);
                g.setPaint(background);
                g.fill(s);
                g.setPaint(STROKE);
                g.draw(s);
            }
        }
    }
}

