/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.theme.SkinRangeSliderUI;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;

public class RangeSlider
extends JSlider {
    private int thumbNum;
    private BoundedRangeModel[] sliderModels;

    public RangeSlider() {
        this.createThumbs(2);
        this.updateUI();
    }

    public int getLowerValue() {
        return this.getValueAt(0);
    }

    public void setLowerValue(int newValue) {
        this.setValueAt(newValue, 0);
    }

    public int getUpperValue() {
        return this.getValueAt(1);
    }

    public void setUpperValue(int newValue) {
        this.setValueAt(newValue, 1);
    }

    public int getThumbNum() {
        return this.thumbNum;
    }

    public int getValueAt(int index) {
        return this.getModelAt(index).getValue();
    }

    public void setValueAt(int newValue, int index) {
        if (index == 0) {
            newValue = Math.min(this.getValueAt(1) - 1, newValue);
        }
        if (index == 1) {
            newValue = Math.max(this.getValueAt(0) + 1, newValue);
        }
        this.getModelAt(index).setValue(newValue);
        this.getModelAt(index).setRangeProperties(newValue, this.getExtent(), this.getMinimum(), this.getMaximum(), this.getValueIsAdjusting());
    }

    @Override
    public int getMinimum() {
        return this.getModelAt(0).getMinimum();
    }

    @Override
    public void setMinimum(int minimum) {
        int oldMin = this.getModelAt(0).getMinimum();
        for (BoundedRangeModel model : this.sliderModels) {
            model.setMinimum(minimum);
        }
        this.firePropertyChange("minimum", (Object)oldMin, (Object)minimum);
    }

    @Override
    public int getMaximum() {
        return this.getModelAt(0).getMaximum();
    }

    @Override
    public void setMaximum(int maximum) {
        int oldMax = this.getModelAt(0).getMaximum();
        for (BoundedRangeModel model : this.sliderModels) {
            model.setMaximum(maximum);
        }
        this.firePropertyChange("maximum", (Object)oldMax, (Object)maximum);
    }

    @Override
    public int getValue() {
        return 0;
    }

    @Override
    public void setValue(int n) {
    }

    public BoundedRangeModel getModelAt(int index) {
        return this.sliderModels[index];
    }

    @Override
    public void updateUI() {
        super.setUI(new SkinRangeSliderUI(this));
    }

    private void createThumbs(int n) {
        this.thumbNum = n;
        this.sliderModels = new BoundedRangeModel[n];
        for (int i2 = 0; i2 < n; ++i2) {
            this.sliderModels[i2] = new DefaultBoundedRangeModel(50, 0, 0, 100);
        }
        this.sliderModels[0].setValue(0);
        this.sliderModels[1].setValue(100);
    }
}

