/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes.ipfilter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;

public class IPRange {
    private String description;
    private String startAddress;
    private String endAddress;

    public IPRange(String description, String startAddress, String endAddress) {
        if (description == null) {
            throw new IllegalArgumentException("IPRange description can't be null (use empty string)");
        }
        if (startAddress == null || startAddress.isEmpty()) {
            throw new IllegalArgumentException("IPRange startAddress can't be null or empty");
        }
        if (endAddress == null || endAddress.isEmpty()) {
            endAddress = startAddress;
        }
        this.description = description;
        this.startAddress = startAddress;
        this.endAddress = endAddress;
    }

    public static IPRange readObjectFrom(InputStream is) throws IOException {
        int descriptionLength = is.read();
        byte[] descBuffer = new byte[descriptionLength];
        is.read(descBuffer);
        String description = new String(descBuffer, StandardCharsets.UTF_8);
        String startAddress = null;
        int ipVersionType = is.read();
        if (ipVersionType == 4) {
            address = new byte[4];
            is.read(address);
            startAddress = InetAddress.getByAddress(address).getHostAddress();
        } else if (ipVersionType == 6) {
            address = new byte[16];
            is.read(address);
            startAddress = InetAddress.getByAddress(address).getHostAddress();
        }
        String endAddress = null;
        ipVersionType = is.read();
        if (ipVersionType == 4) {
            byte[] address2 = new byte[4];
            is.read(address2);
            endAddress = InetAddress.getByAddress(address2).getHostAddress();
        } else if (ipVersionType == 6) {
            byte[] address3 = new byte[16];
            is.read(address3);
            endAddress = InetAddress.getByAddress(address3).getHostAddress();
        }
        return new IPRange(description, startAddress, endAddress);
    }

    public String description() {
        return this.description;
    }

    public String startAddress() {
        return this.startAddress;
    }

    public String endAddress() {
        return this.endAddress;
    }

    public void writeObjectTo(OutputStream os) throws IOException {
        os.write(this.description.length());
        os.write(this.description.getBytes(StandardCharsets.UTF_8));
        InetAddress bufferRange = InetAddress.getByName(this.startAddress);
        boolean isIPv4 = bufferRange instanceof Inet4Address;
        os.write(isIPv4 ? 4 : 6);
        os.write(bufferRange.getAddress());
        bufferRange = InetAddress.getByName(this.endAddress);
        isIPv4 = bufferRange instanceof Inet4Address;
        os.write(isIPv4 ? 4 : 6);
        os.write(bufferRange.getAddress());
        os.flush();
    }

    public String toString() {
        return "IPRange@" + this.hashCode() + " { description = \"" + this.description + "\", startAddress = \"" + this.startAddress + "\", endAddress = \"" + this.endAddress + "\" }";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IPRange)) {
            return false;
        }
        IPRange other = (IPRange)obj;
        return other.startAddress.equals(this.startAddress) && other.endAddress.equals(this.endAddress);
    }

    public int hashCode() {
        return this.startAddress.hashCode() * this.endAddress.hashCode() * 9419;
    }
}

