/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes.ipfilter;

import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.regex.Pattern;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.IPFilterPaneItem;
import com.limegroup.gnutella.gui.options.panes.ipfilter.IPRange;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class AddRangeManuallyDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(AddRangeManuallyDialog.class);
    private static final Pattern IPV4_PATTERN = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])", 2);
    private static final Pattern IPV6_PATTERN = Pattern.compile("([0-9a-f]{1,4}\\:{1,2}){4,7}([0-9a-f]){1,4}", 2);
    private final IPFilterPaneItem dialogListener;
    private final JTextField descriptionTextField;
    private final JTextField rangeStartTextField;
    private final JTextField rangeEndTextField;

    public AddRangeManuallyDialog(IPFilterPaneItem dialogListener) {
        super((Dialog)AddRangeManuallyDialog.getParentDialog(dialogListener), true);
        String addIPRangeManuallyString = I18n.tr("Add IP Range Manually");
        this.setTitle(addIPRangeManuallyString);
        this.dialogListener = dialogListener;
        JPanel panel = new JPanel(new MigLayout("fillx, ins 0, insets, nogrid"));
        panel.add((Component)new JLabel(I18n.tr("Description")), "wrap");
        this.descriptionTextField = new JTextField();
        panel.add((Component)this.descriptionTextField, "growx, wrap");
        panel.add((Component)new JLabel("<html><strong>" + I18n.tr("Starting IP address") + "</strong></html>"), "wrap");
        this.rangeStartTextField = new JTextField();
        panel.add((Component)this.rangeStartTextField, "w 250px, wrap");
        panel.add((Component)new JLabel("<html><strong>" + I18n.tr("Ending IP address") + "</strong><br/><i>" + I18n.tr("Leave blank or repeat 'Starting IP address' to block a single one") + "</i></html>"), "growx ,wrap");
        this.rangeEndTextField = new JTextField();
        panel.add((Component)this.rangeEndTextField, "w 250px, gapbottom 10px, wrap");
        ThemeMediator.fixKeyStrokes(this.descriptionTextField);
        ThemeMediator.fixKeyStrokes(this.rangeStartTextField);
        ThemeMediator.fixKeyStrokes(this.rangeEndTextField);
        JButton addRangeButton = new JButton(addIPRangeManuallyString);
        panel.add((Component)addRangeButton, "growx");
        addRangeButton.addActionListener(e -> this.onAddRangeButtonClicked());
        JButton cancelButton = new JButton(I18n.tr("Cancel"));
        cancelButton.addActionListener(e -> this.dispose());
        panel.add((Component)cancelButton, "growx");
        this.setContentPane(panel);
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        this.pack();
    }

    private static JDialog getParentDialog(IPFilterPaneItem paneItem) {
        Container result = paneItem.getContainer();
        do {
            result = result.getParent();
            LOG.info("getParentDialog: getContainer -> " + result.getClass().getName());
        } while (!(result instanceof JDialog));
        return (JDialog)result;
    }

    private void onAddRangeButtonClicked() {
        if (!this.validateInput()) {
            return;
        }
        this.dispose();
        this.dialogListener.onRangeManuallyAdded(new IPRange(this.descriptionTextField.getText(), this.rangeStartTextField.getText(), this.rangeEndTextField.getText()));
    }

    private boolean validateInput() {
        String rangeStart = this.rangeStartTextField.getText().trim();
        String rangeEnd = this.rangeEndTextField.getText().trim();
        if (this.isInvalidIPAddress(rangeStart, IPAddressFormat.IPV4) && this.isInvalidIPAddress(rangeStart, IPAddressFormat.IPV6)) {
            this.rangeStartTextField.selectAll();
            this.rangeStartTextField.requestFocus();
            return false;
        }
        if (!rangeEnd.isEmpty() && this.isInvalidIPAddress(rangeEnd, IPAddressFormat.IPV4) && this.isInvalidIPAddress(rangeEnd, IPAddressFormat.IPV6)) {
            this.rangeEndTextField.selectAll();
            this.rangeEndTextField.requestFocus();
            return false;
        }
        String description = this.descriptionTextField.getText().trim();
        if (description.isEmpty()) {
            description = I18n.tr("Not available");
        }
        try {
            new IPRange(description, rangeStart, rangeEnd);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private boolean isInvalidIPAddress(String potentialIPAddress, IPAddressFormat format) {
        if (potentialIPAddress == null || potentialIPAddress.isEmpty()) {
            return true;
        }
        Pattern pattern = format == IPAddressFormat.IPV4 ? IPV4_PATTERN : IPV6_PATTERN;
        return !pattern.matcher(potentialIPAddress).find();
    }

    private static enum IPAddressFormat {
        IPV4,
        IPV6;

    }
}

