/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.frostwire.bittorrent.BTEngine;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import java.awt.Font;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;

public final class TorrentGlobalSpeedPaneItem
extends AbstractPaneItem {
    private static final String TITLE_DOWNLOAD_SPEED = I18n.tr("BitTorrent Global Tranfer Speeds");
    private static final String DESCRIPTION_DOWNLOAD_SPEED = I18n.tr("Set the Maximum BitTorrent transfer speeds in KB/s.\nTip: Use your keyboard arrows for more precision");
    private static final int MAX_SLIDER_VALUE = 102401;
    private static final String DESCRIPTION_UPLOAD_SPEED = "<html>" + I18n.tr("Set the Maximum BitTorrent upload speed in KB/s.") + "<p>" + I18n.tr("Note: Too low upload speeds (leeching) could be penalized by some trackers, resulting in slower downloads.") + "</p></html>";
    private final JLabel DOWNLOAD_SLIDER_LABEL = new JLabel();
    private final JLabel UPLOAD_SLIDER_LABEL = new JLabel();
    private final JSlider DOWNLOAD_SLIDER = new JSlider(1, 102401);
    private final JSlider UPLOAD_SLIDER = new JSlider(1, 102401);

    public TorrentGlobalSpeedPaneItem() {
        super(TITLE_DOWNLOAD_SPEED, DESCRIPTION_DOWNLOAD_SPEED);
        this.DOWNLOAD_SLIDER.setMajorTickSpacing(1024);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        JLabel label1 = new JLabel(I18n.tr("Min speed"));
        JLabel label2 = new JLabel(I18n.tr("Max speed"));
        Font font = new Font("Helvetica", 1, 10);
        label1.setFont(font);
        label2.setFont(font);
        labelTable.put(1, label1);
        labelTable.put(103424, label2);
        this.DOWNLOAD_SLIDER.setLabelTable(labelTable);
        this.DOWNLOAD_SLIDER.setPaintLabels(true);
        this.DOWNLOAD_SLIDER.addChangeListener(e -> this.updateSpeedLabel(this.DOWNLOAD_SLIDER, this.DOWNLOAD_SLIDER_LABEL));
        String LABEL_DOWNLOAD_SPEED = I18n.tr("Download Speed:");
        LabeledComponent comp = new LabeledComponent(LABEL_DOWNLOAD_SPEED, this.DOWNLOAD_SLIDER_LABEL, 120, 10);
        this.add(this.DOWNLOAD_SLIDER);
        this.add(this.getVerticalSeparator());
        this.add(comp.getComponent());
        this.UPLOAD_SLIDER.setMajorTickSpacing(1024);
        Hashtable<Integer, JLabel> labelTableUp = new Hashtable<Integer, JLabel>();
        JLabel label1Up = new JLabel(I18n.tr("Min speed"));
        JLabel label2Up = new JLabel(I18n.tr("Max speed"));
        label1Up.setFont(font);
        label2Up.setFont(font);
        labelTableUp.put(1, label1Up);
        labelTableUp.put(103424, label2Up);
        this.UPLOAD_SLIDER.setLabelTable(labelTableUp);
        this.UPLOAD_SLIDER.setPaintLabels(true);
        this.UPLOAD_SLIDER.addChangeListener(e -> this.updateSpeedLabel(this.UPLOAD_SLIDER, this.UPLOAD_SLIDER_LABEL));
        String LABEL_UPLOAD_SPEED = I18n.tr("Upload Speed:");
        LabeledComponent compUp = new LabeledComponent(LABEL_UPLOAD_SPEED, this.UPLOAD_SLIDER_LABEL, 120, 10);
        JLabel DESCRIPTION_UPLOAD_SPEED_LABEL = new JLabel(DESCRIPTION_UPLOAD_SPEED);
        this.add(DESCRIPTION_UPLOAD_SPEED_LABEL);
        this.add(this.UPLOAD_SLIDER);
        this.add(this.getVerticalSeparator());
        this.add(compUp.getComponent());
    }

    private void updateSpeedLabel(JSlider slider, JLabel label) {
        float value = slider.getValue();
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumFractionDigits(2);
        String labelText = formatter.format(value) + " KB/s";
        if (value > 102400.0f) {
            label.setText(I18n.tr("Unlimited"));
        } else {
            label.setText(labelText);
        }
    }

    @Override
    public void initOptions() {
        int storedDownloadSpeed = BTEngine.getInstance().downloadRateLimit() / 1024;
        if (storedDownloadSpeed == 0) {
            this.DOWNLOAD_SLIDER.setValue(103424);
            this.DOWNLOAD_SLIDER_LABEL.setText(I18n.tr("Unlimited"));
        } else {
            this.DOWNLOAD_SLIDER.setValue(storedDownloadSpeed);
        }
        this.updateSpeedLabel(this.DOWNLOAD_SLIDER, this.DOWNLOAD_SLIDER_LABEL);
        int storedUploadSpeed = BTEngine.getInstance().uploadRateLimit() / 1024;
        if (storedUploadSpeed == 0) {
            this.UPLOAD_SLIDER.setValue(103424);
            this.UPLOAD_SLIDER_LABEL.setText(I18n.tr("Unlimited"));
        } else {
            this.UPLOAD_SLIDER.setValue(storedUploadSpeed);
        }
        this.updateSpeedLabel(this.UPLOAD_SLIDER, this.UPLOAD_SLIDER_LABEL);
    }

    @Override
    public boolean applyOptions() {
        int newUpload = this.UPLOAD_SLIDER.getValue();
        int newDownload = this.DOWNLOAD_SLIDER.getValue();
        if (newUpload == 102401) {
            newUpload = 0;
        }
        if (newDownload == 102401) {
            newDownload = 0;
        }
        BTEngine.getInstance().downloadRateLimit(newDownload * 1024);
        BTEngine.getInstance().uploadRateLimit(newUpload * 1024);
        this.DOWNLOAD_SLIDER.setValue(newDownload == 0 ? 102401 : newDownload);
        this.UPLOAD_SLIDER.setValue(newUpload == 0 ? 102401 : newUpload);
        this.updateSpeedLabel(this.UPLOAD_SLIDER, this.UPLOAD_SLIDER_LABEL);
        this.updateSpeedLabel(this.DOWNLOAD_SLIDER, this.DOWNLOAD_SLIDER_LABEL);
        return false;
    }

    @Override
    public boolean isDirty() {
        return false;
    }
}

