/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.frostwire.bittorrent.BTEngine;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.VPNs;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import javax.swing.JCheckBox;

public final class TorrentConnectionPaneItem
extends AbstractPaneItem {
    private static final String TITLE = I18n.tr("BitTorrent Connection Settings");
    private static final String TEXT = I18n.tr("Adjust connection settings to make better use of your internet connection");
    private static final String MAX_ACTIVE_DOWNLOADS = I18n.tr("Maximum active downloads");
    private static final String MAX_GLOBAL_NUM_CONNECTIONS = I18n.tr("Global maximum number of connections");
    private static final String MAX_PEERS = I18n.tr("Maximum number of peers");
    private static final String MAX_ACTIVE_SEEDS = I18n.tr("Maximum active seeds");
    private static final String ENABLE_DISTRIBUTED_HASH_TABLE = I18n.tr("Enable Distributed Hash Table (DHT)");
    private static final String VPN_DROP_PROTECTION = I18n.tr("VPN-Drop Protection. Require VPN connection for BitTorrent");
    private final JCheckBox ENABLE_DISTRIBUTED_HASH_TABLE_CHECKBOX_FIELD = new JCheckBox();
    private final JCheckBox VPN_DROP_PROTECTION_CHECKBOX = new JCheckBox();
    private final WholeNumberField MAX_ACTIVE_DOWNLOADS_FIELD = new SizedWholeNumberField(4);
    private final WholeNumberField MAX_GLOBAL_NUM_CONNECTIONS_FIELD = new SizedWholeNumberField(4);
    private final WholeNumberField MAX_PEERS_FIELD = new SizedWholeNumberField(4);
    private final WholeNumberField MAX_ACTIVE_SEEDS_FIELD = new SizedWholeNumberField(4);

    public TorrentConnectionPaneItem() {
        super(TITLE, TEXT);
        BoxPanel panel = new BoxPanel();
        LabeledComponent comp = new LabeledComponent(ENABLE_DISTRIBUTED_HASH_TABLE, this.ENABLE_DISTRIBUTED_HASH_TABLE_CHECKBOX_FIELD, 120, 10);
        panel.add(comp.getComponent());
        panel.addVerticalComponentGap();
        if (GUIConstants.Feature.VPN_DROP_GUARD.enabled()) {
            comp = new LabeledComponent(VPN_DROP_PROTECTION, this.VPN_DROP_PROTECTION_CHECKBOX, 120, 10);
            panel.add(comp.getComponent());
            panel.addVerticalComponentGap();
        }
        comp = new LabeledComponent(MAX_ACTIVE_DOWNLOADS, this.MAX_ACTIVE_DOWNLOADS_FIELD, 120, 10);
        panel.add(comp.getComponent());
        panel.addVerticalComponentGap();
        comp = new LabeledComponent(MAX_ACTIVE_SEEDS, this.MAX_ACTIVE_SEEDS_FIELD, 120, 10);
        panel.add(comp.getComponent());
        panel.addVerticalComponentGap();
        comp = new LabeledComponent(MAX_GLOBAL_NUM_CONNECTIONS, this.MAX_GLOBAL_NUM_CONNECTIONS_FIELD, 120, 10);
        panel.add(comp.getComponent());
        panel.addVerticalComponentGap();
        comp = new LabeledComponent(MAX_PEERS, this.MAX_PEERS_FIELD, 120, 10);
        panel.add(comp.getComponent());
        panel.addVerticalComponentGap();
        this.add(panel);
    }

    @Override
    public boolean isDirty() {
        BTEngine btEngine = BTEngine.getInstance();
        return btEngine.isDhtRunning() == this.ENABLE_DISTRIBUTED_HASH_TABLE_CHECKBOX_FIELD.isSelected() || ConnectionSettings.VPN_DROP_PROTECTION.getValue() != this.VPN_DROP_PROTECTION_CHECKBOX.isSelected() || btEngine.maxActiveDownloads() != this.MAX_ACTIVE_DOWNLOADS_FIELD.getValue() || btEngine.maxConnections() != this.MAX_GLOBAL_NUM_CONNECTIONS_FIELD.getValue() || btEngine.maxPeers() != this.MAX_PEERS_FIELD.getValue() || btEngine.maxActiveSeeds() != this.MAX_ACTIVE_SEEDS_FIELD.getValue();
    }

    @Override
    public void initOptions() {
        BTEngine btEngine = BTEngine.getInstance();
        this.ENABLE_DISTRIBUTED_HASH_TABLE_CHECKBOX_FIELD.setSelected(SharingSettings.ENABLE_DISTRIBUTED_HASH_TABLE.getValue());
        this.VPN_DROP_PROTECTION_CHECKBOX.setSelected(ConnectionSettings.VPN_DROP_PROTECTION.getValue());
        this.MAX_GLOBAL_NUM_CONNECTIONS_FIELD.setValue(btEngine.maxConnections());
        this.MAX_PEERS_FIELD.setValue(btEngine.maxPeers());
        this.MAX_ACTIVE_DOWNLOADS_FIELD.setValue(btEngine.maxActiveDownloads());
        this.MAX_ACTIVE_SEEDS_FIELD.setValue(btEngine.maxActiveSeeds());
    }

    @Override
    public boolean applyOptions() {
        BTEngine btEngine = BTEngine.getInstance();
        this.applyDHTOptions(btEngine);
        this.applyVPNDropProtectionOption(btEngine);
        btEngine.maxConnections(this.MAX_GLOBAL_NUM_CONNECTIONS_FIELD.getValue());
        btEngine.maxPeers(this.MAX_PEERS_FIELD.getValue());
        btEngine.maxActiveDownloads(this.MAX_ACTIVE_DOWNLOADS_FIELD.getValue());
        btEngine.maxActiveSeeds(this.MAX_ACTIVE_SEEDS_FIELD.getValue());
        return this.isDirty();
    }

    private void applyDHTOptions(BTEngine btEngine) {
        boolean dhtExpectedValue = this.ENABLE_DISTRIBUTED_HASH_TABLE_CHECKBOX_FIELD.isSelected();
        boolean dhtCurrentStatus = btEngine.isDhtRunning();
        if (dhtCurrentStatus && !dhtExpectedValue) {
            btEngine.stopDht();
            SharingSettings.ENABLE_DISTRIBUTED_HASH_TABLE.setValue(false);
        } else if (!dhtCurrentStatus && dhtExpectedValue) {
            btEngine.startDht();
            SharingSettings.ENABLE_DISTRIBUTED_HASH_TABLE.setValue(true);
        }
    }

    private void applyVPNDropProtectionOption(BTEngine btEngine) {
        boolean vpnDropProtectionSelected = this.VPN_DROP_PROTECTION_CHECKBOX.isSelected();
        if (vpnDropProtectionSelected && !VPNs.isVPNActive()) {
            btEngine.pause();
        } else if (!vpnDropProtectionSelected && btEngine.isPaused()) {
            btEngine.resume();
        }
        ConnectionSettings.VPN_DROP_PROTECTION.setValue(vpnDropProtectionSelected);
        GUIMediator.instance().getStatusLine().updateVPNDropProtectionLabelState();
        GUIMediator.instance().getStatusLine().refresh();
    }
}

