/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.gui.search.SearchEngine;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.limewire.setting.BooleanSetting;

public final class SearchEnginesPaneItem
extends AbstractPaneItem {
    private static final String TITLE = I18n.tr("Search Engines");
    private static final String LABEL = I18n.tr("Select which search engines you want FrostWire to use.");
    private final Map<JCheckBox, BooleanSetting> cBoxes;
    private final List<JCheckBox> searchEngineCheckboxes = new LinkedList<JCheckBox>();
    private final SearchEngineCheckboxListener searchEnginesCheckboxListener;
    private JCheckBox allCheckbox;

    public SearchEnginesPaneItem() {
        super(TITLE, LABEL);
        this.cBoxes = new HashMap<JCheckBox, BooleanSetting>();
        this.searchEnginesCheckboxListener = new SearchEngineCheckboxListener(this.cBoxes);
        this.add(this.createSearchEnginesCheckboxPanel());
        this.add(this.createToggleAllCheckbox());
    }

    @Override
    public void initOptions() {
    }

    @Override
    public boolean applyOptions() {
        return false;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    private Component createToggleAllCheckbox() {
        JPanel panel = new JPanel();
        panel.setMinimumSize(new Dimension(300, 60));
        panel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        BoxLayout layout = new BoxLayout(panel, 3);
        panel.setLayout(layout);
        panel.add(Box.createHorizontalGlue());
        panel.add(new JSeparator());
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.allCheckbox = new JCheckBox(I18n.tr("Check/Uncheck all"));
        panel.add(this.allCheckbox);
        this.allCheckbox.setSelected(this.areAll(true));
        this.allCheckbox.addItemListener(e -> {
            JCheckBox cBox = (JCheckBox)e.getItemSelectable();
            this.checkAll(cBox.isSelected());
        });
        return panel;
    }

    private JComponent createSearchEnginesCheckboxPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new MigLayout("insets 2, wrap 4, gap 8"));
        List<SearchEngine> searchEngines = SearchEngine.getEngines();
        this.setupCheckboxes(searchEngines, panel);
        return panel;
    }

    private void setupCheckboxes(List<SearchEngine> searchEngines, JPanel parent) {
        for (SearchEngine se : searchEngines) {
            JCheckBox cBox = new JCheckBox(se.getName());
            this.searchEngineCheckboxes.add(cBox);
            cBox.setSelected(se.isEnabled());
            cBox.setEnabled(true);
            parent.add(cBox);
            this.cBoxes.put(cBox, se.getEnabledSetting());
            cBox.addItemListener(this.searchEnginesCheckboxListener);
        }
    }

    private boolean areAll(boolean selected) {
        for (JCheckBox cBox : this.searchEngineCheckboxes) {
            if ((!selected || cBox.isSelected()) && (selected || !cBox.isSelected())) continue;
            return false;
        }
        return true;
    }

    private void checkAll(boolean checked) {
        this.searchEnginesCheckboxListener.enable(false);
        for (JCheckBox cBox : this.searchEngineCheckboxes) {
            cBox.setSelected(checked);
            this.cBoxes.get(cBox).setValue(cBox.isSelected());
        }
        this.searchEnginesCheckboxListener.enable(true);
        if (!checked) {
            this.searchEngineCheckboxes.get(0).setSelected(true);
        }
    }

    private void autoSelectAllCheckbox(boolean allSelected) {
        ItemListener[] itemListeners;
        for (ItemListener l : itemListeners = this.allCheckbox.getItemListeners()) {
            this.allCheckbox.removeItemListener(l);
        }
        this.allCheckbox.setSelected(allSelected);
        for (ItemListener l : itemListeners) {
            this.allCheckbox.addItemListener(l);
        }
    }

    private class SearchEngineCheckboxListener
    implements ItemListener {
        final Map<JCheckBox, BooleanSetting> cBoxes;
        private boolean enabled;

        SearchEngineCheckboxListener(Map<JCheckBox, BooleanSetting> cBoxes) {
            this.cBoxes = cBoxes;
            this.enabled = true;
        }

        void enable(boolean e) {
            this.enabled = e;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (this.enabled) {
                JCheckBox cBox = (JCheckBox)e.getItemSelectable();
                if (SearchEnginesPaneItem.this.areAll(false)) {
                    cBox.setSelected(true);
                    return;
                }
                this.cBoxes.get(cBox).setValue(cBox.isSelected());
            }
            SearchEnginesPaneItem.this.autoSelectAllCheckbox(SearchEnginesPaneItem.this.areAll(true));
        }
    }
}

