/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.limewire.util.NetworkUtils;

public final class RouterConfigurationPaneItem
extends AbstractPaneItem {
    private static final String TITLE = I18n.tr("Router Configuration");
    private static final String LABEL = I18n.tr("FrostWire can configure itself to work from behind a firewall or router. Using Universal Plug 'n Play (UPnP) and other NAT traversal techniques FrostWire can automatically configure your router or firewall for optimal performance. If your router does not support UPnP, FrostWire can be set to advertise an external port manually. (You may also have to configure your router if you choose manual configuration, but FrostWire will try its best so you don't have to.)");
    private final WholeNumberField PORT_0_FIELD = new SizedWholeNumberField();
    private final WholeNumberField PORT_1_FIELD = new SizedWholeNumberField();
    private final JRadioButton RANDOM_PORT = new JRadioButton(I18n.tr("Use random port (Recommended)"));
    private final JRadioButton MANUAL_PORT = new JRadioButton(I18n.tr("Manual port range"));
    private final JLabel _labelPort0;
    private final JLabel _labelPort1;
    private static final int PORT_RANGE_MIN = ConnectionSettings.PORT_RANGE_0.getDefaultValue();
    private static final int PORT_RANGE_MAX = ConnectionSettings.PORT_RANGE_1.getDefaultValue();

    public RouterConfigurationPaneItem() {
        super(TITLE, LABEL);
        ButtonGroup BUTTONS = new ButtonGroup();
        BUTTONS.add(this.RANDOM_PORT);
        BUTTONS.add(this.MANUAL_PORT);
        this.MANUAL_PORT.addItemListener(new LocalPortListener());
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 6);
        panel.add((Component)this.RANDOM_PORT, c);
        c.gridwidth = 0;
        panel.add((Component)this.MANUAL_PORT, c);
        this._labelPort0 = new JLabel(I18n.tr("TCP port start:"));
        c = new GridBagConstraints();
        c.gridwidth = -1;
        c.insets = new Insets(0, 10, 0, 5);
        panel.add((Component)this._labelPort0, c);
        c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 17;
        panel.add((Component)this.PORT_0_FIELD, c);
        this._labelPort1 = new JLabel(I18n.tr("TCP port end:"));
        c = new GridBagConstraints();
        c.gridwidth = -1;
        c.insets = new Insets(0, 10, 0, 5);
        panel.add((Component)this._labelPort1, c);
        c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 17;
        panel.add((Component)this.PORT_1_FIELD, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add(Box.createGlue(), c);
        GUIUtils.restrictSize(panel, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
        this.add(panel);
    }

    private void updateState() {
        this._labelPort0.setEnabled(this.MANUAL_PORT.isSelected());
        this._labelPort1.setEnabled(this.MANUAL_PORT.isSelected());
        this.PORT_0_FIELD.setEnabled(this.MANUAL_PORT.isSelected());
        this.PORT_1_FIELD.setEnabled(this.MANUAL_PORT.isSelected());
    }

    @Override
    public void initOptions() {
        this.RANDOM_PORT.setSelected(!ConnectionSettings.MANUAL_PORT_RANGE.getValue());
        this.MANUAL_PORT.setSelected(ConnectionSettings.MANUAL_PORT_RANGE.getValue());
        this.PORT_0_FIELD.setValue(ConnectionSettings.PORT_RANGE_0.getValue());
        this.PORT_1_FIELD.setValue(ConnectionSettings.PORT_RANGE_1.getValue());
        this.updateState();
    }

    @Override
    public boolean applyOptions() throws IOException {
        if (this.RANDOM_PORT.isSelected()) {
            ConnectionSettings.MANUAL_PORT_RANGE.setValue(false);
        } else {
            int tcpRangeStart = this.PORT_0_FIELD.getValue();
            int tcpRangeEnd = this.PORT_1_FIELD.getValue();
            if (!NetworkUtils.isValidPort(tcpRangeStart, PORT_RANGE_MIN, PORT_RANGE_MAX)) {
                GUIMediator.showError(I18n.tr("You must enter a port between {0} and {1} when manually forcing port.", PORT_RANGE_MIN, PORT_RANGE_MAX));
                throw new IOException("bad port: " + tcpRangeStart);
            }
            if (tcpRangeStart < 0 || tcpRangeEnd < tcpRangeStart) {
                GUIMediator.showError(I18n.tr("You must enter a valid port range."));
                throw new IOException("bad port: " + tcpRangeEnd);
            }
            ConnectionSettings.MANUAL_PORT_RANGE.setValue(true);
            ConnectionSettings.PORT_RANGE_0.setValue(tcpRangeStart);
            ConnectionSettings.PORT_RANGE_1.setValue(tcpRangeEnd);
        }
        return true;
    }

    @Override
    public boolean isDirty() {
        if (ConnectionSettings.MANUAL_PORT_RANGE.getValue() != this.MANUAL_PORT.isSelected()) {
            return true;
        }
        return this.MANUAL_PORT.isSelected() && (this.PORT_0_FIELD.getValue() != ConnectionSettings.PORT_RANGE_0.getValue() || this.PORT_1_FIELD.getValue() != ConnectionSettings.PORT_RANGE_1.getValue());
    }

    private class LocalPortListener
    implements ItemListener {
        private LocalPortListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            RouterConfigurationPaneItem.this.updateState();
        }
    }
}

