/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.frostwire.bittorrent.BTEngine;
import com.frostwire.jlibtorrent.Address;
import com.frostwire.jlibtorrent.EnumNet;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.limewire.util.NetworkUtils;

public class NetworkInterfacePaneItem
extends AbstractPaneItem {
    private static final String TITLE = I18n.tr("Network Interface");
    private static final String LABEL = I18n.tr("You can tell FrostWire to bind outgoing connections to an IP address from a specific network interface. Listening sockets will still listen on all available interfaces. This is useful on multi-homed hosts. If you later disable this interface, FrostWire will revert to binding to an arbitrary address.");
    private static final String ADDRESS_KEY = "frostwire.networkinterfacepane.address";
    private final ButtonGroup GROUP = new ButtonGroup();
    private final JCheckBox CUSTOM;
    private final List<JRadioButton> activeButtons = new ArrayList<JRadioButton>();

    public NetworkInterfacePaneItem() {
        super(TITLE, LABEL);
        this.CUSTOM = new JCheckBox(I18n.tr("Use a specific network interface."));
        this.CUSTOM.setSelected(ConnectionSettings.USE_CUSTOM_NETWORK_INTERFACE.getValue());
        this.CUSTOM.addItemListener(e -> this.updateButtons(this.CUSTOM.isSelected()));
        this.add(this.CUSTOM);
        try {
            List<EnumNet.IpInterface> ipInterfaces = EnumNet.enumInterfaces(BTEngine.getInstance());
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.gridwidth = 0;
            for (EnumNet.IpInterface ni : ipInterfaces) {
                JLabel label = new JLabel(ni.friendlyName());
                gbc.insets = new Insets(5, 0, 2, 0);
                panel.add((Component)label, gbc);
                gbc.insets = new Insets(0, 6, 0, 0);
                Address address2 = ni.interfaceAddress();
                JRadioButton button = new JRadioButton(address2.toString());
                if (address2.isLoopback() || address2.isMulticast() || address2.isUnspecified() || NetworkUtils.isLinkLocal(address2)) continue;
                this.activeButtons.add(button);
                button.setSelected(ConnectionSettings.CUSTOM_INETADRESS_NO_PORT.getValue().equals(address2.toString()));
                button.putClientProperty(ADDRESS_KEY, address2);
                this.GROUP.add(button);
                panel.add((Component)button, gbc);
            }
            this.initializeSelection();
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.gridheight = 0;
            panel.add(Box.createGlue(), gbc);
            JScrollPane pane = new JScrollPane(panel);
            pane.setBorder(BorderFactory.createEmptyBorder());
            this.add(pane);
            this.updateButtons(this.CUSTOM.isSelected());
        }
        catch (Throwable se) {
            this.CUSTOM.setSelected(false);
            BoxPanel labelPanel = new BoxPanel(0);
            labelPanel.add(new JLabel(I18n.tr("FrostWire was unable to determine which network interfaces are available on this machine. Outgoing connections will bind to any arbitrary interface.")));
            labelPanel.add(Box.createHorizontalGlue());
            BoxPanel outerPanel = new BoxPanel();
            outerPanel.add(labelPanel);
            outerPanel.add(Box.createVerticalGlue());
            this.add(outerPanel);
        }
    }

    private void updateButtons(boolean enable) {
        for (JRadioButton button : this.activeButtons) {
            button.setEnabled(enable);
        }
    }

    private void initializeSelection() {
        AbstractButton bt;
        Enumeration<AbstractButton> buttons = this.GROUP.getElements();
        while (buttons.hasMoreElements()) {
            bt = buttons.nextElement();
            if (!bt.isSelected()) continue;
            return;
        }
        buttons = this.GROUP.getElements();
        while (buttons.hasMoreElements()) {
            bt = buttons.nextElement();
            if (!bt.isEnabled()) continue;
            bt.setSelected(true);
            return;
        }
    }

    @Override
    public boolean applyOptions() {
        boolean isDirty = this.isDirty();
        if (!isDirty) {
            return false;
        }
        ConnectionSettings.USE_CUSTOM_NETWORK_INTERFACE.setValue(this.CUSTOM.isSelected());
        Enumeration<AbstractButton> buttons = this.GROUP.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton bt = buttons.nextElement();
            if (!bt.isSelected() || !this.CUSTOM.isSelected()) continue;
            Address addr = (Address)bt.getClientProperty(ADDRESS_KEY);
            ConnectionSettings.CUSTOM_INETADRESS_NO_PORT.setValue(addr.toString());
        }
        int randomPortInRange = NetworkUtils.getPortInRange(ConnectionSettings.MANUAL_PORT_RANGE.getValue(), ConnectionSettings.PORT_RANGE_0.getDefaultValue(), ConnectionSettings.PORT_RANGE_1.getDefaultValue(), ConnectionSettings.PORT_RANGE_0.getValue(), ConnectionSettings.PORT_RANGE_1.getValue());
        String iface = NetworkUtils.getLibtorrentFormattedNetworkInterface(ConnectionSettings.USE_CUSTOM_NETWORK_INTERFACE.getValue(), "0.0.0.0", ConnectionSettings.CUSTOM_INETADRESS_NO_PORT.getValue(), randomPortInRange);
        BTEngine.getInstance().listenInterfaces(iface);
        return true;
    }

    @Override
    public boolean isDirty() {
        if (ConnectionSettings.USE_CUSTOM_NETWORK_INTERFACE.getValue() != this.CUSTOM.isSelected()) {
            return true;
        }
        String expect = ConnectionSettings.CUSTOM_INETADRESS_NO_PORT.getValue();
        Enumeration<AbstractButton> buttons = this.GROUP.getElements();
        while (buttons.hasMoreElements()) {
            Address addr;
            AbstractButton bt = buttons.nextElement();
            if (!bt.isSelected() || !(addr = (Address)bt.getClientProperty(ADDRESS_KEY)).toString().equals(expect)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void initOptions() {
    }
}

