/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.URLHandlerSettings;
import javax.swing.JTextField;

public class ImageViewerPaneItem
extends AbstractPaneItem {
    private static final String TITLE = I18n.tr("Image Options");
    private static final String LABEL = I18n.tr("You can choose which image viewer to use.");
    private final JTextField _viewerField = new SizedTextField(25, GUIUtils.SizePolicy.RESTRICT_HEIGHT);

    public ImageViewerPaneItem() {
        super(TITLE, LABEL);
        String OPTION_LABEL = I18n.tr("Image Viewer");
        LabeledComponent comp = new LabeledComponent(OPTION_LABEL, this._viewerField);
        this.add(comp.getComponent());
    }

    @Override
    public boolean applyOptions() {
        URLHandlerSettings.IMAGE_VIEWER.setValue(this._viewerField.getText());
        return false;
    }

    @Override
    public boolean isDirty() {
        return !URLHandlerSettings.IMAGE_VIEWER.getValue().equals(this._viewerField.getText());
    }

    @Override
    public void initOptions() {
        this._viewerField.setText(URLHandlerSettings.IMAGE_VIEWER.getValue());
    }
}

