/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.URLHandlerSettings;
import javax.swing.JTextField;

public class AudioPlayerPaneItem
extends AbstractPaneItem {
    private static final String TITLE = I18n.tr("Audio Options");
    private static final String LABEL = I18n.tr("You can choose which audio player to use.");
    private final JTextField _playerField = new SizedTextField(25, GUIUtils.SizePolicy.RESTRICT_HEIGHT);

    public AudioPlayerPaneItem() {
        super(TITLE, LABEL);
        String OPTION_LABEL = I18n.tr("Audio Player");
        LabeledComponent comp = new LabeledComponent(OPTION_LABEL, this._playerField);
        this.add(comp.getComponent());
    }

    @Override
    public boolean applyOptions() {
        URLHandlerSettings.AUDIO_PLAYER.setValue(this._playerField.getText());
        return false;
    }

    @Override
    public boolean isDirty() {
        return !URLHandlerSettings.AUDIO_PLAYER.getValue().equals(this._playerField.getText());
    }

    @Override
    public void initOptions() {
        this._playerField.setText(URLHandlerSettings.AUDIO_PLAYER.getValue());
    }
}

