/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.TipOfTheDayMediator;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.actions.OpenLinkAction;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.settings.UISettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;

final class HelpMenu
extends AbstractMenu {
    private final ShowSendFeedbackDialogAction showSendFeedbackDialogAction;

    HelpMenu() {
        super(I18n.tr("&Help"));
        this.addMenuItem(new OpenLinkAction("https://www.youtube.com/watch?v=A0p_DpOjpO8", I18n.tr("How to use FrostWire (Video)"), I18n.tr("How to use FrostWire (Video)")));
        if (!OSUtils.isWindowsAppStoreInstall()) {
            this.addMenuItem(new OpenLinkAction("https://www.frostwire.com/android", I18n.tr("FrostWire for Android"), I18n.tr("Get FrostWire on your Android phone, tablet or google tv, all free.")));
        }
        this.addMenuItem(new OpenLinkAction("https://www.quora.com/What-is-seeding-on-FrostWire", I18n.tr("What is \"Seeding\"?"), I18n.tr("Learn about BitTorrent Seeding")));
        this.addMenuItem(new OpenLinkAction("https://www.frostwire.com/vpn", I18n.tr("What is a VPN?"), I18n.tr("Learn about how to protect your internet connection and your privacy online")));
        this.addSeparator();
        this.addMenuItem(new OpenLinkAction("https://www.frostwire.com/give?from=desktop-help", I18n.tr("Support FrostWire"), I18n.tr("Support FrostWire")));
        JMenu cryptoCurrenciesMenu = new JMenu(I18n.tr("Support with CryptoCurrencies"));
        cryptoCurrenciesMenu.add(new OpenLinkAction("https://www.frostwire.com/bitcoin", I18n.tr("Bitcoin")));
        cryptoCurrenciesMenu.add(new OpenLinkAction("https://www.frostwire.com/bitcoin-cash", I18n.tr("Bitcoin Cash")));
        cryptoCurrenciesMenu.add(new OpenLinkAction("https://www.frostwire.com/ethereum", I18n.tr("Ethereum")));
        cryptoCurrenciesMenu.add(new OpenLinkAction("https://www.frostwire.com/dash", I18n.tr("Dash")));
        cryptoCurrenciesMenu.add(new OpenLinkAction("https://www.frostwire.com/litecoin", I18n.tr("LiteCoin")));
        cryptoCurrenciesMenu.add(new OpenLinkAction("https://www.frostwire.com/zcash", I18n.tr("ZCash")));
        this.getMenu().add(cryptoCurrenciesMenu);
        this.addMenuItem(new OpenLinkAction("http://www.frostclick.com/wp/?from=frostwire" + FrostWireUtils.getFrostWireVersion(), "FrostClick.com", I18n.tr("Free Legal Downloads")));
        this.addSeparator();
        this.addMenuItem(new OpenLinkAction("https://www.frostwire.com/chat", I18n.tr("Discord Chat"), I18n.tr("Talk to other users, get help and help others, talk to developers")));
        this.addMenuItem(new OpenLinkAction("https://reddit.com/r/frostwire", I18n.tr("Reddit"), I18n.tr("Access the FrostWire Subreddit")));
        this.addMenuItem(new OpenLinkAction("https://twitter.com/frostwire", I18n.tr("Follow us on Twitter"), I18n.tr("Follow us on Twitter")));
        this.addMenuItem(new OpenLinkAction("https://www.facebook.com/pages/FrostWire/110265295669948", I18n.tr("Follow us on Facebook"), I18n.tr("Come and say hi to the community on Facebook")));
        this.addMenuItem(new OpenLinkAction("https://instagram.com/frostwire", I18n.tr("Follow us on Instagram"), I18n.tr("Follow us on Instagram")));
        this.addSeparator();
        this.addMenuItem(new OpenLinkAction("https://frostwire.wordpress.com/2012/02/14/dont-get-scammed-frostwire-is-free/", I18n.tr("&Did you pay for FrostWire?"), I18n.tr("Did you pay for FrostWire? FrostWire is Free as in Free Beer. Avoid Scams.")));
        this.addMenuItem(new ShowTipOfTheDayAction());
        if (!OSUtils.isMacOSX()) {
            this.addSeparator();
            this.addMenuItem(new ShowAboutDialogAction());
        }
        this.showSendFeedbackDialogAction = new ShowSendFeedbackDialogAction();
        this.addMenuItem(this.showSendFeedbackDialogAction);
    }

    @Override
    protected void refresh() {
        this.showSendFeedbackDialogAction.refresh();
    }

    private static class ShowTipOfTheDayAction
    extends AbstractAction {
        private static final long serialVersionUID = -4964160055694967725L;

        ShowTipOfTheDayAction() {
            super(I18n.tr("Tip of the &Day"));
            this.putValue("LongDescription", I18n.tr("Show the Tip of the Day Window"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TipOfTheDayMediator.instance().displayTipWindow();
        }
    }

    private static class ShowAboutDialogAction
    extends AbstractAction {
        private static final long serialVersionUID = 2425666944873627828L;

        ShowAboutDialogAction() {
            super(I18n.tr("&About FrostWire"));
            this.putValue("LongDescription", I18n.tr("Information about FrostWire"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIMediator.showAboutWindow();
        }
    }

    private static class ShowSendFeedbackDialogAction
    extends AbstractAction {
        private final String SEND_FEEDBACK_STRING = I18n.tr("Send Feedback");

        ShowSendFeedbackDialogAction() {
            super(I18n.tr("Send Feedback"));
            this.putValue("LongDescription", I18n.tr("Show Send Feedback Window"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIMediator.showSendFeedbackDialog();
        }

        void refresh() {
            int FIVE_MINUTES_IN_MILLISECONDS;
            long lastFeedbackSentTimestamp = UISettings.LAST_FEEDBACK_SENT_TIMESTAMP.getValue();
            if (lastFeedbackSentTimestamp == 0L) {
                return;
            }
            long elapsedTime = System.currentTimeMillis() - lastFeedbackSentTimestamp;
            this.setEnabled(elapsedTime > (long)(FIVE_MINUTES_IN_MILLISECONDS = 300000));
            if (!this.isEnabled()) {
                int minutes;
                int seconds;
                long timeLeft = (long)FIVE_MINUTES_IN_MILLISECONDS - elapsedTime;
                String timeToWait = timeLeft < 60000L ? seconds + " " + ((seconds = (int)timeLeft / 1000) > 1 ? I18n.tr("seconds") : I18n.tr("second")) : minutes + " " + ((minutes = (int)timeLeft / 60000) > 1 ? I18n.tr("minutes") : I18n.tr("minute"));
                this.putValue("Name", this.SEND_FEEDBACK_STRING + " (" + I18n.tr("Please wait") + " " + timeToWait + ")");
            } else {
                this.putValue("Name", this.SEND_FEEDBACK_STRING);
            }
        }
    }
}

