/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.concurrent.concurrent.ExecutorsHelper;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.util.Logger;
import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.iTunesImportSettings;
import com.limegroup.gnutella.settings.iTunesSettings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

public final class iTunesMediator {
    private static final Logger LOG = Logger.getLogger(iTunesMediator.class);
    private static final String JS_IMPORT_SCRIPT_NAME = "itunes_import.js";
    private static final String JS_REMOVE_PLAYLIST_SCRIPT_NAME = "itunes_remove_playlist.js";
    private static iTunesMediator INSTANCE;
    private final ExecutorService QUEUE = ExecutorsHelper.newFixedSizeThreadPool(2, "iTunesAdderThread");

    private iTunesMediator() {
        if (OSUtils.isWindows()) {
            iTunesMediator.createiTunesJavaScript(JS_IMPORT_SCRIPT_NAME);
            iTunesMediator.createiTunesJavaScript(JS_REMOVE_PLAYLIST_SCRIPT_NAME);
        }
    }

    public static synchronized iTunesMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new iTunesMediator();
        }
        return INSTANCE;
    }

    private static boolean isSupported(String extension) {
        String[] types;
        if (extension == null) {
            return false;
        }
        for (String type : types = iTunesSettings.ITUNES_SUPPORTED_FILE_TYPES.getValue()) {
            if (!extension.equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    private static String getItunesMusicAppName() {
        return OSUtils.isMacOSCatalina105OrNewer() ? "Music" : "iTunes";
    }

    private static String[] createOSAScriptCommand(String playlist, File[] files) {
        int i2;
        ArrayList<Object> command = new ArrayList<Object>();
        command.add("osascript");
        command.add("-e");
        command.add("tell application \"Finder\"");
        for (i2 = 0; i2 < files.length; ++i2) {
            File f = files[i2];
            String path = f.getAbsolutePath();
            command.add("-e");
            command.add("set hfsFile" + i2 + " to (POSIX file \"" + path + "\")");
        }
        command.add("-e");
        command.add("set thePlaylist to \"" + playlist + "\"");
        command.add("-e");
        command.add("tell application \"" + iTunesMediator.getItunesMusicAppName() + "\"");
        command.add("-e");
        command.add("launch");
        command.add("-e");
        command.add("if not (exists playlist thePlaylist) then");
        command.add("-e");
        command.add("set thisPlaylist to make new playlist");
        command.add("-e");
        command.add("set name of thisPlaylist to thePlaylist");
        command.add("-e");
        command.add("end if");
        for (i2 = 0; i2 < files.length; ++i2) {
            command.add("-e");
            command.add("add hfsFile" + i2 + " to playlist thePlaylist");
        }
        command.add("-e");
        command.add("end tell");
        command.add("-e");
        command.add("end tell");
        return command.toArray(new String[0]);
    }

    private static String[] createWSHScriptCommand(String playlist, File[] files) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("wscript");
        command.add("//B");
        command.add("//NoLogo");
        command.add(new File(CommonUtils.getUserSettingsDir(), JS_IMPORT_SCRIPT_NAME).getAbsolutePath());
        command.add(playlist);
        for (File file : files) {
            command.add(file.getAbsolutePath());
        }
        return command.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createiTunesJavaScript(String scriptName) {
        FileOutputStream out;
        BufferedInputStream is;
        block5: {
            File fileJS = new File(CommonUtils.getUserSettingsDir(), scriptName);
            if (fileJS.exists()) {
                return;
            }
            URL url = ResourceManager.getURLResource(scriptName);
            is = null;
            out = null;
            try {
                if (url == null) break block5;
                is = new BufferedInputStream(url.openStream());
                out = new FileOutputStream(fileJS);
                IOUtils.copy((InputStream)is, (OutputStream)out);
            }
            catch (IOException e) {
                try {
                    LOG.error("Error creating " + iTunesMediator.getItunesMusicAppName() + ".app javascript", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(out);
            }
        }
        IOUtils.closeQuietly(is);
        IOUtils.closeQuietly(out);
    }

    private static <T> List<T[]> splitArray(T[] items, int maxSubArraySize) {
        T[] slice;
        ArrayList<T[]> result = new ArrayList<T[]>();
        if (items == null || items.length == 0) {
            return result;
        }
        int from = 0;
        int to = 0;
        for (int slicedItems = 0; slicedItems < items.length; slicedItems += slice.length) {
            to = from + Math.min(maxSubArraySize, items.length - to);
            slice = Arrays.copyOfRange(items, from, to);
            result.add(slice);
            from = to;
        }
        return result;
    }

    private void addSongsITunes(String playlist, File file) {
        File[] files;
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!file.exists()) {
            LOG.warn("File: '" + String.valueOf(file) + "' does not exist");
            return;
        }
        if (file.isDirectory()) {
            files = FileUtils.getFilesRecursive(file, iTunesSettings.ITUNES_SUPPORTED_FILE_TYPES.getValue());
        } else if (file.isFile() && iTunesMediator.isSupported(FilenameUtils.getExtension(file.getName()))) {
            files = new File[]{file};
        } else {
            return;
        }
        if (files.length == 0) {
            return;
        }
        this.addSongsiTunes(playlist, files);
    }

    public void addSongsiTunes(String playlist, File[] files) {
        Set<File> ignorableFiles = TorrentUtil.getIgnorableFiles();
        ArrayList<File> completeFiles = new ArrayList<File>(files.length);
        for (File f : files) {
            if (ignorableFiles.contains(f) || !f.exists() || !f.isFile() || !iTunesMediator.isSupported(FilenameUtils.getExtension(f.getName()))) continue;
            completeFiles.add(f);
        }
        files = completeFiles.toArray(new File[0]);
        if (files.length == 0) {
            return;
        }
        if (OSUtils.isMacOSX()) {
            this.QUEUE.execute(new ExecOSAScriptCommand(this, playlist, files));
        } else {
            LOG.info("Will add '" + files.length + " files' to Playlist");
            this.QUEUE.execute(new ExecWSHScriptCommand(this, playlist, files));
        }
    }

    public void scanForSongs(File file) {
        this.scanForSongs(iTunesSettings.ITUNES_PLAYLIST.getValue(), file);
    }

    public void scanForSongs(File[] files) {
        if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
            for (File f : files) {
                iTunesImportSettings.IMPORT_FILES.add(f);
            }
            this.addSongsiTunes(iTunesSettings.ITUNES_PLAYLIST.getValue(), files);
        }
    }

    private void scanForSongs(String playlist, File file) {
        iTunesImportSettings.IMPORT_FILES.add(file);
        if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
            this.addSongsITunes(playlist, file);
        }
    }

    public boolean isScanned(File file) {
        return iTunesImportSettings.IMPORT_FILES.contains(file);
    }

    private void deleteFrostWirePlaylist() {
        String playlistName = iTunesSettings.ITUNES_PLAYLIST.getValue();
        try {
            if (OSUtils.isMacOSX()) {
                String[] command = new String[]{"osascript", "-e", "tell application \"" + iTunesMediator.getItunesMusicAppName() + "\"", "-e", "delete playlist \"" + playlistName + "\"", "-e", "end tell"};
                Runtime.getRuntime().exec(command);
            } else if (OSUtils.isWindows()) {
                ArrayList<String> command = new ArrayList<String>();
                command.add("wscript");
                command.add("//B");
                command.add("//NoLogo");
                command.add(new File(CommonUtils.getUserSettingsDir(), JS_REMOVE_PLAYLIST_SCRIPT_NAME).getAbsolutePath());
                command.add(playlistName);
                Runtime.getRuntime().exec(command.toArray(new String[0]));
            }
        }
        catch (IOException e) {
            LOG.error("Error executing itunes command", e);
        }
    }

    public void resetFrostWirePlaylist() {
        this.deleteFrostWirePlaylist();
        this.QUEUE.execute(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            iTunesMediator.instance().scanForSongs(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue());
        });
    }

    private class ExecOSAScriptCommand
    implements Runnable {
        private final String playlist;
        private final File[] files;

        ExecOSAScriptCommand(iTunesMediator iTunesMediator2, String playlist, File[] files) {
            this.playlist = playlist;
            this.files = files;
        }

        @Override
        public void run() {
            try {
                int MAX_SCRIPT_FILE_NUMBER_OF_ARGUMENTS = 300;
                if (this.files.length > MAX_SCRIPT_FILE_NUMBER_OF_ARGUMENTS) {
                    List<File[]> fileArrays = iTunesMediator.splitArray(this.files, MAX_SCRIPT_FILE_NUMBER_OF_ARGUMENTS);
                    for (File[] fileSubset : fileArrays) {
                        Runtime.getRuntime().exec(iTunesMediator.createOSAScriptCommand(this.playlist, fileSubset));
                    }
                } else {
                    Runtime.getRuntime().exec(iTunesMediator.createOSAScriptCommand(this.playlist, this.files));
                }
            }
            catch (Throwable e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }

    private class ExecWSHScriptCommand
    implements Runnable {
        private final String playlist;
        private final File[] files;

        ExecWSHScriptCommand(iTunesMediator iTunesMediator2, String playlist, File[] files) {
            this.playlist = playlist;
            this.files = files;
        }

        @Override
        public void run() {
            try {
                int MAX_SCRIPT_FILE_NUMBER_OF_ARGUMENTS = 100;
                if (this.files.length > MAX_SCRIPT_FILE_NUMBER_OF_ARGUMENTS) {
                    List<File[]> fileArrays = iTunesMediator.splitArray(this.files, MAX_SCRIPT_FILE_NUMBER_OF_ARGUMENTS);
                    for (File[] fileSubset : fileArrays) {
                        Runtime.getRuntime().exec(iTunesMediator.createWSHScriptCommand(this.playlist, fileSubset));
                    }
                } else {
                    Runtime.getRuntime().exec(iTunesMediator.createWSHScriptCommand(this.playlist, this.files));
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }
}

