/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.BasicDropTargetListener;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

public class TransferHandlerDropTargetListener
implements DropTargetListener {
    private final LimeTransferHandler handler;

    public TransferHandlerDropTargetListener(LimeTransferHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler must not be null");
        }
        this.handler = handler;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        BasicDropTargetListener.DropDragInfo ddi;
        DataFlavor[] flavors = e.getCurrentDataFlavors();
        if (this.handler.canImport(null, flavors, ddi = new BasicDropTargetListener.DropDragInfo(e)) && this.actionSupported(ddi.action)) {
            e.acceptDrag(ddi.action);
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        BasicDropTargetListener.DropDragInfo ddi;
        DataFlavor[] flavors = e.getCurrentDataFlavors();
        if (this.handler.canImport(null, flavors, ddi = new BasicDropTargetListener.DropDragInfo(e)) && this.actionSupported(ddi.action)) {
            e.acceptDrag(ddi.action);
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        BasicDropTargetListener.DropDropInfo ddi;
        DataFlavor[] flavors = e.getCurrentDataFlavors();
        if (this.handler.canImport(null, flavors, ddi = new BasicDropTargetListener.DropDropInfo(e)) && this.actionSupported(ddi.action)) {
            e.acceptDrop(ddi.action);
            try {
                Transferable t = e.getTransferable();
                e.dropComplete(this.handler.importData(null, t, ddi));
            }
            catch (RuntimeException re) {
                e.dropComplete(false);
            }
        } else {
            e.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        BasicDropTargetListener.DropDragInfo ddi;
        DataFlavor[] flavors = e.getCurrentDataFlavors();
        if (this.handler.canImport(null, flavors, ddi = new BasicDropTargetListener.DropDragInfo(e)) && this.actionSupported(ddi.action)) {
            e.acceptDrag(ddi.action);
        } else {
            e.rejectDrag();
        }
    }

    private boolean actionSupported(int action) {
        return (action & 0x40000003) != 0;
    }
}

