/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;

public class TorrentFilesTransferHandler
extends LimeTransferHandler {
    private static final long serialVersionUID = 5478003116391589602L;

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors, DropInfo ddi) {
        return this.canImport(c, flavors);
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return DNDUtils.contains(transferFlavors, DataFlavor.javaFileListFlavor) || DNDUtils.contains(transferFlavors, FileTransferable.URIFlavor);
    }

    @Override
    public boolean importData(JComponent c, Transferable t, DropInfo ddi) {
        return this.importData(c, t);
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        if (!this.canImport(comp, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            File[] files = DNDUtils.getFiles(t);
            if (this.areAllTorrentFiles(files)) {
                if (files.length == 1) {
                    GUIMediator.instance().openTorrentFile(files[0], true);
                } else {
                    for (File file : files) {
                        GUIMediator.instance().openTorrentFile(file, false);
                    }
                }
                return true;
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        return false;
    }

    private boolean areAllTorrentFiles(File[] files) {
        for (File file : files) {
            if (file.isFile() && file.getName().toLowerCase().endsWith(".torrent")) continue;
            return false;
        }
        return true;
    }
}

