/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.frostwire.gui.bittorrent.SendFileProgressDialog;
import com.frostwire.gui.tabs.TransfersTab;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SendFileTransferHandler
extends LimeTransferHandler {
    private static boolean handleFiles(File[] files) {
        String fileFolder = files[0].isFile() ? I18n.tr("file") : I18n.tr("folder");
        DialogOption result = GUIMediator.showYesNoMessage(I18n.tr("Do you want to send this {0} to a friend?", fileFolder) + "\n\n\"" + files[0].getName() + "\"", I18n.tr("Send files with FrostWire"), 3);
        if (result == DialogOption.YES) {
            new SendFileProgressDialog(GUIMediator.getAppFrame(), files[0]).setVisible(true);
            GUIMediator.instance().showTransfers(TransfersTab.FilterMode.ALL);
            return true;
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors, DropInfo ddi) {
        return this.canImport(c, flavors);
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return DNDUtils.containsFileFlavors(transferFlavors);
    }

    @Override
    public boolean importData(JComponent c, Transferable t, DropInfo ddi) {
        return this.importData(c, t);
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        if (!this.canImport(comp, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            File[] files = DNDUtils.getFiles(t);
            if (files.length == 1) {
                SwingUtilities.invokeLater(() -> SendFileTransferHandler.handleFiles(files));
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

