/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.bugs;

import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.LimeWireCore;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.bugs.LocalAbstractInfo;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.limewire.setting.Setting;
import org.limewire.setting.SettingsFactory;
import org.limewire.util.CommonUtils;
import org.limewire.util.VersionUtils;

public final class LocalClientInfo
extends LocalAbstractInfo {
    public LocalClientInfo(Throwable bug, String threadName, String detail, boolean fatal) {
        this._limewireVersion = FrostWireUtils.getFrostWireVersion();
        this._javaVersion = VersionUtils.getJavaVersion();
        this._javaVendor = this.prop("java.vendor");
        this._os = OSUtils.getOS();
        this._osVersion = this.prop("os.version");
        this._architecture = this.prop("os.arch");
        this._freeMemory = "" + Runtime.getRuntime().freeMemory();
        this._totalMemory = "" + Runtime.getRuntime().totalMemory();
        this._peakThreads = "" + ManagementFactory.getThreadMXBean().getPeakThreadCount();
        this._loadAverage = LocalClientInfo.getLoadAvg();
        this._heapUsage = String.valueOf(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage());
        this._nonHeapUsage = String.valueOf(ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage());
        this._settingsFreeSpace = LocalClientInfo.getFreeSpace(CommonUtils.getUserSettingsDir());
        this._incompleteFreeSpace = "";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        bug.printStackTrace(pw);
        pw.flush();
        this._bug = sw.toString();
        this._currentThread = threadName;
        this._bugName = bug.getClass().getName();
        this._fatalError = "" + fatal;
        sw = new StringWriter();
        pw = new PrintWriter(sw);
        Properties props = new Properties();
        SettingsFactory sf = LimeProps.instance().getFactory();
        for (Setting set : sf) {
            if (set.isPrivate() || set.isDefault()) continue;
            props.put(set.getKey(), set.getValueAsString());
        }
        props.list(pw);
        pw.flush();
        this._props = sw.toString();
        if (GUIMediator.isConstructed() && LimeWireCore.instance() != null) {
            LimeWireCore.instance().getLifecycleManager().isLoaded();
        }
        this._detail = detail;
        Thread[] allThreads = new Thread[Thread.activeCount()];
        int copied = Thread.enumerate(allThreads);
        this._threadCount = "" + copied;
        HashMap<String, Integer> threads = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < copied; ++i2) {
            String name = allThreads[i2].getName();
            Integer val = (Integer)threads.get(name);
            if (val == null) {
                threads.put(name, 1);
                continue;
            }
            int num = val + 1;
            threads.put(name, num);
        }
        sw = new StringWriter();
        pw = new PrintWriter(sw);
        for (Map.Entry info : threads.entrySet()) {
            pw.println((String)info.getKey() + ": " + String.valueOf(info.getValue()));
        }
        pw.flush();
        this._otherThreads = sw.toString();
    }

    private static String getFreeSpace(File f) {
        return LocalClientInfo.invoke16Method(f, File.class, "getUsableSpace", Long.class);
    }

    private static String getLoadAvg() {
        return LocalClientInfo.invoke16Method(ManagementFactory.getOperatingSystemMXBean(), OperatingSystemMXBean.class, "getSystemLoadAverage", Double.class);
    }

    private static String invoke16Method(Object obj, Class<?> type, String method, Class<?> retType) {
        if (!VersionUtils.isJava16OrAbove()) {
            return "-1";
        }
        try {
            Method m = type.getMethod(method, new Class[0]);
            Object ret = m.invoke(obj, new Object[0]);
            if (ret == null) {
                return "-7";
            }
            if (!retType.isAssignableFrom(ret.getClass())) {
                return "-5";
            }
            return ret.toString();
        }
        catch (NoSuchMethodException bail) {
            return "-2";
        }
        catch (IllegalAccessException bail) {
            return "-3";
        }
        catch (InvocationTargetException bail) {
            return "-4";
        }
        catch (Throwable bad) {
            return "-6";
        }
    }

    private String prop(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            return "?";
        }
        return value;
    }
}

