/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.bugs;

import com.limegroup.gnutella.util.FrostWireUtils;
import java.io.PrintWriter;
import java.io.StringWriter;

abstract class LocalAbstractInfo {
    protected static final String OS = "3";
    String _limewireVersion;
    String _javaVersion;
    String _os;
    String _osVersion;
    String _architecture;
    String _freeMemory;
    String _totalMemory;
    String _bug;
    String _currentThread;
    String _props;
    String _otherThreads;
    String _detail;
    String _javaVendor;
    String _threadCount;
    String _bugName;
    String _fatalError;
    String _peakThreads;
    String _loadAverage;
    String _settingsFreeSpace;
    String _incompleteFreeSpace;
    String _heapUsage;
    String _nonHeapUsage;
    private String _userComments;

    LocalAbstractInfo() {
    }

    void addUserComments(String comments) {
        this._userComments = comments;
    }

    public SystemInfoWriters getBasicSystemInfo() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        SystemInfoWriters result = new SystemInfoWriters(sw, pw);
        result.pw.println("FrostWire version " + this._limewireVersion + " build " + FrostWireUtils.getBuildNumber());
        result.pw.println("Java version " + this._javaVersion + " from " + this._javaVendor);
        result.pw.println(this._os + " v. " + this._osVersion + " on " + this._architecture);
        result.pw.println("Free/total memory: " + this._freeMemory + "/" + this._totalMemory);
        result.pw.println();
        return result;
    }

    public String toBugReport() {
        SystemInfoWriters siw = this.getBasicSystemInfo();
        StringWriter sw = siw.sw;
        PrintWriter pw = siw.pw;
        if (this.isFatalError()) {
            pw.println("FATAL ERROR!");
            pw.println();
        }
        pw.println(this._bug);
        pw.println();
        if (this._detail != null) {
            pw.println("Detail: " + this._detail);
            pw.println();
        }
        pw.println("-- class path --");
        pw.println(System.getProperty("java.class.path").replaceAll("\\;|\\:", "\n"));
        pw.println("-- listing session information --");
        pw.println("Current thread: " + this._currentThread);
        pw.println("Active Threads: " + this._threadCount);
        this.append(pw, "Peak Number of Thread", this._peakThreads);
        this.append(pw, "System Load Avg", this._loadAverage);
        this.append(pw, "Free Space In Settings", this._settingsFreeSpace);
        this.append(pw, "Free Space In Incomplete", this._incompleteFreeSpace);
        this.append(pw, "Heap Memory Usage", this._heapUsage);
        this.append(pw, "Non-Heap Memory Usage", this._nonHeapUsage);
        pw.println();
        if (this._otherThreads != null) {
            pw.println("-- listing threads --");
            pw.println(this._otherThreads);
            pw.println();
        }
        pw.println(this._props);
        pw.println();
        pw.println("**************** Comments from the user ****************\n" + this._userComments);
        pw.flush();
        System.out.println(sw.toString());
        return sw.toString();
    }

    private void append(PrintWriter pw, String k, String v) {
        if (v != null) {
            pw.println(k + ": " + v);
        }
    }

    public String toString() {
        return this._bugName;
    }

    private boolean isFatalError() {
        return this._fatalError != null && this._fatalError.equalsIgnoreCase("true");
    }

    public static final class SystemInfoWriters {
        public final StringWriter sw;
        final PrintWriter pw;

        SystemInfoWriters(StringWriter sWriter, PrintWriter pWriter) {
            this.sw = sWriter;
            this.pw = pWriter;
        }
    }
}

