/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.bugs;

import com.frostwire.concurrent.concurrent.ExecutorsHelper;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.Logger;
import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LimeWireModule;
import com.limegroup.gnutella.gui.LocalClientInfoFactory;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.bugs.LocalClientInfo;
import com.limegroup.gnutella.settings.BugSettings;
import com.limegroup.gnutella.settings.UISettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.EnumMap;
import java.util.concurrent.ExecutorService;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.StringUtils;

public final class BugManager {
    private static final Logger LOG = Logger.getLogger(BugManager.class);
    private static final int DIALOG_BOX_WIDTH = 300;
    private static final int DIALOG_BOX_HEIGHT = 100;
    private static final EnumMap<ErrorType, EnumMap<DetailErrorType, String>> errorDescs = new EnumMap(ErrorType.class);
    private static BugManager INSTANCE;
    private final LocalClientInfoFactory localClientInfoFactory;
    private final String TITLE = I18n.tr("Internal Error");
    private final ExecutorService BUGS_QUEUE = ExecutorsHelper.newProcessingQueue(r -> {
        Thread t = new Thread(r, "BugProcessor");
        t.setDaemon(true);
        return t;
    });
    private final Object WRITE_LOCK = new Object();
    private final byte[] SEPARATOR = "-----------------\n".getBytes();
    private volatile long _nextAllowedTime = 0L;
    private int _dialogsShowing = 0;

    private BugManager() {
        this.localClientInfoFactory = LimeWireModule.instance().getLimeWireGUIModule().getLimeWireGUI().getLocalClientInfoFactory();
    }

    public static synchronized BugManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new BugManager();
        }
        return INSTANCE;
    }

    private static String warning() {
        return "You are using FrostWire. www.frostwire.com";
    }

    private static boolean handleException(IOException ioe) {
        for (Throwable e = ioe; e != null; e = e.getCause()) {
            String msg = e.getMessage();
            if (msg == null) continue;
            msg = msg.toLowerCase();
            DetailErrorType detailType = null;
            if (StringUtils.contains(msg, "no space left") || StringUtils.contains(msg, "not enough space")) {
                detailType = DetailErrorType.DISK_FULL;
            } else if (StringUtils.contains(msg, "being used by another process") || StringUtils.contains(msg, "with a user-mapped section open")) {
                detailType = DetailErrorType.FILE_LOCKED;
            } else if (StringUtils.contains(msg, "access is denied") || StringUtils.contains(msg, "permission denied")) {
                detailType = DetailErrorType.NO_PRIVS;
            } else if (StringUtils.contains(msg, "invalid argument")) {
                detailType = DetailErrorType.BAD_CHARS;
            }
            if (detailType == null) continue;
            MessageService.instance().showError(errorDescs.get((Object)ErrorType.GENERIC).get((Object)detailType));
            return true;
        }
        return false;
    }

    public void handleBug(Throwable bug, String threadName, String detail) {
        String[] classpaths;
        if (bug instanceof IOException && BugManager.handleException((IOException)bug)) {
            return;
        }
        StringBuilder classPath = new StringBuilder();
        String classPathSeparator = OSUtils.isWindows() ? ";" : ":";
        for (String classpath : classpaths = System.getProperty("java.class.path").split(classPathSeparator)) {
            classPath.append("  ").append(classpath).append("\n");
        }
        detail = (String)detail + "\nCLASSPATH:\n" + String.valueOf(classPath) + "\nEXPERIMENTAL FEATURES SETTINGS:\n    ALPHA FEATURES: " + UISettings.ALPHA_FEATURES_ENABLED.getValue() + "\n    BETA FEATURES: " + UISettings.BETA_FEATURES_ENABLED.getValue() + "\n";
        bug.printStackTrace();
        LocalClientInfo info = this.localClientInfoFactory.createLocalClientInfo(bug, threadName, (String)detail, false);
        if (BugSettings.LOG_BUGS_LOCALLY.getValue()) {
            this.logBugToDisk(info);
        }
        if (BugSettings.IGNORE_ALL_BUGS.getValue()) {
            return;
        }
        if (BugSettings.USE_AUTOMATIC_BUG.getValue()) {
            this.sendToServlet(info);
            return;
        }
        int MAX_DIALOGS = 3;
        if (!BugSettings.USE_AUTOMATIC_BUG.getValue() && this._dialogsShowing < MAX_DIALOGS) {
            GUIMediator.safeInvokeLater(() -> this.reviewBug(info));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void logBugToDisk(LocalClientInfo info) {
        File f = BugSettings.BUG_LOG_FILE.getValue();
        FileUtils.setWriteable(f);
        BufferedOutputStream os = null;
        try {
            Object object = this.WRITE_LOCK;
            synchronized (object) {
                if (f.length() > (long)BugSettings.MAX_BUGFILE_SIZE.getValue()) {
                    f.delete();
                }
                os = new BufferedOutputStream(new FileOutputStream(f.getPath(), true));
                ((OutputStream)os).write((String.valueOf(new Date()) + "\n").getBytes());
                ((OutputStream)os).write(info.toBugReport().getBytes());
                ((OutputStream)os).write(this.SEPARATOR);
                ((OutputStream)os).flush();
            }
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(os);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(os);
    }

    private void reviewBug(LocalClientInfo info) {
        ++this._dialogsShowing;
        JDialog DIALOG = new JDialog(GUIMediator.getAppFrame(), this.TITLE, true);
        Dimension DIALOG_DIMENSION = new Dimension(300, 100);
        DIALOG.setSize(DIALOG_DIMENSION);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new GridBagLayout());
        String msg = BugManager.warning() + "\n\n" + I18n.tr("FrostWire has encountered an internal error. It is possible for FrostWire to recover and continue running normally. To aid with debugging, please click 'Send' to notify FrostWire about the problem. If desired, you can click 'Review' to look at the information that will be sent. Thank you.");
        MultiLineLabel label = new MultiLineLabel(msg, 400);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        labelPanel.add((Component)label, constraints);
        final JTextArea userCommentsTextArea = new JTextArea(I18n.tr("Please add any comments you may have (e.g what caused the error).\nThank you and please use English."));
        userCommentsTextArea.setLineWrap(true);
        userCommentsTextArea.setWrapStyleWord(true);
        userCommentsTextArea.addFocusListener(new FocusAdapter(this){

            @Override
            public void focusGained(FocusEvent e) {
                userCommentsTextArea.selectAll();
            }
        });
        JScrollPane userCommentsScrollPane = new JScrollPane(userCommentsTextArea);
        userCommentsScrollPane.setBorder(BorderFactory.createEtchedBorder());
        userCommentsScrollPane.setPreferredSize(new Dimension(400, 80));
        JPanel buttonPanel = new JPanel();
        JButton sendButton = new JButton(I18n.tr("Send"));
        sendButton.addActionListener(e -> {
            info.addUserComments(userCommentsTextArea.getText());
            this.sendToServlet(info);
            DIALOG.dispose();
            --this._dialogsShowing;
        });
        JButton reviewButton = new JButton(I18n.tr("Review"));
        reviewButton.addActionListener(e -> {
            info.addUserComments(userCommentsTextArea.getText());
            JTextArea textArea = new JTextArea(info.toBugReport());
            textArea.setColumns(50);
            textArea.setEditable(false);
            textArea.setCaretPosition(0);
            JScrollPane scroller = new JScrollPane(textArea);
            scroller.setBorder(BorderFactory.createEtchedBorder());
            scroller.setPreferredSize(new Dimension(500, 200));
            MessageService.instance().showMessage(scroller);
        });
        JButton discardButton = new JButton(I18n.tr("Discard"));
        discardButton.addActionListener(e -> {
            DIALOG.dispose();
            --this._dialogsShowing;
        });
        buttonPanel.add(sendButton);
        buttonPanel.add(reviewButton);
        buttonPanel.add(discardButton);
        JPanel optionsPanel = new JPanel();
        JPanel innerPanel = new JPanel();
        ButtonGroup bg = new ButtonGroup();
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        optionsPanel.setLayout(new BorderLayout());
        JRadioButton alwaysSend = new JRadioButton(I18n.tr("Always Send Immediately"));
        JRadioButton alwaysReview = new JRadioButton(I18n.tr("Always Ask For Review"));
        JRadioButton alwaysDiscard = new JRadioButton(I18n.tr("Always Discard All Errors"));
        innerPanel.add(Box.createVerticalStrut(6));
        innerPanel.add(alwaysSend);
        innerPanel.add(alwaysReview);
        innerPanel.add(alwaysDiscard);
        innerPanel.add(Box.createVerticalStrut(6));
        optionsPanel.add((Component)innerPanel, "West");
        bg.add(alwaysSend);
        bg.add(alwaysReview);
        bg.add(alwaysDiscard);
        bg.setSelected(alwaysReview.getModel(), true);
        ActionListener alwaysListener = e -> {
            if (e.getSource() == alwaysSend) {
                BugSettings.IGNORE_ALL_BUGS.setValue(false);
                BugSettings.USE_AUTOMATIC_BUG.setValue(true);
            } else if (e.getSource() == alwaysReview) {
                BugSettings.IGNORE_ALL_BUGS.setValue(false);
                BugSettings.USE_AUTOMATIC_BUG.setValue(false);
            } else if (e.getSource() == alwaysDiscard) {
                BugSettings.IGNORE_ALL_BUGS.setValue(true);
            }
        };
        alwaysSend.addActionListener(alwaysListener);
        alwaysReview.addActionListener(alwaysListener);
        alwaysDiscard.addActionListener(alwaysListener);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        mainPanel.add((Component)labelPanel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(20, 0, 6, 0);
        mainPanel.add((Component)userCommentsScrollPane, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        mainPanel.add((Component)optionsPanel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        mainPanel.add((Component)buttonPanel, constraints);
        DIALOG.getContentPane().add(mainPanel);
        DIALOG.pack();
        this.centerDialog(DIALOG);
        try {
            DIALOG.setVisible(true);
        }
        catch (ArrayIndexOutOfBoundsException | InternalError throwable) {
            // empty catch block
        }
    }

    private void centerDialog(JDialog dlg) {
        if (GUIMediator.isAppVisible()) {
            dlg.setLocationRelativeTo(MessageService.getParentComponent());
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dialogSize = dlg.getSize();
            dlg.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        }
    }

    private void servletSendFailed(LocalClientInfo info) {
        ++this._dialogsShowing;
        JDialog DIALOG = new JDialog(GUIMediator.getAppFrame(), this.TITLE, true);
        Dimension DIALOG_DIMENSION = new Dimension(350, 300);
        Dimension ERROR_DIMENSION = new Dimension(300, 200);
        DIALOG.setSize(DIALOG_DIMENSION);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        MultiLineLabel label = new MultiLineLabel(I18n.tr("FrostWire was unable to connect to the bug server in order to send the below bug report. For further help and to aid with debugging, please visit www.frostwire.com and click 'Support'. Thank you."), 400);
        JPanel labelPanel = new JPanel();
        JPanel innerPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        innerPanel.add(label);
        innerPanel.add(Box.createVerticalStrut(6));
        labelPanel.add(innerPanel);
        labelPanel.add(Box.createHorizontalGlue());
        String bugInfo = info.toBugReport().trim() + "\n\nFILES IN CURRENT DIRECTORY NOT LISTED.\nSIZE: 0";
        JTextArea textArea = new JTextArea(bugInfo);
        textArea.selectAll();
        textArea.copy();
        textArea.setColumns(50);
        textArea.setEditable(false);
        JScrollPane scroller = new JScrollPane(textArea);
        scroller.setBorder(BorderFactory.createEtchedBorder());
        scroller.setPreferredSize(ERROR_DIMENSION);
        JPanel buttonPanel = new JPanel();
        JButton copyButton = new JButton(I18n.tr("Copy Report"));
        copyButton.addActionListener(e -> {
            textArea.selectAll();
            textArea.copy();
            textArea.setCaretPosition(0);
        });
        JButton quitButton = new JButton(I18n.tr("OK"));
        quitButton.addActionListener(e -> {
            DIALOG.dispose();
            --this._dialogsShowing;
        });
        buttonPanel.add(copyButton);
        buttonPanel.add(quitButton);
        mainPanel.add(labelPanel);
        mainPanel.add(scroller);
        mainPanel.add(buttonPanel);
        DIALOG.getContentPane().add(mainPanel);
        try {
            DIALOG.pack();
        }
        catch (OutOfMemoryError oome) {
            return;
        }
        this.centerDialog(DIALOG);
        DIALOG.setVisible(true);
    }

    private void sendToServlet(LocalClientInfo info) {
        this.BUGS_QUEUE.execute(new ServletSender(info));
    }

    static {
        for (ErrorType type : ErrorType.values()) {
            errorDescs.put(type, new EnumMap(DetailErrorType.class));
        }
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.DISK_FULL, I18n.tr("FrostWire was unable to write a necessary file because your hard drive is full. To continue using FrostWire you must free up space on your hard drive."));
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.FILE_LOCKED, I18n.tr("FrostWire was unable to open a necessary file because another program has locked the file. FrostWire may act unexpectedly until this file is released."));
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.NO_PRIVS, I18n.tr("FrostWire was unable to write a necessary file because you do not have the necessary permissions. Your preferences may not be maintained the next time you start FrostWire, or FrostWire may behave in unexpected ways."));
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.BAD_CHARS, I18n.tr("FrostWire cannot open a necessary file because the filename contains characters which are not supported by your operating system. FrostWire may behave in unexpected ways."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.DISK_FULL, I18n.tr("FrostWire cannot download the selected file because your hard drive is full. To download more files, you must free up space on your hard drive."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.FILE_LOCKED, I18n.tr("FrostWire was unable to download the selected file because another program is using the file. Please close the other program and retry the download."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.NO_PRIVS, I18n.tr("FrostWire was unable to create or continue writing an incomplete file for the selected download because you do not have permission to write files to the incomplete folder. To continue using FrostWire, please choose a different Save Folder."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.BAD_CHARS, I18n.tr("FrostWire was unable to open the incomplete file for the selected download because the filename contains characters which are not supported by your operating system."));
        for (ErrorType type : ErrorType.values()) {
            assert (errorDescs.get((Object)type) != null);
            assert (errorDescs.get((Object)type).size() == DetailErrorType.values().length);
        }
    }

    private static enum DetailErrorType {
        DISK_FULL,
        FILE_LOCKED,
        NO_PRIVS,
        BAD_CHARS;

    }

    public static enum ErrorType {
        GENERIC,
        DOWNLOAD;

    }

    private class ServletSender
    implements Runnable {
        final LocalClientInfo INFO;

        ServletSender(LocalClientInfo info) {
            this.INFO = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long now = System.currentTimeMillis();
            if (now < BugManager.this._nextAllowedTime) {
                LOG.info("ServletSender.run() aborted");
                return;
            }
            String response = null;
            try {
                response = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.MISC).post(BugSettings.BUG_REPORT_SERVER.getValue(), 6000, "FrostWire-" + FrostWireUtils.getFrostWireVersion(), this.INFO.toBugReport(), "text/plain", false);
            }
            catch (Exception e) {
                LOG.error("Error sending bug report", e);
            }
            if (response == null) {
                SwingUtilities.invokeLater(() -> BugManager.this.servletSendFailed(this.INFO));
                return;
            }
            Object object = BugManager.this.WRITE_LOCK;
            synchronized (object) {
                BugManager.this._nextAllowedTime = now + 30000L;
                LOG.info("ServletSender.run() success _nextAllowedTime=" + BugManager.this._nextAllowedTime);
            }
        }
    }
}

