/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.LimeTextField;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class WholeNumberField
extends LimeTextField {
    private static final long serialVersionUID = 5004162823300212516L;
    private final Toolkit toolkit = Toolkit.getDefaultToolkit();
    private final NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.US);

    WholeNumberField(int value, int columns) {
        super(columns);
        this.integerFormatter.setParseIntegerOnly(true);
        this.setValue(value);
    }

    WholeNumberField(int columns) {
        super(columns);
        this.integerFormatter.setParseIntegerOnly(true);
    }

    public int getValue() {
        int retVal = 0;
        try {
            retVal = this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException e) {
            this.toolkit.beep();
        }
        return retVal;
    }

    public void setValue(int value) {
        this.setText(this.integerFormatter.format(value));
    }

    @Override
    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        private static final long serialVersionUID = 4371239029188384061L;

        protected WholeNumberDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            char[] source2 = str.toCharArray();
            char[] result = new char[source2.length];
            int j = 0;
            for (int i2 = 0; i2 < result.length; ++i2) {
                if (Character.isDigit(source2[i2])) {
                    result[j++] = source2[i2];
                    continue;
                }
                if (source2[i2] == ',' && (result.length - i2) % 4 == 0 && result.length != i2 - 1) continue;
                WholeNumberField.this.toolkit.beep();
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

