/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.bittorrent.BTEngine;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.theme.SkinCheckBoxMenuItem;
import com.frostwire.gui.theme.SkinPopupMenu;
import com.limegroup.gnutella.gui.DonationButtons;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.LanguageButton;
import com.limegroup.gnutella.gui.StatusComponent;
import com.limegroup.gnutella.gui.VPNStatusButton;
import com.limegroup.gnutella.gui.VPNStatusRefresher;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.StatusBarSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ToolTipManager;
import org.limewire.setting.BooleanSetting;

public final class StatusLine
implements VPNStatusRefresher.VPNStatusListener {
    static final int STATUS_DISCONNECTED = 0;
    static final int STATUS_TURBOCHARGED = 1;
    private final ImageIcon[] _connectionQualityMeterIcons = new ImageIcon[7];
    private final VPNStatusRefresher vpnStatusRefresher;
    private final VPNStatusButton vpnStatusButton;
    private JPanel BAR;
    private JLabel connectionQualityMeter;
    private LanguageButton languageButton;
    private JLabel firewallStatus;
    private JLabel bandwidthUsageDown;
    private JLabel bandwidthUsageUp;
    private final MouseAdapter STATUS_BAR_LISTENER = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent me) {
            this.processMouseEvent(me);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.processMouseEvent(me);
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            this.processMouseEvent(me);
        }

        void processMouseEvent(MouseEvent me) {
            Component clickedComponent = me.getComponent();
            if (me.isPopupTrigger()) {
                SkinPopupMenu jpm = new SkinPopupMenu();
                SkinCheckBoxMenuItem jcbmi = new SkinCheckBoxMenuItem(new ShowConnectionQualityAction());
                jcbmi.setState(StatusBarSettings.CONNECTION_QUALITY_DISPLAY_ENABLED.getValue());
                jpm.add(jcbmi);
                jcbmi = new SkinCheckBoxMenuItem(new ShowVPNAction());
                jcbmi.setState(StatusBarSettings.VPN_DISPLAY_ENABLED.getValue());
                jpm.add(jcbmi);
                jcbmi = new SkinCheckBoxMenuItem(new ShowLanguageStatusAction());
                jcbmi.setState(StatusLine.this.getLanguageSetting().getValue());
                jpm.add(jcbmi);
                jcbmi = new SkinCheckBoxMenuItem(new ShowFirewallStatusAction());
                jcbmi.setState(StatusBarSettings.FIREWALL_DISPLAY_ENABLED.getValue());
                jpm.add(jcbmi);
                jcbmi = new SkinCheckBoxMenuItem(new ShowBandwidthConsumptionAction());
                jcbmi.setState(StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.getValue());
                jpm.add(jcbmi);
                jcbmi = new SkinCheckBoxMenuItem(new ShowDonationButtonsAction());
                jcbmi.setState(StatusBarSettings.DONATION_BUTTONS_DISPLAY_ENABLED.getValue());
                jpm.add(jcbmi);
                jpm.pack();
                jpm.show(clickedComponent, me.getX(), me.getY());
            } else if (clickedComponent == StatusLine.this.bandwidthUsageUp || clickedComponent == StatusLine.this.bandwidthUsageDown) {
                GUIMediator.Tabs transfersTab = GUIMediator.Tabs.TRANSFERS.isEnabled() ? GUIMediator.Tabs.TRANSFERS : GUIMediator.Tabs.SEARCH_TRANSFERS;
                GUIMediator.instance().setWindow(transfersTab);
            }
        }
    };
    private IconButton twitterButton;
    private IconButton facebookButton;
    private IconButton instagramButton;
    private IconButton seedingStatusButton;
    private IconButton discordButton;
    private DonationButtons donationButtons;
    private IconButton settingsButton;
    private StatusComponent STATUS_COMPONENT;
    private JPanel centerPanel;
    private Component centerComponent;
    private long _nextUpdateTime = System.currentTimeMillis();

    StatusLine() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Status Window..."));
        this.getComponent().addMouseListener(this.STATUS_BAR_LISTENER);
        GUIMediator.getAppFrame().addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                StatusLine.this.refresh();
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }
        });
        GUIMediator.setSplashScreenString(I18n.tr("Creating donation buttons so you can give us a hand..."));
        this.createDonationButtonsComponent();
        GUIMediator.setSplashScreenString(I18n.tr("Creating Connection Quality Indicator..."));
        this.createConnectionQualityPanel();
        this.vpnStatusButton = new VPNStatusButton();
        this.vpnStatusRefresher = VPNStatusRefresher.getInstance();
        this.vpnStatusRefresher.addRefreshListener(this.vpnStatusButton);
        this.vpnStatusRefresher.addRefreshListener(this);
        GUIMediator.setSplashScreenString(I18n.tr("Adding flags here and there..."));
        this.createLanguageButton();
        GUIMediator.setSplashScreenString(I18n.tr("Playing with pixels for the Firewall indicator..."));
        this.createFirewallLabel();
        this.createBandwidthLabel();
        GUIMediator.setSplashScreenString(I18n.tr("Learning to socialize on Facebook..."));
        this.createFacebookButton();
        GUIMediator.setSplashScreenString(I18n.tr("Learning to socialize on Twitter..."));
        this.createTwitterButton();
        this.createInstagramButton();
        this.createDiscordButton();
        this.createSettingsButton();
        GUIMediator.setSplashScreenString(I18n.tr("Painting seeding sign..."));
        this.createSeedingStatusLabel();
        GUIMediator.setSplashScreenString(I18n.tr("Creating center panel..."));
        this.createCenterPanel();
        this.setConnectionQuality(0);
        GUIMediator.addRefreshListener(() -> {
            if (StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.getValue()) {
                this.updateBandwidth();
            }
            this.updateCenterPanel();
        });
        this.refresh();
    }

    public void updateVPNDropProtectionLabelState() {
        if (this.vpnStatusButton != null) {
            this.vpnStatusButton.onStatusUpdated(this.vpnStatusButton.getLastVPNStatus());
        }
    }

    private void createDonationButtonsComponent() {
        this.donationButtons = new DonationButtons();
    }

    private void createTwitterButton() {
        this.twitterButton = new IconButton("TWITTER");
        this.initSocialButton(this.twitterButton, I18n.tr("Follow us @frostwire"), "https://twitter.com/frostwire");
    }

    private void createInstagramButton() {
        this.instagramButton = new IconButton("INSTAGRAM");
        this.initSocialButton(this.instagramButton, I18n.tr("Follow FrostWire on Instagram"), "https://instagram.com/frostwire");
        this.instagramButton.setPreferredSize(new Dimension(22, 16));
    }

    private void createFacebookButton() {
        this.facebookButton = new IconButton("FACEBOOK");
        this.initSocialButton(this.facebookButton, I18n.tr("Like FrostWire on Facebook and stay in touch with the community. Get Help and Help Others."), "https://www.facebook.com/FrostwireOfficial");
    }

    private void createDiscordButton() {
        this.discordButton = new IconButton("DISCORD");
        this.initSocialButton(this.discordButton, I18n.tr("Join the FrostWire community on Discord"), "https://www.frostwire.com/chat");
    }

    private void createSettingsButton() {
        this.settingsButton = new IconButton("SETTINGS_GEAR");
        this.settingsButton.setAction(new SettingsButtonAction());
    }

    private void initSocialButton(IconButton socialButton, String toolTipText, String url) {
        socialButton.setToolTipText(I18n.tr(toolTipText));
        socialButton.addActionListener(arg0 -> GUIMediator.openURL(url));
    }

    private void createSeedingStatusLabel() {
        this.seedingStatusButton = new IconButton("", "SEEDING", true){
            private static final long serialVersionUID = -8985154093868645203L;

            @Override
            public String getToolTipText() {
                boolean seedingStatus = SharingSettings.SEED_FINISHED_TORRENTS.getValue();
                return "<html>" + (String)(seedingStatus ? I18n.tr("<b>Seeding</b><p>completed torrent downloads.</p>") : I18n.tr("<b>Not Seeding</b><p>File chunks might be shared only during a torrent download.</p>") + "</html>");
            }
        };
        this.seedingStatusButton.addActionListener(e -> GUIMediator.instance().setOptionsVisible(true, "OPTIONS_BITTORRENT_BASIC_TITLE"));
        ToolTipManager.sharedInstance().registerComponent(this.seedingStatusButton);
    }

    public void refresh() {
        if (this.getComponent() != null) {
            this.getComponent().removeAll();
            int sepWidth = Math.max(2, this.createSeparator().getWidth());
            int remainingWidth = this.BAR.getWidth();
            if (remainingWidth <= 0) {
                remainingWidth = ApplicationSettings.APP_WIDTH.getValue();
            }
            remainingWidth -= sepWidth;
            remainingWidth -= 3;
            if (this.donationButtons != null) {
                remainingWidth -= this.donationButtons.getWidth();
                remainingWidth -= 6;
            }
            int indicatorWidth = this.centerComponent.getWidth();
            remainingWidth -= indicatorWidth;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.weightx = 0.0;
            gbc.fill = 0;
            gbc.anchor = 10;
            gbc.gridx = -1;
            if (StatusBarSettings.CONNECTION_QUALITY_DISPLAY_ENABLED.getValue()) {
                remainingWidth = this.addStatusIndicator(this.connectionQualityMeter, sepWidth, remainingWidth, gbc);
            }
            if (StatusBarSettings.VPN_DISPLAY_ENABLED.getValue()) {
                this.vpnStatusRefresher.refresh();
                remainingWidth = this.addStatusIndicator(this.vpnStatusButton, sepWidth, remainingWidth, gbc);
            }
            if (this.getLanguageSetting().getValue() && remainingWidth > indicatorWidth) {
                remainingWidth = this.addStatusIndicator(this.languageButton, sepWidth, remainingWidth, gbc);
            }
            if (StatusBarSettings.FIREWALL_DISPLAY_ENABLED.getValue()) {
                this.BAR.add(Box.createHorizontalStrut(6), gbc);
                remainingWidth = this.addStatusIndicator(this.firewallStatus, sepWidth, remainingWidth, gbc);
                this.updateFirewall();
            }
            indicatorWidth = 9 + sepWidth + Math.max((int)this.bandwidthUsageDown.getMinimumSize().getWidth(), this.bandwidthUsageDown.getWidth()) + Math.max((int)this.bandwidthUsageUp.getMinimumSize().getWidth(), this.bandwidthUsageUp.getWidth());
            if (StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.getValue() && remainingWidth > indicatorWidth) {
                this.BAR.add(Box.createHorizontalStrut(3), gbc);
                this.BAR.add((Component)this.bandwidthUsageDown, gbc);
                this.BAR.add(Box.createHorizontalStrut(6), gbc);
                this.BAR.add((Component)this.bandwidthUsageUp, gbc);
                this.BAR.add(Box.createHorizontalStrut(3), gbc);
                this.BAR.add(this.createSeparator(), gbc);
            }
            gbc = new GridBagConstraints();
            gbc.gridx = -1;
            this.BAR.add((Component)this.seedingStatusButton, gbc);
            this.BAR.add(Box.createHorizontalStrut(3), gbc);
            this.BAR.add(this.createSeparator(), gbc);
            this.updateSeedingStatus();
            this.BAR.add(Box.createHorizontalStrut(6), gbc);
            this.BAR.add((Component)this.facebookButton, gbc);
            this.BAR.add(Box.createHorizontalStrut(6), gbc);
            this.BAR.add((Component)this.twitterButton, gbc);
            this.BAR.add(Box.createHorizontalStrut(6), gbc);
            this.BAR.add((Component)this.instagramButton, gbc);
            this.BAR.add(Box.createHorizontalStrut(6), gbc);
            this.BAR.add(this.createSeparator(), gbc);
            this.BAR.add(Box.createHorizontalStrut(6), gbc);
            this.BAR.add((Component)this.discordButton, gbc);
            this.BAR.add(Box.createHorizontalStrut(6), gbc);
            gbc.weightx = 1.0;
            this.BAR.add((Component)this.centerPanel, gbc);
            gbc.weightx = 0.0;
            this.BAR.add(Box.createHorizontalStrut(3), gbc);
            if (this.donationButtons != null && StatusBarSettings.DONATION_BUTTONS_DISPLAY_ENABLED.getValue()) {
                this.BAR.add(Box.createHorizontalStrut(3), gbc);
                this.BAR.add((Component)this.donationButtons, gbc);
                this.BAR.add(Box.createHorizontalStrut(10));
                this.BAR.add(Box.createHorizontalStrut(6), gbc);
            }
            this.BAR.add(this.createSeparator(), gbc);
            this.BAR.add(this.settingsButton);
            try {
                this.BAR.validate();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.BAR.repaint();
        }
    }

    private int addStatusIndicator(JComponent component, int sepWidth, int remainingWidth, GridBagConstraints gbc) {
        int indicatorWidth = 6 + Math.max((int)component.getMinimumSize().getWidth(), component.getWidth()) + sepWidth;
        if (remainingWidth > indicatorWidth) {
            this.BAR.add(Box.createHorizontalStrut(3), gbc);
            this.BAR.add((Component)component, gbc);
            this.BAR.add(Box.createHorizontalStrut(3), gbc);
            this.BAR.add(this.createSeparator(), gbc);
            remainingWidth -= indicatorWidth;
        }
        return remainingWidth;
    }

    private Component createSeparator() {
        JSeparator sep = new JSeparator(1);
        sep.setPreferredSize(new Dimension(2, 30));
        sep.setMinimumSize(new Dimension(2, 30));
        return sep;
    }

    private void createConnectionQualityPanel() {
        this.updateTheme();
        this.connectionQualityMeter = new JLabel();
        this.connectionQualityMeter.setOpaque(false);
        this.connectionQualityMeter.setMinimumSize(new Dimension(34, 20));
        this.connectionQualityMeter.setMaximumSize(new Dimension(90, 30));
        this.connectionQualityMeter.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void createLanguageButton() {
        this.languageButton = new LanguageButton();
        this.languageButton.addMouseListener(this.STATUS_BAR_LISTENER);
        this.updateLanguage();
    }

    private void createFirewallLabel() {
        this.firewallStatus = new JLabel();
        this.updateFirewall();
        this.firewallStatus.setMinimumSize(new Dimension(20, 20));
        this.firewallStatus.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void createBandwidthLabel() {
        this.bandwidthUsageDown = new LazyTooltip(GUIMediator.getThemeImage("downloading_small"));
        this.bandwidthUsageUp = new LazyTooltip(GUIMediator.getThemeImage("uploading_small"));
        this.bandwidthUsageDown.setMinimumSize(new Dimension(60, 20));
        this.bandwidthUsageUp.setMinimumSize(new Dimension(60, 20));
        this.bandwidthUsageDown.addMouseListener(this.STATUS_BAR_LISTENER);
        this.bandwidthUsageUp.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void createCenterPanel() {
        this.STATUS_COMPONENT = new StatusComponent();
        this.centerComponent = new JLabel();
        this.centerPanel = new JPanel(new GridBagLayout());
        this.centerPanel.setOpaque(false);
        this.STATUS_COMPONENT.setProgressPreferredSize(new Dimension(250, 20));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.anchor = 10;
        this.centerPanel.add((Component)this.STATUS_COMPONENT, gbc);
        this.centerPanel.addMouseListener(this.STATUS_BAR_LISTENER);
        this.STATUS_COMPONENT.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void updateCenterPanel() {
        long now = System.currentTimeMillis();
        if (this._nextUpdateTime > now) {
            return;
        }
        this._nextUpdateTime = now + 5000L;
        this.centerPanel.removeAll();
        this.centerComponent = new JLabel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 10;
        this.centerPanel.add(this.centerComponent, gbc);
        this.refresh();
    }

    private void updateSeedingStatus() {
        boolean seedingStatus = SharingSettings.SEED_FINISHED_TORRENTS.getValue();
        this.seedingStatusButton.setText("<html><b>" + (seedingStatus ? I18n.tr("Seeding") : I18n.tr("Not Seeding")) + "</b></html>");
        this.seedingStatusButton.setIcon(seedingStatus ? GUIMediator.getThemeImage("seeding_small") : GUIMediator.getThemeImage("not_seeding_small"));
    }

    void setStatusText(String text) {
        GUIMediator.safeInvokeAndWait(() -> this.STATUS_COMPONENT.setText(text));
    }

    private void updateFirewallLabel(boolean notFirewalled) {
        if (notFirewalled) {
            this.firewallStatus.setIcon(GUIMediator.getThemeImage("firewall_no"));
            this.firewallStatus.setToolTipText(I18n.tr("FrostWire has not detected a firewall"));
        } else {
            this.firewallStatus.setIcon(GUIMediator.getThemeImage("firewall"));
            this.firewallStatus.setToolTipText(I18n.tr("FrostWire has detected a firewall"));
        }
    }

    void updateLanguage() {
        this.languageButton.updateLanguageFlag();
    }

    private void updateFirewall() {
        try {
            BTEngine engine = BTEngine.getInstance();
            this.updateFirewallLabel(!engine.isFirewalled());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void updateBandwidth() {
        try {
            String sDown = GUIUtils.rate2speed(GUIMediator.instance().getBTDownloadMediator().getDownloadsBandwidth());
            String sUp = GUIUtils.rate2speed(GUIMediator.instance().getBTDownloadMediator().getUploadsBandwidth());
            int downloads = GUIMediator.instance().getCurrentDownloads();
            int uploads = GUIMediator.instance().getCurrentUploads();
            this.bandwidthUsageDown.setText(downloads + " @ " + sDown);
            this.bandwidthUsageUp.setText(uploads + " @ " + sUp);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void loadFinished() {
        this.updateCenterPanel();
        this.centerPanel.revalidate();
        this.centerPanel.repaint();
        this.refresh();
    }

    private void updateTheme() {
        this._connectionQualityMeterIcons[0] = GUIMediator.getThemeImage("connect_small_0");
        this._connectionQualityMeterIcons[1] = GUIMediator.getThemeImage("connect_small_6");
    }

    void setConnectionQuality(int quality) {
        if (quality >= this._connectionQualityMeterIcons.length) {
            quality = this._connectionQualityMeterIcons.length - 1;
        }
        this.connectionQualityMeter.setIcon(this._connectionQualityMeterIcons[quality]);
        String status = null;
        String tip = null;
        switch (quality) {
            case 0: {
                status = I18n.tr("Disconnected");
                tip = I18n.tr("Check your internet connection, FrostWire can't connect.");
                break;
            }
            case 1: {
                status = I18n.tr("Turbo-Charged");
                tip = I18n.tr("Your connection to the network is extremely strong");
            }
        }
        long dhtNodes = BTEngine.getInstance().dhtNodes();
        if (dhtNodes > 0L) {
            String updatedToolTip = tip + ". (DHT: " + dhtNodes + " " + I18n.tr("nodes") + ")";
            this.connectionQualityMeter.setToolTipText(updatedToolTip);
        } else {
            this.connectionQualityMeter.setToolTipText(tip);
        }
        this.connectionQualityMeter.setText(status);
    }

    public JComponent getComponent() {
        if (this.BAR == null) {
            this.BAR = new JPanel(new GridBagLayout());
        }
        return this.BAR;
    }

    private BooleanSetting getLanguageSetting() {
        if (GUIMediator.isEnglishLocale()) {
            return StatusBarSettings.LANGUAGE_DISPLAY_ENGLISH_ENABLED;
        }
        return StatusBarSettings.LANGUAGE_DISPLAY_ENABLED;
    }

    @Override
    public void onStatusUpdated(boolean vpnIsOn) {
        this.refresh();
    }

    private class SettingsButtonAction
    extends AbstractAction {
        SettingsButtonAction() {
            this.putValue("Name", I18n.tr("Settings"));
            this.putValue("Name", I18n.tr("Settings"));
            this.putValue("LimeShortName", I18n.tr("Settings"));
            this.putValue("ShortDescription", I18n.tr("Settings"));
            this.putValue("LimeIconName", "SETTINGS_GEAR");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsMediator options;
            options.setOptionsVisible(!(options = OptionsMediator.instance()).isOptionsVisible());
        }
    }

    private class LazyTooltip
    extends JLabel {
        LazyTooltip(ImageIcon icon) {
            super(icon);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public String getToolTipText() {
            BTDownloadMediator btDownloadMediator = GUIMediator.instance().getBTDownloadMediator();
            String sDown = GUIUtils.rate2speed(btDownloadMediator.getDownloadsBandwidth());
            String sUp = GUIUtils.rate2speed(btDownloadMediator.getUploadsBandwidth());
            String totalDown = GUIUtils.getBytesInHuman(btDownloadMediator.getTotalBytesDownloaded());
            String totalUp = GUIUtils.getBytesInHuman(btDownloadMediator.getTotalBytesUploaded());
            int downloads = GUIMediator.instance().getCurrentDownloads();
            int uploads = GUIMediator.instance().getCurrentUploads();
            return "<html><table><tr><td>" + I18n.tr("Downloads:") + "</td><td>" + downloads + "</td><td>@</td><td align=right>" + sDown + "</td></tr><tr><td>" + I18n.tr("Uploads:") + "</td><td>" + uploads + "</td><td>@</td><td align=right>" + sUp + "</td></tr><tr><td>" + I18n.tr("Total Downstream:") + "</td><td>" + totalDown + "</td></tr><tr><td>" + I18n.tr("Total Upstream:") + "</td><td>" + totalUp + "</td></tr></table></html>";
        }
    }

    private class ShowDonationButtonsAction
    extends AbstractAction {
        ShowDonationButtonsAction() {
            this.putValue("Name", I18n.tr("Show Donation Buttons"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StatusBarSettings.DONATION_BUTTONS_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }

    private class ShowBandwidthConsumptionAction
    extends AbstractAction {
        ShowBandwidthConsumptionAction() {
            this.putValue("Name", I18n.tr("Show Bandwidth Consumption"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }

    private class ShowFirewallStatusAction
    extends AbstractAction {
        ShowFirewallStatusAction() {
            this.putValue("Name", I18n.tr("Show Firewall Status"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StatusBarSettings.FIREWALL_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }

    private class ShowLanguageStatusAction
    extends AbstractAction {
        ShowLanguageStatusAction() {
            this.putValue("Name", I18n.tr("Show Language Status"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BooleanSetting setting = StatusLine.this.getLanguageSetting();
            setting.invert();
            StatusBarSettings.LANGUAGE_DISPLAY_ENABLED.setValue(setting.getValue());
            StatusBarSettings.LANGUAGE_DISPLAY_ENGLISH_ENABLED.setValue(setting.getValue());
            StatusLine.this.refresh();
        }
    }

    private class ShowVPNAction
    extends AbstractAction {
        ShowVPNAction() {
            this.putValue("Name", I18n.tr("Show Connection Privacy Status"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StatusBarSettings.VPN_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }

    private class ShowConnectionQualityAction
    extends AbstractAction {
        ShowConnectionQualityAction() {
            this.putValue("Name", I18n.tr("Show Connection Quality"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StatusBarSettings.CONNECTION_QUALITY_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }
}

