/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Font;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.limewire.util.StringUtils;

public final class ResourceManager {
    private static final String GUI_PATH = "org/limewire/gui/";
    private static final String RESOURCES_PATH = "org/limewire/gui/resources/";
    private static final String IMAGES_PATH = "org/limewire/gui/images/";
    private static final Map<String, ImageIcon> THEME_IMAGES = new HashMap<String, ImageIcon>();
    private static ResourceManager _instance;
    private static boolean _localeOptionsSet;
    private static Locale _locale;
    private static boolean loadFailureEncountered;

    private ResourceManager() {
    }

    static void resetLocaleOptions() {
        _localeOptionsSet = false;
        ResourceManager.setLocaleOptions();
    }

    private static void setLocaleOptions() {
        if (!_localeOptionsSet) {
            if (ApplicationSettings.LANGUAGE.getValue().equals("")) {
                ApplicationSettings.LANGUAGE.setValue("en");
            }
            _locale = new Locale.Builder().setLanguage(ApplicationSettings.LANGUAGE.getValue()).setRegion(ApplicationSettings.COUNTRY.getValue()).setVariant(ApplicationSettings.LOCALE_VARIANT.getValue()).build();
            StringUtils.setLocale(_locale);
            I18n.setLocale(_locale);
            _localeOptionsSet = true;
        }
    }

    static Locale getLocale() {
        return _locale;
    }

    static boolean hasLoadFailure() {
        return loadFailureEncountered;
    }

    static void resetLoadFailure() {
        loadFailureEncountered = false;
    }

    static ImageIcon getThemeImage(String name) {
        if (name == null) {
            throw new NullPointerException("null image name");
        }
        ImageIcon icon = THEME_IMAGES.get(name);
        if (icon != null) {
            return icon;
        }
        icon = ResourceManager.getImageFromURL(IMAGES_PATH + name, false);
        if (icon != null && icon.getImage() != null) {
            THEME_IMAGES.put(name, icon);
            return icon;
        }
        throw new MissingResourceException("image: " + name + " doesn't exist.", null, null);
    }

    static ImageIcon getImageFromResourcePath(String loc) {
        return ResourceManager.getImageFromURL(loc, false);
    }

    private static ImageIcon getImageFromURL(String location, boolean file) {
        URL img = ResourceManager.toURL(location, file);
        if (img != null) {
            return new ImageIcon(img);
        }
        img = ResourceManager.toURL(location + ".png", file);
        if (img != null) {
            return new ImageIcon(img);
        }
        img = ResourceManager.toURL(location + ".gif", file);
        if (img != null) {
            return new ImageIcon(img);
        }
        return null;
    }

    private static URL toURL(String location, boolean file) {
        if (file) {
            File f = new File(location);
            if (f.exists()) {
                try {
                    return f.toURI().toURL();
                }
                catch (MalformedURLException murl) {
                    return null;
                }
            }
            return null;
        }
        return ResourceManager.getURL(location);
    }

    public static URL getURLResource(String FILE_NAME) {
        return ResourceManager.getURL(RESOURCES_PATH + FILE_NAME);
    }

    private static URL getURL(String PATH) {
        ClassLoader cl = ResourceManager.class.getClassLoader();
        if (cl == null) {
            return ClassLoader.getSystemResource(PATH);
        }
        URL url = cl.getResource(PATH);
        if (url == null) {
            return ClassLoader.getSystemResource(PATH);
        }
        return url;
    }

    public static synchronized ResourceManager instance() {
        if (_instance == null) {
            _instance = new ResourceManager();
        }
        return _instance;
    }

    private static boolean checkUIFonts(String newFont, String testString) {
        String[] comps = new String[]{"TextField.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "FormattedTextField.font", "Button.font", "CheckBox.font", "RadioButton.font", "ToggleButton.font", "ProgressBar.font", "ComboBox.font", "InternalFrame.titleFont", "DesktopIcon.font", "TitledBorder.font", "Label.font", "List.font", "TabbedPane.font", "Table.font", "TableHeader.font", "MenuBar.font", "Menu.font", "Menu.acceleratorFont", "MenuItem.font", "MenuItem.acceleratorFont", "PopupMenu.font", "CheckBoxMenuItem.font", "CheckBoxMenuItem.acceleratorFont", "RadioButtonMenuItem.font", "RadioButtonMenuItem.acceleratorFont", "Spinner.font", "Tree.font", "ToolBar.font", "OptionPane.messageFont", "OptionPane.buttonFont", "ToolTip.font"};
        boolean displayable = false;
        for (String comp : comps) {
            displayable |= ResourceManager.checkFont(comp, newFont, testString, false);
        }
        for (Map.Entry entry2 : UIManager.getDefaults().entrySet()) {
            Font f;
            if (!(entry2.getValue() instanceof Font) || (f = (Font)entry2.getValue()) == null || newFont.equalsIgnoreCase(f.getName()) || GUIUtils.canDisplay(f, testString) || !GUIUtils.canDisplay(f = new Font(newFont, f.getStyle(), f.getSize()), testString)) continue;
            entry2.setValue(f);
            displayable = true;
        }
        return displayable;
    }

    private static boolean checkFont(String fontName, String newName, String testString, boolean force) {
        boolean displayable = true;
        Font f = UIManager.getFont(fontName);
        if (f != null && !newName.equalsIgnoreCase(f.getName())) {
            if (!GUIUtils.canDisplay(f, testString) || force) {
                if (GUIUtils.canDisplay(f = new Font(newName, f.getStyle(), f.getSize()), testString)) {
                    UIManager.put(fontName, f);
                } else {
                    displayable = false;
                }
            }
        } else {
            displayable = f != null ? GUIUtils.canDisplay(f, testString) : false;
        }
        return displayable;
    }

    static ComponentUI getNativeUI(JComponent c) {
        ComponentUI ret = null;
        String name = UIManager.getSystemLookAndFeelClassName();
        if (name != null) {
            try {
                Class<?> clazz = Class.forName(name);
                LookAndFeel lf = (LookAndFeel)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                lf.initialize();
                UIDefaults def = lf.getDefaults();
                ret = def.getUI(c);
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (ret == null) {
            ret = UIManager.getUI(c);
        }
        return ret;
    }

    public boolean isTrayIconAvailable() {
        return (OSUtils.isWindows() || OSUtils.isLinux()) && NotifyUserProxy.instance().supportsSystemTray();
    }

    static {
        loadFailureEncountered = false;
        ResourceManager.resetLocaleOptions();
    }
}

