/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.service.Switch;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.HTMLLabel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.limewire.setting.IntSetting;

public final class MessageService {
    private static final int REMEMBER_ANSWER = 1;
    private static final int FORGET_ANSWER = 0;
    private static final MessageService INSTANCE = new MessageService();
    private final Map<String, JDialog> _disposableMessageMap = new HashMap<String, JDialog>();

    private MessageService() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Messages..."));
    }

    public static MessageService instance() {
        return INSTANCE;
    }

    public static Component getParentComponent() {
        if (GUIMediator.isOptionsVisible()) {
            return GUIMediator.getMainOptionsComponent();
        }
        return GUIMediator.getAppFrame();
    }

    public final void showError(String message) {
        GUIMediator.safeInvokeLater(() -> {
            JOptionPane optionPane = new JOptionPane();
            optionPane.setMessageType(0);
            JEditorPane editorPane = new JEditorPane();
            editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            editorPane.setEditable(false);
            editorPane.setOpaque(false);
            editorPane.setFont(new Font("Arial", 0, 12));
            editorPane.setContentType("text/html");
            editorPane.addHyperlinkListener(e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    GUIMediator.openURL(e.getURL().toString());
                }
            });
            editorPane.setText(message);
            optionPane.setMessage(editorPane);
            optionPane.setOpaque(true);
            JDialog dialog = optionPane.createDialog(MessageService.getParentComponent(), I18n.tr("Error"));
            dialog.setVisible(true);
        });
    }

    final void showError(String message, Switch ignore) {
        if (!ignore.getValue()) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(MessageService.getParentComponent(), this.doNotDisplayAgainLabel(message, ignore), I18n.tr("Error"), 0));
        }
    }

    final void showWarning(String message, Switch ignore) {
        if (!ignore.getValue()) {
            GUIMediator.safeInvokeLater(() -> JOptionPane.showMessageDialog(MessageService.getParentComponent(), this.doNotDisplayAgainLabel(message, ignore), I18n.tr("Warning"), 2));
        }
    }

    final void showWarning(String message) {
        GUIMediator.safeInvokeLater(() -> JOptionPane.showMessageDialog(MessageService.getParentComponent(), this.getLabel(message), I18n.tr("Warning"), 2));
    }

    public final void showMessage(Component toDisplay) {
        GUIMediator.safeInvokeLater(() -> JOptionPane.showMessageDialog(MessageService.getParentComponent(), toDisplay, I18n.tr("Message"), 1));
    }

    final void showMessage(String message) {
        GUIMediator.safeInvokeLater(() -> JOptionPane.showMessageDialog(MessageService.getParentComponent(), this.getLabel(message), I18n.tr("Message"), 1));
    }

    final void showMessage(String message, Switch ignore) {
        if (!ignore.getValue()) {
            GUIMediator.safeInvokeLater(() -> JOptionPane.showMessageDialog(MessageService.getParentComponent(), this.doNotDisplayAgainLabel(message, ignore), I18n.tr("Message"), 1));
        }
    }

    final void showDisposableMessage(String dialogKey, String message, int msgType) {
        this.showDisposableMessage(dialogKey, message, null, msgType);
    }

    final void showDisposableMessage(String dialogKey, String message, Switch ignore, int msgType) {
        String finalTitle = switch (msgType) {
            case 0 -> I18n.tr("Error");
            case 2 -> I18n.tr("Warning");
            case -1, 1 -> I18n.tr("Message");
            default -> throw new IllegalArgumentException("Unsupported Message Type: " + msgType);
        };
        if (ignore == null || !ignore.getValue()) {
            GUIMediator.safeInvokeLater(() -> {
                if (this._disposableMessageMap.containsKey(dialogKey)) {
                    JDialog dialog = this._disposableMessageMap.get(dialogKey);
                    dialog.toFront();
                    dialog.setVisible(true);
                } else {
                    Object component = message;
                    if (ignore != null) {
                        component = this.doNotDisplayAgainLabel(message, ignore);
                    }
                    JOptionPane pane = new JOptionPane(component, msgType);
                    JDialog dialog = pane.createDialog(MessageService.getParentComponent(), finalTitle);
                    dialog.setModal(true);
                    this._disposableMessageMap.put(dialogKey, dialog);
                    dialog.setVisible(true);
                    this._disposableMessageMap.remove(dialogKey);
                }
            });
        }
    }

    final void hideDisposableMessage(String dialogKey) {
        GUIMediator.safeInvokeLater(() -> {
            JDialog dialog = this._disposableMessageMap.get(dialogKey);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
    }

    final void showConfirmMessage(String message) {
        GUIMediator.safeInvokeLater(() -> JOptionPane.showConfirmDialog(MessageService.getParentComponent(), this.getLabel(message), I18n.tr("Message"), 1));
    }

    final void showConfirmMessage(String message, Switch ignore) {
        if (!ignore.getValue()) {
            GUIMediator.safeInvokeLater(() -> JOptionPane.showConfirmDialog(MessageService.getParentComponent(), this.doNotDisplayAgainLabel(message, ignore), I18n.tr("Message"), 1));
        }
    }

    final DialogOption showYesNoMessage(String message, DialogOption defaultOption) {
        return this.showYesNoMessage(message, I18n.tr("Message"), defaultOption);
    }

    final DialogOption showYesNoMessage(String message) {
        return this.showYesNoMessage(message, I18n.tr("Message"));
    }

    final int showConfirmListMessage(String message, Object[] listModel, int messageType, ListCellRenderer<Object> listRenderer) {
        return this.showConfirmListMessage(message, listModel, messageType, listRenderer, I18n.tr("Message"));
    }

    private int showConfirmListMessage(String message, Object[] listModel, int messageType, ListCellRenderer<Object> listRenderer, String title) {
        JList<Object> list = new JList<Object>(listModel);
        list.setVisibleRowCount(5);
        list.setSelectionForeground(list.getForeground());
        list.setSelectionBackground(list.getBackground());
        list.setFocusable(false);
        if (listRenderer != null) {
            list.setCellRenderer(listRenderer);
        }
        Object[] content = new Object[]{new MultiLineLabel(message, 400), Box.createVerticalStrut(6), new JScrollPane(list)};
        return JOptionPane.showConfirmDialog(MessageService.getParentComponent(), content, title, messageType);
    }

    private DialogOption showYesNoMessage(String message, String title) {
        return this.showYesNoMessage(message, title, DialogOption.YES);
    }

    final DialogOption showYesNoMessage(String message, String title, int msgType) {
        return this.showYesNoMessage(message, title, msgType, DialogOption.YES);
    }

    final DialogOption showYesNoMessage(String message, String title, DialogOption defaultOption) {
        return this.showYesNoMessage(message, title, 2, defaultOption);
    }

    private DialogOption showYesNoMessage(String message, String title, int msgType, DialogOption defaultOption) {
        int option;
        Object[] options = new String[]{DialogOption.YES.getText(), DialogOption.NO.getText()};
        try {
            option = JOptionPane.showOptionDialog(MessageService.getParentComponent(), this.getLabel(message), title, 0, msgType, null, options, defaultOption.getText());
        }
        catch (InternalError ie) {
            option = 1;
        }
        if (option == 0) {
            return DialogOption.YES;
        }
        return DialogOption.NO;
    }

    final DialogOption showYesNoMessage(String message, IntSetting defValue) {
        return this.showYesNoMessage(message, defValue, DialogOption.YES);
    }

    final DialogOption showYesNoMessage(String message, IntSetting defValue, DialogOption defaultOption) {
        int option;
        Object[] options = new String[]{DialogOption.YES.getText(), DialogOption.NO.getText()};
        DialogOption ret = DialogOption.parseInt(defValue.getValue());
        if (ret == DialogOption.YES || ret == DialogOption.NO) {
            return ret;
        }
        try {
            option = JOptionPane.showOptionDialog(MessageService.getParentComponent(), this.alwaysUseThisAnswerLabel(message, defValue), I18n.tr("Message"), 0, 2, null, options, defaultOption.getText());
        }
        catch (ArrayIndexOutOfBoundsException | InternalError aioobe) {
            option = 1;
        }
        ret = option == 0 ? DialogOption.YES : DialogOption.NO;
        if (defValue.getValue() == 1) {
            defValue.setValue(ret.toInt());
        } else {
            defValue.setValue(0);
        }
        return ret;
    }

    final DialogOption showYesNoCancelMessage(String message) {
        int option;
        try {
            option = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), this.getLabel(message), I18n.tr("Message"), 1);
        }
        catch (InternalError ie) {
            option = 1;
        }
        if (option == 0) {
            return DialogOption.YES;
        }
        if (option == 1) {
            return DialogOption.NO;
        }
        return DialogOption.CANCEL;
    }

    final DialogOption showYesNoCancelMessage(String message, IntSetting defValue) {
        int option;
        DialogOption ret = DialogOption.parseInt(defValue.getValue());
        if (ret == DialogOption.YES || ret == DialogOption.NO) {
            return ret;
        }
        try {
            option = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), this.alwaysUseThisAnswerLabel(message, defValue), I18n.tr("Message"), 1);
        }
        catch (ArrayIndexOutOfBoundsException | InternalError aioobe) {
            option = 2;
        }
        ret = option == 0 ? DialogOption.YES : (option == 1 ? DialogOption.NO : DialogOption.CANCEL);
        if (defValue.getValue() == 1 && ret != DialogOption.CANCEL) {
            defValue.setValue(ret.toInt());
        } else {
            defValue.setValue(0);
        }
        return ret;
    }

    final DialogOption showYesNoOtherMessage(String message, IntSetting defValue, String otherName) {
        int option;
        Object[] options = new String[]{DialogOption.YES.getText(), DialogOption.NO.getText(), otherName};
        DialogOption ret = DialogOption.parseInt(defValue.getValue());
        if (ret == DialogOption.YES || ret == DialogOption.NO) {
            return ret;
        }
        try {
            option = JOptionPane.showOptionDialog(MessageService.getParentComponent(), this.alwaysUseThisAnswerLabel(message, defValue), I18n.tr("Message"), 0, 2, null, options, DialogOption.YES.getText());
        }
        catch (ArrayIndexOutOfBoundsException | InternalError aioobe) {
            option = -1;
        }
        ret = option == 0 ? DialogOption.YES : (option == 1 ? DialogOption.NO : (option == 2 ? DialogOption.OTHER : DialogOption.CANCEL));
        if (defValue.getValue() == 1 && ret != DialogOption.OTHER && ret != DialogOption.CANCEL) {
            defValue.setValue(ret.toInt());
        } else {
            defValue.setValue(0);
        }
        return ret;
    }

    final String showInputMessage(String message, String initialValue) {
        if (initialValue == null) {
            return JOptionPane.showInputDialog(MessageService.getParentComponent(), (Object)message);
        }
        return JOptionPane.showInputDialog(MessageService.getParentComponent(), message, initialValue);
    }

    private JComponent getLabel(String message) {
        if (message.startsWith("<html")) {
            return new HTMLLabel(message);
        }
        return new MultiLineLabel(message, 400);
    }

    private JComponent doNotDisplayAgainLabel(String message, Switch setting) {
        JPanel thePanel = new JPanel(new BorderLayout(0, 15));
        JCheckBox option = new JCheckBox(I18n.tr("Do not display this message again"));
        JComponent lbl = this.getLabel(message);
        thePanel.add((Component)lbl, "North");
        thePanel.add((Component)option, "West");
        option.addItemListener(e -> setting.setValue(e.getStateChange() == 1));
        return thePanel;
    }

    private JComponent alwaysUseThisAnswerLabel(String message, IntSetting setting) {
        JPanel thePanel = new JPanel(new BorderLayout(0, 15));
        JCheckBox option = new JCheckBox(I18n.tr("Always use this answer"));
        JComponent lbl = this.getLabel(message);
        thePanel.add((Component)lbl, "North");
        thePanel.add((Component)option, "West");
        option.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                setting.setValue(1);
            } else {
                setting.setValue(0);
            }
        });
        return thePanel;
    }
}

