/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.gui.searchfield.PromptSupport;
import com.frostwire.gui.theme.SkinMenuItem;
import com.frostwire.gui.theme.SkinPopupMenu;
import com.frostwire.gui.theme.ThemeMediator;
import com.limegroup.gnutella.gui.I18n;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class LimeTextField
extends JTextField {
    private static final long serialVersionUID = -1994520183255049424L;
    private static final Action UNDO_ACTION = new FieldAction(I18n.tr("Undo")){
        private static final long serialVersionUID = 675409703997007078L;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getField(e).undo();
        }
    };
    private static final Action CUT_ACTION = new FieldAction(I18n.tr("Cut")){
        private static final long serialVersionUID = 5342970192703043838L;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getField(e).cut();
        }
    };
    private static final Action COPY_ACTION = new FieldAction(I18n.tr("Copy")){
        private static final long serialVersionUID = -3484207766103231841L;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getField(e).copy();
        }
    };
    private static final Action PASTE_ACTION = new FieldAction(I18n.tr("Paste")){
        private static final long serialVersionUID = -967931044746884556L;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getField(e).paste();
        }
    };
    private static final Action DELETE_ACTION = new FieldAction(I18n.tr("Delete")){
        private static final long serialVersionUID = -1239306786560704952L;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getField(e).replaceSelection("");
        }
    };
    private static final Action SELECT_ALL_ACTION = new FieldAction(I18n.tr("Select All")){
        private static final long serialVersionUID = 4783056991868525860L;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getField(e).selectAll();
        }
    };
    private static final JPopupMenu POPUP = LimeTextField.createPopup();
    private UndoManager undoManager;

    public LimeTextField() {
        this.init();
    }

    public LimeTextField(String text) {
        super(text);
        this.init();
    }

    public LimeTextField(int columns) {
        super(columns);
        this.init();
    }

    public LimeTextField(String text, int columns) {
        super(text, columns);
        this.init();
    }

    public LimeTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.init();
    }

    private static JPopupMenu createPopup() {
        SkinPopupMenu popup = new SkinPopupMenu(){
            private static final long serialVersionUID = -6004124495511263059L;

            @Override
            public void show(Component invoker, int x, int y) {
                ((LimeTextField)invoker).updateActions();
                super.show(invoker, x, y);
            }
        };
        popup.add(new SkinMenuItem(UNDO_ACTION));
        ((JPopupMenu)popup).addSeparator();
        popup.add(new SkinMenuItem(CUT_ACTION));
        popup.add(new SkinMenuItem(COPY_ACTION));
        popup.add(new SkinMenuItem(PASTE_ACTION));
        popup.add(new SkinMenuItem(DELETE_ACTION));
        ((JPopupMenu)popup).addSeparator();
        popup.add(new SkinMenuItem(SELECT_ALL_ACTION));
        return popup;
    }

    public void setPrompt(String promptText) {
        PromptSupport.setPrompt(promptText, this);
    }

    private void undo() {
        try {
            if (this.undoManager != null) {
                this.undoManager.undoOrRedo();
            }
        }
        catch (CannotRedoException | CannotUndoException runtimeException) {
            // empty catch block
        }
    }

    private UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void setDocument(Document doc) {
        if (doc != this.getDocument()) {
            this.undoManager = null;
        }
        super.setDocument(doc);
    }

    private void init() {
        this.setComponentPopupMenu(POPUP);
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1);
        this.getDocument().addUndoableEditListener(this.undoManager);
        ThemeMediator.fixKeyStrokes(this);
    }

    private void updateActions() {
        String selectedText = this.getSelectedText();
        if (selectedText == null) {
            selectedText = "";
        }
        boolean stuffSelected = !selectedText.equals("");
        boolean allSelected = selectedText.equals(this.getText());
        UNDO_ACTION.setEnabled(this.isEnabled() && this.isEditable() && this.isUndoAvailable());
        CUT_ACTION.setEnabled(this.isEnabled() && this.isEditable() && stuffSelected);
        COPY_ACTION.setEnabled(this.isEnabled() && stuffSelected);
        PASTE_ACTION.setEnabled(this.isEnabled() && this.isEditable() && this.isPasteAvailable());
        DELETE_ACTION.setEnabled(this.isEnabled() && stuffSelected);
        SELECT_ALL_ACTION.setEnabled(this.isEnabled() && !allSelected);
    }

    private boolean isUndoAvailable() {
        return this.getUndoManager() != null && this.getUndoManager().canUndoOrRedo();
    }

    private boolean isPasteAvailable() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            return clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
        }
        catch (IllegalStateException | UnsupportedOperationException he) {
            return false;
        }
    }

    private static abstract class FieldAction
    extends AbstractAction {
        private static final long serialVersionUID = -2088365927213389348L;

        FieldAction(String name) {
            super(I18n.tr(name));
        }

        LimeTextField getField(ActionEvent e) {
            JMenuItem source2 = (JMenuItem)e.getSource();
            JPopupMenu menu = (JPopupMenu)source2.getParent();
            return (LimeTextField)menu.getInvoker();
        }
    }
}

