/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import org.limewire.util.SystemUtils;

public class LimeJFrame
extends JFrame {
    public LimeJFrame() throws HeadlessException {
        this.initialize();
    }

    public LimeJFrame(GraphicsConfiguration gc) {
        super(gc);
        this.initialize();
    }

    public LimeJFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initialize();
    }

    public LimeJFrame(String title) throws HeadlessException {
        super(title);
        this.initialize();
    }

    private static List<JPopupMenu> getPopups() {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        MenuElement[] p = msm.getSelectedPath();
        ArrayList<JPopupMenu> list = new ArrayList<JPopupMenu>(p.length);
        for (MenuElement element : p) {
            if (!(element instanceof JPopupMenu)) continue;
            list.add((JPopupMenu)element);
        }
        return list;
    }

    private void initialize() {
        ImageIcon limeIcon = GUIMediator.getThemeImage("frostwire64x64");
        this.setIconImage(limeIcon.getImage());
        if (OSUtils.isMacOSX()) {
            this.setupPopupHide();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SystemUtils.setWindowIcon(this, GUIConstants.FROSTWIRE_EXE_FILE);
    }

    private void setupPopupHide() {
        this.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowDeactivated(WindowEvent e) {
                for (JPopupMenu menu : LimeJFrame.getPopups()) {
                    menu.setVisible(false);
                }
            }
        });
    }
}

