/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.ImageManipulator;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class IconButton
extends JButton {
    private String message;
    private String iconName;
    private String rollOverIconName;
    private boolean horizontalText;
    private boolean useTransparentBackground;
    private int resizedWidth = -1;
    private int resizedHeight = -1;
    private final boolean initialized;
    private PropertyChangeListener listener = null;
    private boolean iconOnly;

    IconButton(String text, String iconName, boolean horizontalTextPlacement) {
        this(text, iconName);
        this.horizontalText = horizontalTextPlacement;
        this.useTransparentBackground = true;
    }

    IconButton(String text, String iconName) {
        this.setRolloverEnabled(true);
        this.iconName = iconName;
        this.message = text;
        this.initialized = true;
        this.useTransparentBackground = true;
        this.updateButton();
    }

    IconButton(String iconName) {
        this.setRolloverEnabled(true);
        this.iconName = iconName;
        this.message = "";
        this.iconOnly = true;
        this.initialized = true;
        this.useTransparentBackground = true;
        this.updateButton();
    }

    public IconButton(String iconName, int w, int h) {
        this(iconName);
        this.resizedWidth = w;
        this.resizedHeight = h;
        this.updateButton();
    }

    public IconButton(Action action) {
        super(action);
        this.setRolloverEnabled(true);
        this.initialized = true;
        this.useTransparentBackground = true;
        this.updateButton();
    }

    @Override
    public void setAction(Action a) {
        Action oldAction = this.getAction();
        if (oldAction != null) {
            oldAction.removePropertyChangeListener(this.getListener());
        }
        super.setAction(a);
        this.setButtonFromAction(a);
        a.addPropertyChangeListener(this.getListener());
    }

    protected void setHorizontalText(boolean useHorizontalText) {
        this.horizontalText = useHorizontalText;
    }

    protected void setUseTransparentBackground(boolean transparentBackground) {
        this.useTransparentBackground = transparentBackground;
    }

    private void setButtonFromAction(Action action) {
        this.iconName = (String)action.getValue("LimeIconName");
        this.rollOverIconName = (String)action.getValue("RollOverFrostIconName");
        this.message = (String)action.getValue("LimeShortName");
        if (this.message == null) {
            this.message = (String)action.getValue("Name");
        }
        this.updateButton();
    }

    private PropertyChangeListener getListener() {
        if (this.listener == null) {
            this.listener = evt -> this.setButtonFromAction((Action)evt.getSource());
        }
        return this.listener;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateButton();
    }

    @Override
    public void setText(String text) {
        this.message = text;
        this.updateButton();
    }

    private void updateButton() {
        if (!this.initialized) {
            return;
        }
        Icon icon = IconManager.instance().getIconForButton(this.iconName);
        if (icon == null) {
            super.setText(this.message);
            this.setVerticalTextPosition(0);
            this.setHorizontalTextPosition(0);
            this.setContentAreaFilled(true);
            this.setBorderPainted(true);
            this.setOpaque(true);
        } else {
            if (this.resizedWidth > 0 && this.resizedHeight > 0) {
                icon = ImageManipulator.resize(icon, this.resizedWidth, this.resizedHeight);
            }
            this.setIcon(icon);
            Icon rollover = IconManager.instance().getIconForButton(this.rollOverIconName);
            if (rollover == null) {
                rollover = IconManager.instance().getRolloverIconForButton(this.iconName);
            }
            if (this.resizedHeight > 0 && this.resizedWidth > 0) {
                rollover = ImageManipulator.resize(rollover, this.resizedWidth, this.resizedHeight);
            }
            this.setRolloverIcon(rollover);
            if (!this.horizontalText) {
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
            } else {
                this.setVerticalTextPosition(0);
                this.setHorizontalTextPosition(11);
            }
            if (this.useTransparentBackground) {
                this.setBorderPainted(false);
                this.setOpaque(false);
                this.setContentAreaFilled(false);
            } else {
                this.setBorderPainted(true);
                this.setOpaque(false);
                this.setContentAreaFilled(true);
            }
            if (!this.iconOnly && UISettings.TEXT_WITH_ICONS.getValue() && this.message != null && this.message.length() > 0) {
                super.setText(this.message);
                this.setPreferredSize(null);
            } else {
                super.setText(null);
                int height = icon.getIconHeight();
                int width = icon.getIconWidth();
                if (this.message == null || this.message.length() > 0) {
                    height += 15;
                    width += 15;
                }
                this.setPreferredSize(new Dimension(height, width));
            }
        }
    }
}

