/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.concurrent.concurrent.ThreadExecutor;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.bugs.DeadlockBugManager;
import com.limegroup.gnutella.gui.bugs.DeadlockException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.limewire.util.VersionUtils;

class DeadlockSupport {
    private static final int DEADLOCK_CHECK_INTERVAL = 3001;
    private static final Logger LOG = Logger.getLogger(DeadlockSupport.class);

    DeadlockSupport() {
    }

    public static void startDeadlockMonitoring() {
        Thread t = ThreadExecutor.newManagedThread(() -> {
            ThreadInfo[] allThreadInfo;
            long[] ids;
            do {
                try {
                    Thread.sleep(3001L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ids = DeadlockSupport.findDeadlockedThreads(ManagementFactory.getThreadMXBean());
            } while (ids == null);
            StringBuilder sb = new StringBuilder("Deadlock Report:\n");
            StackTraceElement[] firstStackTrace = null;
            for (ThreadInfo info : allThreadInfo = DeadlockSupport.getThreadInfo(ids)) {
                sb.append("\"").append(info.getThreadName()).append("\" (id=").append(info.getThreadId()).append(")");
                sb.append(" ").append((Object)info.getThreadState()).append(" on ").append(info.getLockName()).append(" owned by ");
                sb.append("\"").append(info.getLockOwnerName()).append("\" (id=").append(info.getLockOwnerId()).append(")");
                if (info.isSuspended()) {
                    sb.append(" (suspended)");
                }
                if (info.isInNative()) {
                    sb.append(" (in native)");
                }
                sb.append("\n");
                StackTraceElement[] trace = info.getStackTrace();
                if (firstStackTrace == null) {
                    firstStackTrace = trace;
                }
                for (int i2 = 0; i2 < trace.length; ++i2) {
                    sb.append("\tat ").append(trace[i2].toString()).append("\n");
                    if (i2 == 0) {
                        DeadlockSupport.addLockInfo(info, sb);
                    }
                    DeadlockSupport.addMonitorInfo(info, sb, i2);
                }
                DeadlockSupport.addLockedSynchronizers(info, sb);
                sb.append("\n");
            }
            DeadlockException deadlock = new DeadlockException();
            if (firstStackTrace != null) {
                deadlock.setStackTrace(firstStackTrace);
            }
            DeadlockBugManager.handleDeadlock(deadlock, Thread.currentThread().getName(), sb.toString());
        });
        t.setDaemon(true);
        t.setName("Deadlock Detection Thread");
        t.start();
    }

    private static void addLockedSynchronizers(ThreadInfo info, StringBuilder sb) {
        if (VersionUtils.isJava16OrAbove()) {
            try {
                int length;
                Method m = ThreadInfo.class.getMethod("getLockedSynchronizers", new Class[0]);
                Object o = m.invoke((Object)info, new Object[0]);
                if (o != null && (length = Array.getLength(o)) > 0) {
                    sb.append("\n\tNumber of locked synchronizers = ").append(length).append("\n");
                    for (int i2 = 0; i2 < length; ++i2) {
                        sb.append("\t- ").append(Array.get(o, i2)).append("\n");
                    }
                }
            }
            catch (Throwable t) {
                LOG.info("Error retrieving locked synchronizers", t);
            }
        }
    }

    private static void addMonitorInfo(ThreadInfo info, StringBuilder sb, int stackDepth) {
        if (VersionUtils.isJava16OrAbove()) {
            try {
                Method m = ThreadInfo.class.getMethod("getLockedMonitors", new Class[0]);
                Object o = m.invoke((Object)info, new Object[0]);
                if (o != null) {
                    Class<?> monitorInfoClass = Class.forName("java.lang.management.MonitorInfo");
                    int length = Array.getLength(o);
                    for (int i2 = 0; i2 < length; ++i2) {
                        Object mi = Array.get(o, i2);
                        Method depthMethod = monitorInfoClass.getMethod("getLockedStackDepth", new Class[0]);
                        Object depth = depthMethod.invoke(mi, new Object[0]);
                        if (depth == null || !depth.equals(stackDepth)) continue;
                        sb.append("\t-  locked ").append(mi).append("\n");
                    }
                }
            }
            catch (Throwable t) {
                LOG.info("Error retrieving monitor info", t);
            }
        }
    }

    private static void addLockInfo(ThreadInfo info, StringBuilder sb) {
        if (VersionUtils.isJava16OrAbove()) {
            try {
                Method m = ThreadInfo.class.getMethod("getLockInfo", new Class[0]);
                Object o = m.invoke((Object)info, new Object[0]);
                if (o != null) {
                    Thread.State ts = info.getThreadState();
                    switch (ts) {
                        case BLOCKED: {
                            sb.append("\t-  blocked on ").append(o).append("\n");
                            break;
                        }
                        case WAITING: 
                        case TIMED_WAITING: {
                            sb.append("\t-  waiting on ").append(o).append("\n");
                            break;
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOG.info("Error calling getLockInfo", t);
            }
        }
    }

    private static long[] findDeadlockedThreads(ThreadMXBean bean) {
        if (VersionUtils.isJava16OrAbove()) {
            try {
                Method m = ThreadMXBean.class.getMethod("findDeadlockedThreads", new Class[0]);
                Object o = m.invoke((Object)bean, new Object[0]);
                if (o instanceof long[] || o == null) {
                    return (long[])o;
                }
            }
            catch (Throwable t) {
                LOG.error("Error calling findDeadlockedthreads", t);
            }
        }
        return bean.findMonitorDeadlockedThreads();
    }

    private static ThreadInfo[] getThreadInfo(long[] ids) {
        if (VersionUtils.isJava16OrAbove()) {
            try {
                Method m = ThreadMXBean.class.getDeclaredMethod("getThreadInfo", long[].class, Boolean.TYPE, Boolean.TYPE);
                Object o = m.invoke((Object)ManagementFactory.getThreadMXBean(), ids, true, true);
                return (ThreadInfo[])o;
            }
            catch (Throwable t) {
                LOG.info("Error retrieving detailed thread info", t);
            }
        }
        return ManagementFactory.getThreadMXBean().getThreadInfo(ids, Integer.MAX_VALUE);
    }
}

