/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class ButtonRow
extends JPanel {
    public static final int BUTTON_SEP = 6;
    public static final int X_AXIS = 0;
    private static final int Y_AXIS = 1;
    private static final int TOP_GLUE = 10;
    private static final int BOTTOM_GLUE = 11;
    public static final int LEFT_GLUE = 12;
    public static final int RIGHT_GLUE = 13;
    public static final int NO_GLUE = 14;
    private static final long serialVersionUID = 2171794172705055068L;
    private JButton[] _buttons;

    public ButtonRow(String[] labelKeys, String[] toolTipKeys, EventListener[] listeners, String[] iconNames) {
        this(labelKeys, toolTipKeys, listeners, iconNames, 0, 14);
    }

    public ButtonRow(String[] labelKeys, String[] toolTipKeys, EventListener[] listeners, int orientation, int glue) {
        this(labelKeys, toolTipKeys, listeners, null, orientation, glue);
    }

    private ButtonRow(String[] labelKeys, String[] toolTipKeys, EventListener[] listeners, String[] iconNames, int orientation, int glue) {
        int i2;
        if (labelKeys.length != listeners.length || toolTipKeys.length != listeners.length) {
            throw new IllegalArgumentException("invalid ButtonRow constructor: array lengths must be equal");
        }
        BoxLayout bl = new BoxLayout(this, orientation);
        this.setLayout(bl);
        int length = labelKeys.length;
        int sepLength = length - 1;
        this._buttons = new JButton[length];
        Component[] separators = new Component[sepLength];
        for (i2 = 0; i2 < length; ++i2) {
            String label = "";
            if (!"".equals(labelKeys[i2])) {
                label = I18n.tr(labelKeys[i2]);
            }
            this._buttons[i2] = iconNames != null && iconNames[i2] != null ? new IconButton(label, iconNames[i2]) : new JButton(label);
            if (toolTipKeys[i2] == null) continue;
            String tip = I18n.tr(toolTipKeys[i2]);
            this._buttons[i2].setToolTipText(tip);
        }
        this.setListeners(listeners);
        if (orientation == 0) {
            d = new Dimension(6, 0);
            for (i2 = 0; i2 < sepLength; ++i2) {
                separators[i2] = Box.createRigidArea(d);
            }
        } else {
            d = new Dimension(0, 6);
            while (i2 < sepLength) {
                separators[i2] = Box.createRigidArea(d);
                ++i2;
            }
        }
        i2 = 0;
        if (glue == 10 && orientation == 1) {
            this.add(Box.createVerticalGlue());
        } else if (glue == 12 && orientation == 0) {
            this.add(Box.createHorizontalGlue());
        } else if (glue == 14 && orientation == 0) {
            this.add(Box.createHorizontalGlue());
        }
        while (i2 < length) {
            this.add(this._buttons[i2]);
            if (i2 < sepLength) {
                this.add(separators[i2]);
            }
            ++i2;
        }
        if (glue == 11 && orientation == 1) {
            this.add(Box.createVerticalGlue());
        } else if (glue == 13 && orientation == 0) {
            this.add(Box.createHorizontalGlue());
        } else if (glue == 14 && orientation == 0) {
            this.add(Box.createHorizontalGlue());
        }
    }

    public ButtonRow(Action[] actions, int orientation, int glue) {
        this(actions, orientation, glue, null);
    }

    private ButtonRow(Action[] actions, int orientation, int glue, JComponent extraComponent) {
        int i2;
        BoxLayout bl = new BoxLayout(this, orientation);
        this.setLayout(bl);
        int sepLength = actions.length - 1;
        this._buttons = new JButton[actions.length];
        Component[] separators = new Component[sepLength];
        for (i2 = 0; i2 < actions.length; ++i2) {
            this._buttons[i2] = actions[i2].getValue("LimeIconName") != null ? new IconButton(actions[i2]) : new JButton(actions[i2]);
        }
        if (orientation == 0) {
            d = new Dimension(6, 0);
            for (i2 = 0; i2 < sepLength; ++i2) {
                separators[i2] = Box.createRigidArea(d);
            }
        } else {
            d = new Dimension(0, 6);
            while (i2 < sepLength) {
                separators[i2] = Box.createRigidArea(d);
                ++i2;
            }
        }
        i2 = 0;
        if (glue == 10 && orientation == 1) {
            this.add(Box.createVerticalGlue());
        } else if (glue == 12 && orientation == 0) {
            this.add(Box.createHorizontalGlue());
        } else if (glue == 14 && orientation == 0) {
            this.add(Box.createHorizontalGlue());
        }
        while (i2 < actions.length) {
            this.add(this._buttons[i2]);
            if (i2 < sepLength) {
                this.add(separators[i2]);
            }
            ++i2;
        }
        if (glue == 11 && orientation == 1) {
            this.add(Box.createVerticalGlue());
        } else if (glue == 13 && orientation == 0) {
            this.add(Box.createHorizontalGlue());
        } else if (glue == 14 && orientation == 0) {
            this.add(Box.createHorizontalGlue());
        }
        if (extraComponent != null) {
            this.add(extraComponent);
        }
    }

    private void setListeners(EventListener[] listeners) {
        int listenLength = listeners.length;
        int length = this._buttons.length;
        if (listenLength <= length) {
            for (int i2 = 0; i2 < length; ++i2) {
                if (listeners[i2] instanceof ActionListener) {
                    this._buttons[i2].addActionListener((ActionListener)listeners[i2]);
                    continue;
                }
                if (!(listeners[i2] instanceof MouseAdapter)) continue;
                this._buttons[i2].addMouseListener((MouseAdapter)listeners[i2]);
            }
        }
    }

    public JButton getButtonAtIndex(int index) {
        if (index >= this._buttons.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._buttons[index];
    }

    public void setButtonEnabled(int buttonIndex, boolean enabled) {
        if (buttonIndex >= this._buttons.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._buttons[buttonIndex].setEnabled(enabled);
    }

    public void setButtonsEnabled(boolean enabled) {
        for (JButton button : this._buttons) {
            button.setEnabled(enabled);
        }
    }
}

