/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;

public class AWTSplashWindow
extends Window {
    private static final long serialVersionUID = 720067738309164784L;
    private final Image splashImage;
    private volatile boolean paintCalled = false;

    private AWTSplashWindow(Frame owner, Image splashImage) {
        super(owner);
        int imgHeight;
        this.splashImage = splashImage;
        int imgWidth = splashImage.getWidth(this);
        if (imgWidth < 1) {
            imgWidth = 1;
        }
        if ((imgHeight = splashImage.getHeight(this)) < 1) {
            imgHeight = 1;
        }
        this.setSize(imgWidth, imgHeight);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenDim.width - imgWidth) / 2, (screenDim.height - imgHeight) / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Frame splash(Image splashImage) {
        Frame f = new Frame();
        AWTSplashWindow w = new AWTSplashWindow(f, splashImage);
        w.toFront();
        w.setVisible(true);
        if (!EventQueue.isDispatchThread()) {
            AWTSplashWindow aWTSplashWindow = w;
            synchronized (aWTSplashWindow) {
                while (!w.paintCalled) {
                    try {
                        w.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return f;
    }

    @Override
    public void update(Graphics g) {
        g.setColor(this.getForeground());
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        g.drawImage(this.splashImage, 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            AWTSplashWindow aWTSplashWindow = this;
            synchronized (aWTSplashWindow) {
                this.notifyAll();
            }
        }
    }
}

